/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax.events;

import com.sun.xml.internal.fastinfoset.stax.events.EmptyIterator;
import com.sun.xml.internal.fastinfoset.stax.events.EventBase;
import com.sun.xml.internal.fastinfoset.stax.events.ReadIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class StartElementEvent
extends EventBase
implements StartElement {
    private Map _attributes;
    private List _namespaces;
    private NamespaceContext _context = null;
    private QName _qname;

    public void reset() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
        if (this._namespaces != null) {
            this._namespaces.clear();
        }
        if (this._context != null) {
            this._context = null;
        }
    }

    public StartElementEvent() {
        this.init();
    }

    public StartElementEvent(String string, String string2, String string3) {
        this.init();
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        this._qname = new QName(string2, string3, string);
        this.setEventType(1);
    }

    public StartElementEvent(QName qName) {
        this.init();
        this._qname = qName;
    }

    public StartElementEvent(StartElement startElement) {
        this(startElement.getName());
        this.addAttributes(startElement.getAttributes());
        this.addNamespaces(startElement.getNamespaces());
    }

    protected void init() {
        this.setEventType(1);
        this._attributes = new HashMap();
        this._namespaces = new ArrayList();
    }

    public QName getName() {
        return this._qname;
    }

    public Iterator getAttributes() {
        if (this._attributes != null) {
            Collection collection = this._attributes.values();
            return new ReadIterator(collection.iterator());
        }
        return EmptyIterator.getInstance();
    }

    public Iterator getNamespaces() {
        if (this._namespaces != null) {
            return new ReadIterator(this._namespaces.iterator());
        }
        return EmptyIterator.getInstance();
    }

    public Attribute getAttributeByName(QName qName) {
        if (qName == null) {
            return null;
        }
        return (Attribute)this._attributes.get(qName);
    }

    public NamespaceContext getNamespaceContext() {
        return this._context;
    }

    public void setName(QName qName) {
        this._qname = qName;
    }

    public String getNamespace() {
        return this._qname.getNamespaceURI();
    }

    public String getNamespaceURI(String string) {
        if (this.getNamespace() != null) {
            return this.getNamespace();
        }
        if (this._context != null) {
            return this._context.getNamespaceURI(string);
        }
        return null;
    }

    public String toString() {
        Attribute attribute;
        Iterator iterator;
        String string = "<" + this.nameAsString();
        if (this._attributes != null) {
            iterator = this.getAttributes();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Attribute)iterator.next();
                string = string + " " + attribute.toString();
            }
        }
        if (this._namespaces != null) {
            iterator = this._namespaces.iterator();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Namespace)iterator.next();
                string = string + " " + attribute.toString();
            }
        }
        string = string + ">";
        return string;
    }

    public String nameAsString() {
        if ("".equals(this._qname.getNamespaceURI())) {
            return this._qname.getLocalPart();
        }
        if (this._qname.getPrefix() != null) {
            return "['" + this._qname.getNamespaceURI() + "']:" + this._qname.getPrefix() + ":" + this._qname.getLocalPart();
        }
        return "['" + this._qname.getNamespaceURI() + "']:" + this._qname.getLocalPart();
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this._context = namespaceContext;
    }

    public void addAttribute(Attribute attribute) {
        this._attributes.put(attribute.getName(), attribute);
    }

    public void addAttributes(Iterator iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                this._attributes.put(attribute.getName(), attribute);
            }
        }
    }

    public void addNamespace(Namespace namespace) {
        if (namespace != null) {
            this._namespaces.add(namespace);
        }
    }

    public void addNamespaces(Iterator iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Namespace namespace = (Namespace)iterator.next();
                this._namespaces.add(namespace);
            }
        }
    }
}

