/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MCatalog.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:15:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_MOZAB_CATALOG_HXX_
#define _CONNECTIVITY_MOZAB_CATALOG_HXX_

#ifndef _CONNECTIVITY_SDBCX_CATALOG_HXX_
#include "connectivity/sdbcx/VCatalog.hxx"
#endif
// #ifndef _CONNECTIVITY_OFUNCTIONDEFS_HXX_
// #include "odbc/OFunctiondefs.hxx"
// #endif

namespace connectivity
{
	namespace mozab
	{
		// please don't name the class the same name as in an other namespaces
		// some compilers have problems with this task as I noticed on windows
        class OConnection;
		class OCatalog : public connectivity::sdbcx::OCatalog
		{
			OConnection*	m_pConnection;		// used to get the metadata
            ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > m_xMetaData; // just to make things easier

		public:
			// implementation of the pure virtual methods
			virtual void refreshTables();
			virtual void refreshViews()	;
			virtual void refreshGroups();
			virtual void refreshUsers()	;
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > SAL_CALL getTables(  ) throw(::com::sun::star::uno::RuntimeException);
		public:
			OCatalog(OConnection* _pCon);

			OConnection*		    getConnection()		const { return m_pConnection; }
			sdbcx::OCollection*		getPrivateTables()	const { return m_pTables;}
			sdbcx::OCollection*		getPrivateViews()	const { return m_pViews; }

			static const ::rtl::OUString& getDot();
		};
	}
}
#endif // _CONNECTIVITY_MOZAB_CATALOG_HXX_

