/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.Composite;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.PixelConverter;
import sun.font.X11TextRenderer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.java2d.x11.X11PMBlitBgLoops;
import sun.java2d.x11.X11PMBlitLoops;
import sun.java2d.x11.X11Renderer;
import sun.security.action.GetPropertyAction;

public abstract class X11SurfaceData
extends SurfaceData {
    X11ComponentPeer peer;
    private X11GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_INT_BGR_X11 = "Integer BGR Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_BYTE_IND_OPQ_X11 = "Byte Indexed Opaque Pixmap";
    public static final String DESC_INT_BGR_X11_BM = "Integer BGR Pixmap with 1-bit transp";
    public static final String DESC_INT_RGB_X11_BM = "Integer RGB Pixmap with 1-bit transp";
    public static final String DESC_BYTE_IND_X11_BM = "Byte Indexed Pixmap with 1-bit transp";
    public static final String DESC_BYTE_GRAY_X11 = "Byte Gray Opaque Pixmap";
    public static final String DESC_INDEX8_GRAY_X11 = "Index8 Gray Opaque Pixmap";
    public static final String DESC_BYTE_GRAY_X11_BM = "Byte Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_INDEX8_GRAY_X11_BM = "Index8 Gray Opaque Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_RGB_X11 = "3 Byte RGB Pixmap";
    public static final String DESC_3BYTE_BGR_X11 = "3 Byte BGR Pixmap";
    public static final String DESC_3BYTE_RGB_X11_BM = "3 Byte RGB Pixmap with 1-bit transp";
    public static final String DESC_3BYTE_BGR_X11_BM = "3 Byte BGR Pixmap with 1-bit transp";
    public static final String DESC_USHORT_555_RGB_X11 = "Ushort 555 RGB Pixmap";
    public static final String DESC_USHORT_565_RGB_X11 = "Ushort 565 RGB Pixmap";
    public static final String DESC_USHORT_555_RGB_X11_BM = "Ushort 555 RGB Pixmap with 1-bit transp";
    public static final String DESC_USHORT_565_RGB_X11_BM = "Ushort 565 RGB Pixmap with 1-bit transp";
    public static final String DESC_USHORT_INDEXED_X11 = "Ushort Indexed Pixmap";
    public static final String DESC_USHORT_INDEXED_X11_BM = "Ushort Indexed Pixmap with 1-bit transp";
    public static final SurfaceType IntBgrX11 = SurfaceType.IntBgr.deriveSubType("Integer BGR Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType ThreeByteRgbX11 = SurfaceType.ThreeByteRgb.deriveSubType("3 Byte RGB Pixmap");
    public static final SurfaceType ThreeByteBgrX11 = SurfaceType.ThreeByteBgr.deriveSubType("3 Byte BGR Pixmap");
    public static final SurfaceType UShort555RgbX11 = SurfaceType.Ushort555Rgb.deriveSubType("Ushort 555 RGB Pixmap");
    public static final SurfaceType UShort565RgbX11 = SurfaceType.Ushort565Rgb.deriveSubType("Ushort 565 RGB Pixmap");
    public static final SurfaceType UShortIndexedX11 = SurfaceType.UshortIndexed.deriveSubType("Ushort Indexed Pixmap");
    public static final SurfaceType ByteIndexedOpaqueX11 = SurfaceType.ByteIndexedOpaque.deriveSubType("Byte Indexed Opaque Pixmap");
    public static final SurfaceType ByteGrayX11 = SurfaceType.ByteGray.deriveSubType("Byte Gray Opaque Pixmap");
    public static final SurfaceType Index8GrayX11 = SurfaceType.Index8Gray.deriveSubType("Index8 Gray Opaque Pixmap");
    public static final SurfaceType IntBgrX11_BM = SurfaceType.Custom.deriveSubType("Integer BGR Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType IntRgbX11_BM = SurfaceType.Custom.deriveSubType("Integer RGB Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType ThreeByteRgbX11_BM = SurfaceType.Custom.deriveSubType("3 Byte RGB Pixmap with 1-bit transp", PixelConverter.Xbgr.instance);
    public static final SurfaceType ThreeByteBgrX11_BM = SurfaceType.Custom.deriveSubType("3 Byte BGR Pixmap with 1-bit transp", PixelConverter.Xrgb.instance);
    public static final SurfaceType UShort555RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 555 RGB Pixmap with 1-bit transp", PixelConverter.Ushort555Rgb.instance);
    public static final SurfaceType UShort565RgbX11_BM = SurfaceType.Custom.deriveSubType("Ushort 565 RGB Pixmap with 1-bit transp", PixelConverter.Ushort565Rgb.instance);
    public static final SurfaceType UShortIndexedX11_BM = SurfaceType.Custom.deriveSubType("Ushort Indexed Pixmap with 1-bit transp");
    public static final SurfaceType ByteIndexedX11_BM = SurfaceType.Custom.deriveSubType("Byte Indexed Pixmap with 1-bit transp");
    public static final SurfaceType ByteGrayX11_BM = SurfaceType.Custom.deriveSubType("Byte Gray Opaque Pixmap with 1-bit transp");
    public static final SurfaceType Index8GrayX11_BM = SurfaceType.Custom.deriveSubType("Index8 Gray Opaque Pixmap with 1-bit transp");
    private static Boolean accelerationEnabled = null;
    protected X11Renderer x11pipe;
    protected PixelToShapeConverter x11txpipe;
    protected static TextPipe x11textpipe;
    protected static boolean dgaAvailable;
    private long xgc;
    private Region validatedClip;
    private XORComposite validatedXorComp;
    private int xorpixelmod;
    private int validatedPixel;
    private boolean validatedExposures = true;
    private static LazyPipe lazypipe;

    private static native void initIDs(Class var0, boolean var1);

    protected native void initSurface(int var1, int var2, int var3, long var4, int var6);

    native boolean isDrawableValid();

    protected native void flushNativeSurface();

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public static native boolean isDgaAvailable();

    public static boolean isAccelerationEnabled() {
        if (accelerationEnabled == null) {
            String string;
            accelerationEnabled = GraphicsEnvironment.isHeadless() ? Boolean.FALSE : ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.pmoffscreen"))) != null ? Boolean.valueOf(string) : Boolean.valueOf(!X11SurfaceData.isDgaAvailable()));
        }
        return accelerationEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        block21: {
            block22: {
                if (sunGraphics2D.antialiasHint == 2) break block21;
                if (sunGraphics2D.paintState > 1) break block21;
                if (sunGraphics2D.compositeState <= 0) break block22;
                if (sunGraphics2D.compositeState != 2) break block21;
            }
            if (this.x11txpipe == null) {
                sunGraphics2D.drawpipe = lazypipe;
                sunGraphics2D.fillpipe = lazypipe;
                sunGraphics2D.shapepipe = lazypipe;
                sunGraphics2D.imagepipe = lazypipe;
                sunGraphics2D.textpipe = lazypipe;
                return;
            }
            if (sunGraphics2D.clipState == 2) {
                super.validatePipe(sunGraphics2D);
            } else {
                block0 : switch (sunGraphics2D.textAntialiasHint) {
                    case 0: 
                    case 1: {
                        if (sunGraphics2D.compositeState == 0) {
                            sunGraphics2D.textpipe = x11textpipe;
                            break;
                        }
                        sunGraphics2D.textpipe = solidTextRenderer;
                        break;
                    }
                    case 2: {
                        sunGraphics2D.textpipe = aaTextRenderer;
                        break;
                    }
                    default: {
                        switch (sunGraphics2D.getFontInfo().aaHint) {
                            case 4: 
                            case 6: {
                                sunGraphics2D.textpipe = lcdTextRenderer;
                                break block0;
                            }
                            case 1: {
                                if (sunGraphics2D.compositeState == 0) {
                                    sunGraphics2D.textpipe = x11textpipe;
                                    break block0;
                                }
                                sunGraphics2D.textpipe = solidTextRenderer;
                                break block0;
                            }
                            case 2: {
                                sunGraphics2D.textpipe = aaTextRenderer;
                                break block0;
                            }
                        }
                        sunGraphics2D.textpipe = solidTextRenderer;
                    }
                }
            }
            if (sunGraphics2D.transformState >= 3) {
                sunGraphics2D.drawpipe = this.x11txpipe;
                sunGraphics2D.fillpipe = this.x11txpipe;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = this.x11txpipe;
                sunGraphics2D.fillpipe = this.x11pipe;
            } else {
                sunGraphics2D.drawpipe = this.x11pipe;
                sunGraphics2D.fillpipe = this.x11pipe;
            }
            sunGraphics2D.shapepipe = this.x11pipe;
            sunGraphics2D.imagepipe = imagepipe;
            sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
            return;
        }
        super.validatePipe(sunGraphics2D);
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState <= 1) {
            if (sunGraphics2D.compositeState <= 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static X11WindowSurfaceData createData(X11ComponentPeer x11ComponentPeer) {
        X11GraphicsConfig x11GraphicsConfig = X11SurfaceData.getGC(x11ComponentPeer);
        return new X11WindowSurfaceData(x11ComponentPeer, x11GraphicsConfig, x11GraphicsConfig.getSurfaceType());
    }

    public static X11PixmapSurfaceData createData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, ColorModel colorModel, Image image) {
        return X11SurfaceData.createData(x11GraphicsConfig, n, n2, colorModel, image, 0L, 0);
    }

    public static X11PixmapSurfaceData createData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, ColorModel colorModel, Image image, long l, int n3) {
        return new X11PixmapSurfaceData(x11GraphicsConfig, n, n2, image, X11SurfaceData.getSurfaceType(x11GraphicsConfig, n3 != 0), colorModel, l, n3);
    }

    private native void initOps(X11ComponentPeer var1, X11GraphicsConfig var2, int var3);

    protected X11SurfaceData(X11ComponentPeer x11ComponentPeer, X11GraphicsConfig x11GraphicsConfig, SurfaceType surfaceType, ColorModel colorModel) {
        super(surfaceType, colorModel);
        this.peer = x11ComponentPeer;
        this.graphicsConfig = x11GraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.depth = colorModel.getPixelSize();
        this.initOps(x11ComponentPeer, this.graphicsConfig, this.depth);
    }

    public static X11GraphicsConfig getGC(X11ComponentPeer x11ComponentPeer) {
        if (x11ComponentPeer != null) {
            return (X11GraphicsConfig)x11ComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (X11GraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public abstract boolean canSourceSendExposures(int var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.x11pipe == null) {
            if (!this.isDrawableValid()) {
                return true;
            }
            this.makePipes();
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 3 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
            n += sunGraphics2D.transX;
            n2 += sunGraphics2D.transY;
            SunToolkit.awtLock();
            try {
                boolean bl = this.canSourceSendExposures(n, n2, n3, n4);
                long l = this.getBlitGC(sunGraphics2D.getCompClip(), bl);
                this.x11pipe.devCopyArea(this.getNativeOps(), l, n, n2, n + n5, n2 + n6, n3, n4);
            }
            finally {
                SunToolkit.awtUnlock();
            }
            return true;
        }
        return false;
    }

    public static SurfaceType getSurfaceType(X11GraphicsConfig x11GraphicsConfig, boolean bl) {
        SurfaceType surfaceType;
        ColorModel colorModel = x11GraphicsConfig.getColorModel();
        switch (colorModel.getPixelSize()) {
            case 24: {
                if (x11GraphicsConfig.getBitsPerPixel() == 24) {
                    if (colorModel instanceof DirectColorModel) {
                        surfaceType = bl ? ThreeByteBgrX11_BM : ThreeByteBgrX11;
                        break;
                    }
                    throw new InvalidPipeException("Unsupported bit depth/cm combo: " + colorModel.getPixelSize() + ", " + colorModel);
                }
            }
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        surfaceType = bl ? IntRgbX11_BM : IntRgbX11;
                        break;
                    }
                    surfaceType = bl ? IntBgrX11_BM : IntBgrX11;
                    break;
                }
                throw new InvalidPipeException("Unsupported bit depth/cm combo: " + colorModel.getPixelSize() + ", " + colorModel);
            }
            case 15: {
                surfaceType = bl ? UShort555RgbX11_BM : UShort555RgbX11;
                break;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getGreenMask() == 992) {
                    surfaceType = bl ? UShort555RgbX11_BM : UShort555RgbX11;
                    break;
                }
                surfaceType = bl ? UShort565RgbX11_BM : UShort565RgbX11;
                break;
            }
            case 12: {
                if (colorModel instanceof IndexColorModel) {
                    surfaceType = bl ? UShortIndexedX11_BM : UShortIndexedX11;
                    break;
                }
                throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize() + " cm=" + colorModel);
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    surfaceType = bl ? ByteGrayX11_BM : ByteGrayX11;
                    break;
                }
                if (colorModel instanceof IndexColorModel && X11SurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    surfaceType = bl ? Index8GrayX11_BM : Index8GrayX11;
                    break;
                }
                surfaceType = bl ? ByteIndexedX11_BM : ByteIndexedOpaqueX11;
                break;
            }
            default: {
                throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
            }
        }
        return surfaceType;
    }

    public native void setInvalid();

    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    private static native long XCreateGC(long var0);

    private static native void XResetClip(long var0);

    private static native void XSetClip(long var0, int var2, int var3, int var4, int var5, Region var6);

    private static native void XSetCopyMode(long var0);

    private static native void XSetXorMode(long var0);

    private static native void XSetForeground(long var0, int var2);

    private static native void XSetGraphicsExposures(long var0, boolean var2);

    public final long getRenderGC(Region region, int n, Composite composite, int n2) {
        return this.getGC(region, n, composite, n2, this.validatedExposures);
    }

    public final long getBlitGC(Region region, boolean bl) {
        return this.getGC(region, 0, null, this.validatedPixel, bl);
    }

    final long getGC(Region region, int n, Composite composite, int n2, boolean bl) {
        if (!this.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (region != this.validatedClip) {
            this.validatedClip = region;
            if (region != null) {
                X11SurfaceData.XSetClip(this.xgc, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region);
            } else {
                X11SurfaceData.XResetClip(this.xgc);
            }
        }
        if (n == 0) {
            if (this.validatedXorComp != null) {
                this.validatedXorComp = null;
                this.xorpixelmod = 0;
                X11SurfaceData.XSetCopyMode(this.xgc);
            }
        } else if (this.validatedXorComp != composite) {
            this.validatedXorComp = (XORComposite)composite;
            this.xorpixelmod = this.validatedXorComp.getXorPixel();
            X11SurfaceData.XSetXorMode(this.xgc);
        }
        if ((n2 ^= this.xorpixelmod) != this.validatedPixel) {
            this.validatedPixel = n2;
            X11SurfaceData.XSetForeground(this.xgc, n2);
        }
        if (this.validatedExposures != bl) {
            this.validatedExposures = bl;
            X11SurfaceData.XSetGraphicsExposures(this.xgc, bl);
        }
        return this.xgc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makePipes() {
        if (this.x11pipe == null) {
            SunToolkit.awtLock();
            try {
                this.xgc = X11SurfaceData.XCreateGC(this.getNativeOps());
            }
            finally {
                SunToolkit.awtUnlock();
            }
            this.x11pipe = X11Renderer.getInstance();
            this.x11txpipe = new PixelToShapeConverter(this.x11pipe);
        }
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"));
            boolean bl = string == null || !"true".equals(string);
            X11SurfaceData.initIDs(XORComposite.class, bl);
            String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.xtextpipe"));
            if (string2 == null || "true".startsWith(string2)) {
                if ("true".equals(string2)) {
                    System.out.println("using X11 text renderer");
                }
                x11textpipe = new X11TextRenderer();
                if (GraphicsPrimitive.tracingEnabled()) {
                    x11textpipe = ((X11TextRenderer)x11textpipe).traceWrap();
                }
            } else {
                if ("false".equals(string2)) {
                    System.out.println("using DGA text renderer");
                }
                x11textpipe = solidTextRenderer;
            }
            dgaAvailable = X11SurfaceData.isDgaAvailable();
            if (X11SurfaceData.isAccelerationEnabled()) {
                X11PMBlitLoops.register();
                X11PMBlitBgLoops.register();
            }
        }
        lazypipe = new LazyPipe();
    }

    public static class LazyPipe
    extends ValidatePipe {
        public boolean validate(SunGraphics2D sunGraphics2D) {
            X11SurfaceData x11SurfaceData = (X11SurfaceData)sunGraphics2D.surfaceData;
            if (!x11SurfaceData.isDrawableValid()) {
                return false;
            }
            x11SurfaceData.makePipes();
            return super.validate(sunGraphics2D);
        }
    }

    public static class X11PixmapSurfaceData
    extends X11SurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;

        public X11PixmapSurfaceData(X11GraphicsConfig x11GraphicsConfig, int n, int n2, Image image, SurfaceType surfaceType, ColorModel colorModel, long l, int n3) {
            super(null, x11GraphicsConfig, surfaceType, colorModel);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = n3 != 0 ? 2 : 1;
            this.initSurface(this.depth, n, n2, l, n3);
            this.makePipes();
        }

        public SurfaceData getReplacement() {
            return X11PixmapSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        public boolean canSourceSendExposures(int n, int n2, int n3, int n4) {
            return n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height;
        }

        public void flush() {
            this.invalidate();
            this.flushNativeSurface();
        }

        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class X11WindowSurfaceData
    extends X11SurfaceData {
        public X11WindowSurfaceData(X11ComponentPeer x11ComponentPeer, X11GraphicsConfig x11GraphicsConfig, SurfaceType surfaceType) {
            super(x11ComponentPeer, x11GraphicsConfig, surfaceType, x11ComponentPeer.getColorModel());
            if (this.isDrawableValid()) {
                this.makePipes();
            }
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }

        public boolean canSourceSendExposures(int n, int n2, int n3, int n4) {
            return true;
        }

        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

