/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuconarc.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2007/02/27 13:11:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



//------------------------------------------------------------------------

#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif

#include <svx/svdview.hxx>

#include "fuconarc.hxx"
#include "sc.hrc"
#include "tabvwsh.hxx"

// #98185# Create default drawing objects via keyboard
#ifndef _SVDOCIRC_HXX
#include <svx/svdocirc.hxx>
#endif

#ifndef _SXCIAITM_HXX
#include <svx/sxciaitm.hxx>
#endif


//------------------------------------------------------------------------


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuConstArc::FuConstArc( ScTabViewShell* pViewSh, Window* pWin, SdrView* pViewP,
				   SdrModel* pDoc, SfxRequest& rReq )
    : FuConstruct( pViewSh, pWin, pViewP, pDoc, rReq )
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuConstArc::~FuConstArc()
{
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL __EXPORT FuConstArc::MouseButtonDown( const MouseEvent& rMEvt )
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	BOOL bReturn = FuConstruct::MouseButtonDown( rMEvt );

	if ( rMEvt.IsLeft() && !pView->IsAction() )
	{
		Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pWindow->CaptureMouse();
		pView->BegCreateObj( aPnt );
		bReturn = TRUE;
	}
	return bReturn;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL __EXPORT FuConstArc::MouseMove( const MouseEvent& rMEvt )
{
	return FuConstruct::MouseMove(rMEvt);
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL __EXPORT FuConstArc::MouseButtonUp( const MouseEvent& rMEvt )
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	BOOL bReturn = FALSE;

	if ( pView->IsCreateObj() && rMEvt.IsLeft() )
	{
		// Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pView->EndCreateObj( SDRCREATE_NEXTPOINT );
		bReturn = TRUE;
	}
/*
	else if ( pView->IsCreateObj() && rMEvt.IsRight() )
	{
		// Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pView->EndCreateObj( SDRCREATE_FORCEEND );
		bReturn = TRUE;
	}
*/
	return (FuConstruct::MouseButtonUp(rMEvt) || bReturn);
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL __EXPORT FuConstArc::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FuConstruct::KeyInput(rKEvt);
	return(bReturn);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void FuConstArc::Activate()
{
	SdrObjKind aObjKind;

	switch (aSfxRequest.GetSlot() )
	{
		case SID_DRAW_ARC:
			aNewPointer = Pointer( POINTER_DRAW_ARC );
			aObjKind = OBJ_CARC;
			break;

		case SID_DRAW_PIE:
			aNewPointer = Pointer( POINTER_DRAW_PIE );
			aObjKind = OBJ_SECT;
			break;

		case SID_DRAW_CIRCLECUT:
			aNewPointer = Pointer( POINTER_DRAW_CIRCLECUT );
			aObjKind = OBJ_CCUT;
			break;

		default:
			aNewPointer = Pointer( POINTER_CROSS );
			aObjKind = OBJ_CARC;
			break;
	}

    pView->SetCurrentObj( sal::static_int_cast<UINT16>( aObjKind ) );

	aOldPointer = pWindow->GetPointer();
	pViewShell->SetActivePointer( aNewPointer );

	FuDraw::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void FuConstArc::Deactivate()
{
	FuDraw::Deactivate();
	pViewShell->SetActivePointer( aOldPointer );
}

// #98185# Create default drawing objects via keyboard
SdrObject* FuConstArc::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
{
	// case SID_DRAW_ARC:
	// case SID_DRAW_PIE:
	// case SID_DRAW_CIRCLECUT:

	SdrObject* pObj = SdrObjFactory::MakeNewObject(
		pView->GetCurrentObjInventor(), pView->GetCurrentObjIdentifier(),
		0L, pDrDoc);

	if(pObj)
	{
		if(pObj->ISA(SdrCircObj))
		{
			Rectangle aRect(rRectangle);

			if(SID_DRAW_ARC == nID || SID_DRAW_CIRCLECUT == nID)
			{
				// force quadratic
				ImpForceQuadratic(aRect);
			}

			pObj->SetLogicRect(aRect);

			SfxItemSet aAttr(pDrDoc->GetItemPool());
			aAttr.Put(SdrCircStartAngleItem(9000));
			aAttr.Put(SdrCircEndAngleItem(0));

			pObj->SetMergedItemSet(aAttr);
		}
		else
		{
			DBG_ERROR("Object is NO circle object");
		}
	}

	return pObj;
}


