#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.1.4.3 $
#
#   last change: $Author: rt $ $Date: 2007/11/02 08:03:08 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
PRJNAME=extensions
TARGET=dxcanvas
GEN_HID=FALSE
EXTNAME=dxcanvas

ENABLE_EXCEPTIONS=TRUE

# --- Settings ----------------------------------

.INCLUDE : settings.mk

XSLDIR=$(SOLARXMLDIR)$/processing
XCSROOT=$(SOLARXMLDIR)
ABSXCSROOT=$(SOLARXMLDIR)
DTDDIR=$(SOLARXMLDIR)
PROCESSOUT=$(MISC)$/$(EXTNAME)
PROCESSORDIR=$(SOLARBINDIR)

# no validation by inspector class
NO_INSPECTION=TRUE

DLLPRE=
common_build_zip=

DESCRIPTION:=$(MISC)$/dxcanvas/description.xml

PACKLICS:=$(foreach,i,$(alllangiso) $(MISC)$/dxcanvas/registration/license_$i.txt)

COMPONENT_FILES= \
    $(MISC)$/dxcanvas$/Canvas.xcs \
    $(MISC)$/dxcanvas$/Canvas.xcu

COMPONENT_MANIFEST= \
	$(MISC)$/dxcanvas$/META-INF$/manifest.xml

COMPONENT_LIBRARY= \
    $(MISC)$/dxcanvas$/directxcanvas.uno$(DLLPOST) \
    $(MISC)$/dxcanvas$/directx9canvas.uno$(DLLPOST)

ZIP1DEPS=		$(PACKLICS) $(DESCRIPTION) $(COMPONENT_MANIFEST) $(COMPONENT_FILES) $(COMPONENT_LIBRARY) makefile.mk
ZIP1TARGET=		dxcanvas
ZIP1DIR=		$(MISC)$/dxcanvas
ZIP1EXT=		.oxt
ZIP1FLAGS=-r
ZIP1LIST=		*

# --- Targets ----------------------------------

.INCLUDE : target.mk

$(COMPONENT_MANIFEST) : $$(@:f)
	@@-$(MKDIRHIER) $(@:d)
    $(TYPE) $< | $(SED) "s/SHARED_EXTENSION/$(DLLPOST)/" > $@

$(COMPONENT_LIBRARY) : $(SOLARBINDIR)$/extensions$/$$(@:f)
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@
    
$(PACKLICS) : $(SOLARBINDIR)$/osl$/license$$(@:b:s/_/./:e:s/./_/)$$(@:e)
	@@-$(MKDIRHIER) $(@:d)
	$(GNUCOPY) $< $@

$(MISC)$/dxcanvas$/%.xcu : $(SOLARXMLDIR)$/registry$/data$/org$/openoffice$/Office$/%.xcu
	@@-$(MKDIRHIER) $(@:d)
	$(GNUCOPY) $< $@

$(MISC)$/dxcanvas$/%.xcs : $(SOLARXMLDIR)$/registry$/schema$/org$/openoffice$/Office$/%.xcs
	@@-$(MKDIRHIER) $(@:d)
	$(GNUCOPY) $< $@

.INCLUDE .IGNORE : $(MISC)$/$(TARGET)_lang_track.mk
.IF "$(LAST_WITH_LANG)"!="$(WITH_LANG)"
PHONYDESC=.PHONY
.ENDIF			# "$(LAST_WITH_LANG)"!="$(WITH_LANG)"
$(DESCRIPTION) $(PHONYDESC) : $$(@:f)
	@@-$(MKDIRHIER) $(@:d)
	$(PERL) $(SOLARENV)$/bin$/licinserter.pl description.xml registration/license_xxx.txt $@
	@echo LAST_WITH_LANG=$(WITH_LANG) > $(MISC)$/$(TARGET)_lang_track.mk
