/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ii_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:48:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDL_II_GATE_HXX
#define ARY_IDL_II_GATE_HXX

// USED SERVICES
    // BASE CLASSES
#include <ary/idl/i_gate.hxx>
    // COMPONENTS
    // PARAMETERS



namespace ary
{
namespace idl
{


class Gate_Inst : public Gate
{
  public:
    // LIFECYCLE
                        Gate_Inst(
                            CePilot &           io_rCes,
                            TypePilot &         io_rTypes,
                            SecondariesPilot &  io_rSecondaries );
                        ~Gate_Inst();
  private:
    // Interface ary::CommonGate
    virtual PhysicalLocationPilot &
                        access_PhysicalLocations();
    virtual LogicalLocationPilot &
                        access_LogicalLocations();
    virtual InformationPilot &
                        access_Informations();

    // Interface ary::cpp::Gate
    virtual CePilot &   access_Ces();
    virtual TypePilot & access_Types();
    virtual SecondariesPilot &
                        access_Secondaries();

    // DATA
    CePilot *           pCes;
    TypePilot *         pTypes;
    SecondariesPilot *  pSecondaries;
};



}   // namespace idl
}   // namespace ary



#endif

