/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sltentry.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:55:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_SLENTRY_HXX
#define ARY_SLENTRY_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>


#ifdef WNT
#define strcmp_nocase   stricmp
#elif (UNX)
#define strcmp_nocase   strcasecmp
#else
#error  For running Autodoc, 'WNT' or 'UNX' must be defined.
#endif


namespace ary {



inline bool         Less_NameStr(
						const udmstri &     i_sName1,
						const udmstri &     i_sName2 )
{
	int result = strcmp_nocase(i_sName1.c_str(), i_sName2.c_str());
	return  result < 0
				?   true
				:   result > 0
					?   false
					:   strcmp(i_sName1.c_str(), i_sName2.c_str()) < 0;
}

struct S_LocalCe
{
	udmstri             sLocalName;
	Cid                 nId;

						S_LocalCe()             : nId(0) {}
						S_LocalCe(
							const udmstri &     i_sLocalName,
							Cid                 i_nId )
												: sLocalName(i_sLocalName), nId(i_nId) {}
	bool                operator<(
							const S_LocalCe &   i_rCe ) const
												{ return Less_NameStr(sLocalName,i_rCe.sLocalName); }
};



}   // namespace ary

/*
struct S_CommentedLink
{
	Cid                 nId;
	udmstri             sComment;

						S_CommentedLink()             : nId(0) {}
						S_CommentedLink(
							Cid                 i_nId,
							const udmstri &     i_sComment )
												: nId(0), sComment {}
	bool                operator<(
							const S_LocalCe &   i_rCe ) const;
};
*/


#endif

