/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_rogate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:22:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_LOC_L_ROGATE_HXX
#define ARY_LOC_L_ROGATE_HXX


#include <ary/ids.hxx>



namespace ary
{

namespace loc
{

class LocationRoot;
class SourceCodeFile;

class RoGate
{
  public:
	// LIFECYCLE
	virtual             ~RoGate() {}

    // INQUIRY
//    virtual uintt       Get_Projects(
//                            std::vector<Lid> &  o_rList ) const;
    LocationRoot *      Find_Root(
                            Lid                 i_nRootId ) const;
    SourceCodeFile *    Find_File(
                            Lid                 i_nFileId ) const;
  private:
    virtual LocationRoot *
                        inq_Find_Root(
                            Lid                 i_nRootId ) const = 0;
    virtual SourceCodeFile *
                        inq_Find_File(
                            Lid                 i_nFileId ) const = 0;
};

// IMPLEMENTATION
inline LocationRoot *
RoGate::Find_Root( Lid i_nRootId ) const
{
    return inq_Find_Root( i_nRootId );
}

inline SourceCodeFile *
RoGate::Find_File( Lid i_nFileId ) const
{
    return inq_Find_File( i_nFileId );
}





} // namespace loc
} // namespace ary



#endif

