/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MultiTokenLocator.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:58:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;

public final class MultiTokenLocator implements Externalizable {
    private String   _commonPath;
    private String[] _matchedTerms;
    private String[] _relativePaths;
    private int[]     _tokenNumbers;
  
    public MultiTokenLocator() { /* for Externalizable */ }
  
    public MultiTokenLocator(String[] terms) {
	_matchedTerms = terms;
	_relativePaths = new String[terms.length];
	_tokenNumbers = new int[terms.length];
    }
  
    public MultiTokenLocator(final String xPath) {
	_commonPath = xPath;
    }

    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	_commonPath    = (String)   in.readObject();
	_matchedTerms  = (String[]) in.readObject();
	_relativePaths = (String[]) in.readObject();
	_tokenNumbers  = (int[])    in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeObject(_commonPath);
	out.writeObject(_matchedTerms);
	out.writeObject(_relativePaths);
	out.writeObject(_tokenNumbers);
    }

    public void setCommonPath(String path) {
	_commonPath = path;
    }
  
    public String getCommonPath() {
	return _commonPath;
    }

    public int getNumberOfTerms() {
	return _matchedTerms.length;
    }

    public String getTerm(int i) {
	return _matchedTerms[i];
    }

    public String getPath(int i) {
	return _relativePaths[i];
    }

    public int getTokenNumber(int i) {
	return _tokenNumbers[i];
    }

    public void setMatchLocation(int index, String relPath, int nthToken) {
	_relativePaths[index] = relPath;
	_tokenNumbers[index] = nthToken;
    }
}
