/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TokenTable.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:51:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.util.Hashtable;
import java.util.Vector;

/** TokenTable associates vectors of Tokens with TextNodes
  the tokens represent matches to be highlighted
  */
public final class TokenTable extends Hashtable {
  // single instance of an anonymous class
  private static final TokenEnumeration EmptyEnumeration =
  new TokenEnumeration() {
    public final boolean hasMoreTokens() { return false; }
    public final Token nextToken() { return null; }
  };
    
  public void addToken(Object key, Token token) {
    Tokens tokens = (Tokens)get(key);
    if (tokens == null)
      put(key, tokens = new Tokens());
    tokens.addElement(token);
  }
  
  public Tokens getTokens(Object key) {
    return (Tokens)get(key);
  }

  public TokenEnumeration getEnumeration(Object key) {
    Object value;
    return (value = get(key)) == null
      ? EmptyEnumeration
      : new TokenEnumerationImpl((Tokens)value);
  }

  /** the function retrieves tokens associated with 'node', if any,
    and for each token creates a shifted (by 'amount') extent
    and adds it to 'extents' (accumulator) */
  public void addShiftedExtents(Object node, int amount, Vector extents) {
    Tokens tokens = (Tokens)get(node);
    if (tokens != null) {
      final int size = tokens.size(); int i = 0;
      do {
	extents.addElement(tokens.tokenAt(i++).shift(amount));
      }
      while (i < size);
    }
  }
}

