/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XmlTreeNodeImpl.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:43:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.tree;

import javax.swing.tree.TreeNode;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.Name;
import java.util.Enumeration;
import java.util.Vector;
import java.util.Hashtable;

public class XmlTreeNodeImpl implements XmlTreeNode, java.io.Serializable {
    private static Hashtable TreeNodes = new Hashtable();
    private final Node2 _node;

    public static void clear() {
	TreeNodes.clear();
    }

    private XmlTreeNodeImpl(Node2 node) {
	_node = node;
    }

    /** from Node to XmlTreeNode */
    public static XmlTreeNode makeNode(Node node) {
	XmlTreeNode built = (XmlTreeNode)TreeNodes.get(node);
	if (built == null)
	    TreeNodes.put(node, built = new XmlTreeNodeImpl((Node2) node));
	return built;
    }

    public Node2 getRepresentation() {
	return _node;
    }

    public TreeNode getParent() {
	Node parent = _node.getParent();
	return parent != null ? makeNode(parent) : null;
    }

    public final Name getName() {
	return _node.getName();
    }

    public final String toString() {
	return _node.toString();
    }

    public final boolean isLeaf() { return _node.isLeaf(); }
    public final int getChildCount() { return _node.getChildCount(); }
    public final TreeNode getChildAt(int n) { return _node.getChildAt(n); }
    public final Enumeration children() { return _node.children(); }
    public final int getIndex(TreeNode node) { return -1; }
    public final void getSubelementsByTagName(Name name, Vector result) {
	_node.getSubelementsByTagName(name, result);
    }
    public final boolean getAllowsChildren() {
	return _node.getAllowsChildren();
    }

    public final int getNodeType() {
	switch (_node.getNodeType()) {
	case Node.ELEMENT: return XmlTreeNode.ELEMENT;
	case Node.TEXT:    return XmlTreeNode.TEXT_NODE;
	default:           return XmlTreeNode.UNKNOWN;
	}
    }
}
