/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptData.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:29:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
/**
 * @date   1/13/98
 * @author Jacek R. Ambroziak
 * @group  Sun Microsystems Laboratories
 */

package com.sun.xmlsearch.qe;

class ConceptData
{
  private final byte    _query;
  private final byte    _nColumns;
  private final byte    _role;
  private final int    _concept;
  private int          _conceptLength;
  private final int    _proximity;
  private final double _penalty;
  private ConceptData _next;
  
  private static final int ProxPerTerm = 100;
  
  public ConceptData(int id, int role, double score, int query, int nColumns)
  {
    _query = (byte)query;
    _nColumns = (byte)nColumns;
    _concept = id;
    _proximity = nColumns * ProxPerTerm;
    _role = (byte)role;
    _penalty = score;
    _next = null;
  }
  
  public int getConcept() {
    return _concept;
  }
  
  public double getPenalty() {
    return _penalty;
  }
  
  public int getConceptLength() {
    return _conceptLength;
  }
  
  public byte getRole() {
    return _role;
  }

  public byte getQuery() {
    return _query;
  }

  public byte getNColumns() {
    return _nColumns;
  }

  public double getScore() {
    return _penalty;
  }
  
  public ConceptData getNext() {
    return _next;
  }
  
  public int getQueryMask() {
    return (_next != null ? _next.getQueryMask() : 0) | (1 << _query);
  }

  public void setConceptLength(int length)
  {
    _conceptLength = length;
    if (_next != null)
      _next.setConceptLength(length);
  }
  
  public void setNext(ConceptData next) {
    _next = next;
  }
  
  boolean cEquals(ConceptData other) {
    return _concept == other._concept;
  }

  boolean crEquals(ConceptData other) {
    return _concept == other._concept && _role == other._role;
  }
  
  boolean crqEquals(ConceptData other) {
    return _concept == other._concept && _role == other._role &&
      _query == other._query;
  }
  
  void addLast(ConceptData other)
  {
    if (_next != null)
      _next.addLast(other);
    else
      _next = other;
  }

  boolean compareWith(ConceptData other) {
    return _concept < other._concept
      || cEquals(other)  && _role < other._role
      || crEquals(other) && _penalty < other._penalty;
  }

  public void runBy(Query[] queries)
  {
    ConceptData cd = this;
    do
      queries[cd._query].updateEstimate(cd._role, cd._penalty);
    while ((cd = cd._next) != null);
  }

  public void generateFillers(RoleFiller[] array, int pos)
  {
    if (array[_query] != RoleFiller.STOP) // 'prohibited'
      (new RoleFiller(_nColumns, this, _role, pos, pos + _proximity))
	.use(array, _query);
    if (_next != null)
      _next.generateFillers(array, pos);
  }
}
