/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: RTFSLParser.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: os $ $Date: 2007/06/19 05:39:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**
  Copyright 2005 Sun Microsystems, Inc.
  */

#include "RTFSLParser.hxx"
#include <stdio.h>
#include <wchar.h>
#include <rtftok/RTFScanner.hxx>
#include <rtftok/RTFScannerHandler.hxx>
#include <com/sun/star/io/XStream.hpp>
#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/io/XSeekable.hpp>
#include <com/sun/star/io/XTruncate.hpp>
#include <com/sun/star/task/XStatusIndicator.hpp>
#include <com/sun/star/container/XNameContainer.hpp>
#include <ucbhelper/contentbroker.hxx>
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#include <osl/process.h>
#include <rtl/string.hxx>
#include <hash_set>
#include <assert.h>
#include <cppuhelper/implbase2.hxx>
#include <com/sun/star/embed/XTransactedObject.hpp>
#include <com/sun/star/embed/XStorage.hpp>
#include <com/sun/star/util/XCloseable.hpp>
#include <comphelper/storagehelper.hxx>
#include <com/sun/star/embed/XTransactedObject.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <comphelper/seqstream.hxx>
#include <odiapi/qname/QName.hxx>
#include <odiapi/props/Properties.hxx>
#include <stack>

#include <ctype.h>

using namespace ::com::sun::star;

namespace writerfilter { namespace rtftok {

const sal_Char RTFSLParser::SERVICE_NAME[40] = "debugservices.rtfsl.RTFSLParser";
const sal_Char RTFSLParser::IMPLEMENTATION_NAME[40] = "debugservices.rtfsl.RTFSLParser";



class TestRtfScannerHandler : public writerfilter::rtftok::RTFScannerHandler
{
	uno::Reference<lang::XMultiServiceFactory> xServiceFactory;
	std::stack<odiapi::props::PropertyBag_Pointer_t> parStack;
	std::stack<odiapi::props::PropertyBag_Pointer_t> runStack;
	odiapi::props::PropertyPool::Pointer_t pool;

	void dest(char* /*token*/, char* /*value*/)
	{
		parStack.push(odiapi::props::createPropertyBag());
		runStack.push(odiapi::props::createPropertyBag());
//		printf("{\\*\\%s%s ", token, value);
	}
	void ctrl(char*token, char*value)
	{
		if (strcmp(token, "par")==0)
		{
			odiapi::props::PropertyPoolHandle_Pointer_t ph=pool->insert(parStack.top());
		}

		QName_t id=QName::tokenizer().insert("urn:rtf:1.7", token);
		switch (id)
		{
		case NS_rtf::LN_pard:
			parStack.top()->clear();
			break;
		default:
			odiapi::props::Property::Pointer_t prop=odiapi::props::createIntegerProperty(id, atoi(value));
//			printf("\\%s%s ", QName::tokenizer().getLocalName(prop->getId()), prop->getStringValue().c_str());
			parStack.top()->insert(prop);
			break;
		}

	}
	void lbrace(void)
	{
//		printf("{");
		parStack.push(parStack.top()->copy());
		runStack.push(runStack.top()->copy());
	}
	void rbrace(void)
	{
		parStack.pop();
		runStack.pop();
	}
	void addSpaces(int /*count*/)
	{
//		for(int i=0;i<count;i++)
//			printf(" ");

	}
	void addBinData(unsigned char /*data*/)
	{
//		printf("%02Xh", data);
	}
	void addChar(char /*ch*/)
	{
//		printf("%c", ch);
	}
	void addCharU(sal_Unicode /*ch*/)
	{
//		printf("\\u%i ", ch);
	}
	void addHexChar(char* /*hexch*/)
	{
//		printf("\'%s ", hexch);
	}


public:
	TestRtfScannerHandler(uno::Reference<lang::XMultiServiceFactory> &xServiceFactory_) :
	  xServiceFactory(xServiceFactory_)
	{
		pool=odiapi::props::createPropertyPool();
		parStack.push(odiapi::props::createPropertyBag());
		runStack.push(odiapi::props::createPropertyBag());
	}

    virtual ~TestRtfScannerHandler() {}

	void dump()
	{
	}
};

class RtfInputSourceImpl : public rtftok::RTFInputSource
{
private:
	uno::Reference< io::XInputStream > xInputStream;
	uno::Reference< io::XSeekable > xSeekable;
	uno::Reference< task::XStatusIndicator > xStatusIndicator;
	sal_Int64 bytesTotal;
	sal_Int64 bytesRead;
public:
	RtfInputSourceImpl(uno::Reference< io::XInputStream > &xInputStream_, uno::Reference< task::XStatusIndicator > &xStatusIndicator_) : 
	  xInputStream(xInputStream_),
	  xStatusIndicator(xStatusIndicator_),
	  bytesRead(0)
	{
		xSeekable=uno::Reference< io::XSeekable >(xInputStream, uno::UNO_QUERY);
		if (xSeekable.is())
			bytesTotal=xSeekable->getLength();
		if (xStatusIndicator.is() && xSeekable.is())
		{
			xStatusIndicator->start(::rtl::OUString::createFromAscii("Converting"), 100);
		}
	}

    virtual ~RtfInputSourceImpl() {}

	int read(void *buf, int maxlen) 
	{
		uno::Sequence< sal_Int8 > buffer;
		int len=xInputStream->readSomeBytes(buffer,maxlen);
		if (len>0)
		{
			sal_Int8 *_buffer=buffer.getArray();
			memcpy(buf, _buffer, len);
			bytesRead+=len;
			if (xStatusIndicator.is())
			{
				if (xSeekable.is())
				{
					xStatusIndicator->setValue((int)(bytesRead*100/bytesTotal));
				}
				else
				{
					char buf1[100];
					sprintf(buf1, "Converted %Li KB", bytesRead/1024);
					xStatusIndicator->start(::rtl::OUString::createFromAscii(buf1), 0);
				}
			}
			return len;
		}
		else
		{
			if (xStatusIndicator.is())
			{
				xStatusIndicator->end();
			}
			return 0;
		}		
	}
};

RTFSLParser::RTFSLParser(const uno::Reference< uno::XComponentContext > &xContext_) :
xContext( xContext_ )
{
}

sal_Int32 SAL_CALL RTFSLParser::run( const uno::Sequence< rtl::OUString >& aArguments ) throw (uno::RuntimeException)
{
 
	uno::Sequence<uno::Any> aUcbInitSequence(2);
	aUcbInitSequence[0] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Local"));
	aUcbInitSequence[1] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Office"));
	uno::Reference<lang::XMultiServiceFactory> xServiceFactory(xContext->getServiceManager(), uno::UNO_QUERY_THROW);
	uno::Reference<lang::XMultiComponentFactory> xFactory(xContext->getServiceManager(), uno::UNO_QUERY_THROW );
    if (::ucbhelper::ContentBroker::initialize(xServiceFactory, aUcbInitSequence))
	{
			rtl::OUString arg=aArguments[0];

			uno::Reference<com::sun::star::ucb::XSimpleFileAccess> xFileAccess(
			xFactory->createInstanceWithContext(
				::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.ucb.SimpleFileAccess")), 
				xContext), uno::UNO_QUERY_THROW );

			rtl_uString *dir=NULL;
			osl_getProcessWorkingDir(&dir);
			rtl::OUString absFileUrl;
			osl_getAbsoluteFileURL(dir, arg.pData, &absFileUrl.pData);
			rtl_uString_release(dir);

			uno::Reference<io::XInputStream> xInputStream = xFileAccess->openFileRead(absFileUrl);
			uno::Reference< task::XStatusIndicator > xStatusIndicator;

		TimeValue t1; osl_getSystemTime(&t1);

			RtfInputSourceImpl rtfInputSource(xInputStream, xStatusIndicator);
			TestRtfScannerHandler eventHandler(xServiceFactory);
			writerfilter::rtftok::RTFScanner *rtfScanner=writerfilter::rtftok::RTFScanner::createRTFScanner(rtfInputSource, eventHandler);
			
			rtfScanner->yylex();
			delete rtfScanner;

		TimeValue t2; osl_getSystemTime(&t2);
		printf("time=%lis\n", t2.Seconds-t1.Seconds);

//			eventHandler.dump();


        ::ucbhelper::ContentBroker::deinitialize();
	}
	else
	{
		fprintf(stderr, "can't initialize UCB");
	}
	return 0;
}

::rtl::OUString RTFSLParser_getImplementationName ()
{
	return rtl::OUString::createFromAscii ( RTFSLParser::IMPLEMENTATION_NAME );
}

sal_Bool SAL_CALL RTFSLParser_supportsService( const ::rtl::OUString& ServiceName )
{
	return ServiceName.equals( rtl::OUString::createFromAscii( RTFSLParser::SERVICE_NAME ) );
}
uno::Sequence< rtl::OUString > SAL_CALL RTFSLParser_getSupportedServiceNames(  ) throw (uno::RuntimeException)
{
	uno::Sequence < rtl::OUString > aRet(1);
	rtl::OUString* pArray = aRet.getArray();
	pArray[0] =  rtl::OUString::createFromAscii ( RTFSLParser::SERVICE_NAME );
	return aRet;
}

uno::Reference< uno::XInterface > SAL_CALL RTFSLParser_createInstance( const uno::Reference< uno::XComponentContext > & xContext) throw( uno::Exception )
{
	return (cppu::OWeakObject*) new RTFSLParser( xContext );
}

} } /* end namespace writerfilter::rtftok */
