
      
/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: resources.hxx,v $
 *
 *  $Revision: 1.66 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/06/04 08:42:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
/*      

  THIS FILE IS GENERATED AUTOMATICALLY! DO NOT EDIT!

*/
#ifndef INCLUDED_RESOURCES_HXX
#define INCLUDED_RESOURCES_HXX

#include <vector>
#include <boost/shared_ptr.hpp>

#ifndef INCLUDED_OUTPUT_WITH_DEPTH_HXX
#include <doctok/OutputWithDepth.hxx>
#endif

#ifndef INCLUDED_RESOURCESIDS_HXX
#include <doctok/resourceids.hxx>
#endif

#ifndef INCLUDED_WW8_STRUCT_BASE_HXX
#include <WW8StructBase.hxx>
#endif

#ifndef INCLUDED_WW8_RESOURCE_MODEL_IMPL_HXX
#include <WW8ResourceModelImpl.hxx>
#endif

#ifndef INCLUDED_WW8_PROPERTY_SET_IMPL_HXX
#include <WW8PropertySetImpl.hxx>
#endif

#ifndef INCLUDED_DFF_HXX
#include <Dff.hxx>
#endif

namespace doctok {

class WW8DocumentImpl;
typedef const WW8DocumentImpl * WW8DocumentImplPointer;

using namespace ::std;

      
/**
    Automatically generated class: ListLevel
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 28
*/
class WW8ListLevel: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8ListLevel> Pointer_t;

    WW8ListLevel(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8ListLevel(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8ListLevel( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 28)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8ListLevel(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8ListLevel();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "ListLevel";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 28; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        start at value for this list level
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        iStartAt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x00
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_iStartAt() const
    {
            return (getU32(0x00));
    }
  
  
    /**
        number format code (see anld.nfc for a list of options)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        nfc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x04
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_nfc() const
    {
            return (getU8(0x04));
    }
  
  
    /**
        alignment (left, right, or centered) of the paragraph
                  number.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        jc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x03
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_jc() const
    {
            return (getU8(0x05)& 0x03);
    }
  
  
    /**
        true (==1) if the level turns all inherited numbers to arabic,
                  false if it preserves their number format code (nfc)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fLegal(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x04
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fLegal() const
    {
            return (getU8(0x05)& 0x04)>> 2;
    }
  
  
    /**
        true if the level's number sequence is not restarted by higher
                  (more significant) levels in the list
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fNoRestart(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x08
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fNoRestart() const
    {
            return (getU8(0x05)& 0x08)>> 3;
    }
  
  
    /**
        Word 6 compatibility option: equivalent to anld.fPrev (see
                  ANLD)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fPrev(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fPrev() const
    {
            return (getU8(0x05)& 0x10)>> 4;
    }
  
  
    /**
        Word 6 compatibility option: equivalent to anld.fPrevSpace (see
                  ANLD)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fPrevSpace(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x20
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fPrevSpace() const
    {
            return (getU8(0x05)& 0x20)>> 5;
    }
  
  
    /**
        true if this level was from a converted Word 6 document. If it
                  is true, all of the Word 6 compability options become valid;
                  otherwise they are ignored.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fWord6(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x40
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fWord6() const
    {
            return (getU8(0x05)& 0x40)>> 6;
    }
  
  
    /**
        unused.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused5_7(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x05
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x80
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused5_7() const
    {
            return (getU8(0x05)& 0x80)>> 7;
    }
  
  
    /**
        contains the character offsets into the LVL's XST of the
                  inherited numbers of previous levels. This array should be zero
                  terminated unless it is full (all 9 levels full). The XST contains
                  place holders for any paragraph numbers contained in the text of
                  the number, and the place holder contains the ilvl of the inherited
                  number, so lvl.xst[lvl.rgbxchNums[0]] == the level of the first
                  inherited number in this level.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        rgbxchNums(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x06
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_rgbxchNums_count() const { return 9; }
sal_uInt8 get_rgbxchNums(sal_uInt32 nIndex) const { return getU8(0x06 + nIndex * sizeof(sal_uInt8)); }

  
    /**
        the type of character following the number text for the
                  paragraph: 0 == tab, 1 == space, 2 == nothing.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ixchFollow(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0f
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_ixchFollow() const
    {
            return (getU8(0x0f));
    }
  
  
    /**
        Word 6 compatibility option: equivalent to anld.dxaSpace (see
                  ANLD)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaSpace(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_dxaSpace() const
    {
            return (getS32(0x10));
    }
  
  
    /**
        Word 6 compatibility optino: equivalent to anld.dxaIndent (see
                  ANLD)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaIndent(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_dxaIndent() const
    {
            return (getS32(0x14));
    }
  
  
    /**
        length, in bytes, of the LVL's grpprlChpx
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbGrpprlChpx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x18
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_cbGrpprlChpx() const
    {
            return (getU8(0x18));
    }
  
  
    /**
        length, in bytes, of the LVL's grpprlPapx
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbGrpprlPapx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x19
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_cbGrpprlPapx() const
    {
            return (getU8(0x19));
    }
  
    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: List
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 28
*/
class WW8List: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt32 mnIndex;
    public:
    typedef boost::shared_ptr<WW8List> Pointer_t;

    WW8List(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rStream, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8List(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(pParent, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8List( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 28)
    
    : WW8StructBase(rSurround, nOffset, nCount), mnIndex(0)
    {
        init();
    }

    WW8List(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rSequence, nOffset, nCount), mnIndex(0)
    {
      init();
    }

    virtual ~WW8List();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "List";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 28; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Set index in parent.

        @param    nIndex    the index
    */
    void setIndex(sal_uInt32 nIndex) { mnIndex = nIndex; }
      
  
    /**
        Unique List ID
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lsid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x00
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_lsid() const
    {
            return (getS32(0x00));
    }
  
  
    /**
        Unique template code
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        tplc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x04
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_tplc() const
    {
            return (getS32(0x04));
    }
  
  
    /**
        Array of shorts containing the istd's linked to each level of
                  the list, or istdNil (4095) if no style is linked.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        rgistd(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x08
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_rgistd_count() const { return 9; }
sal_uInt16 get_rgistd(sal_uInt32 nIndex) const { return getU16(0x08 + nIndex * sizeof(sal_uInt16)); }

  
    /**
        true if this is a simple (one-level) list; false if this is a
                  multilevel (nine-level) list.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fSimpleList(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x01
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fSimpleList() const
    {
            return (getU8(0x1a)& 0x01);
    }
  
  
    /**
        Word 6 compatibility option: true if the list should start
                  numbering over at the beginning of each section
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fRestartHdn(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x02
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fRestartHdn() const
    {
            return (getU8(0x1a)& 0x02)>> 1;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unsigned26_2(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfc
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unsigned26_2() const
    {
            return (getU8(0x1a)& 0xfc)>> 2;
    }
  
      /**
      Array: listlevel
      ElementType: ListLevel(Properties)
      */

      sal_uInt32 get_listlevel_count();

          doctok::Reference < Properties >::Pointer_t get_listlevel(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: ListTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
class WW8ListTable: public WW8StructBase, public doctok::Reference< Table>
{
    sal_uInt32 mnPlcfPayloadOffset;
    vector<sal_uInt32> entryOffsets;
    vector<sal_uInt32> payloadOffsets;
    vector<sal_uInt32> payloadIndices;
      
    public:
    typedef boost::shared_ptr<WW8ListTable> Pointer_t;

    WW8ListTable(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8ListTable(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8ListTable( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8ListTable(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8ListTable();
    void initPayload();
    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "ListTable";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Return offset for entry of PLCF.

        @param nIndex      index of entry
    */
    sal_uInt32 getEntryOffset(sal_uInt32 nIndex)
    {
        return entryOffsets[nIndex];
    }   

    /**
        Calculate offset for payload.
    */
    sal_uInt32 calcPayloadOffset();

    /**
    Set offset for payloads.

    @param nOffset    the offset to set
    */
    void setPayloadOffset(sal_uInt32 nOffset)
    {
    mnPlcfPayloadOffset = nOffset;
    }

    /**
    Return offset for payload of PLCF.

    @param nIndex      index of entry
    */
    sal_uInt32 getPayloadOffset(sal_uInt32 nIndex)
    {
    return payloadOffsets[nIndex];
    }

    /**
    Return size of payload.
    */
    sal_uInt32 getPayloadSize(sal_uInt32 nIndex) const
    {
    return payloadOffsets[nIndex + 1] - payloadOffsets[nIndex];
    }  


    /**
    Return payload index of an entry.

    */
    sal_uInt32 getPayloadIndex(sal_uInt32 nIndex)
    {
    return payloadIndices[nIndex];
    }
      
  sal_uInt32 getEntryCount();
  doctok::Reference< Properties >::Pointer_t getEntry(sal_uInt32 nIndex);

  void resolve(Table & rHandler);

  };
    
/**
    Automatically generated class: LFOLevel
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 8
*/
class WW8LFOLevel: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8LFOLevel> Pointer_t;

    WW8LFOLevel(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8LFOLevel(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8LFOLevel( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 8)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8LFOLevel(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8LFOLevel();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "LFOLevel";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 8; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        start-at value if fFormatting == false and fStartAt == true.
                  (if fFormatting == true, the start-at is stored in the LVL)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        iStartAt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_iStartAt() const
    {
            return (getS32(0x0));
    }
  
  
    /**
        the level to be overridden
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ilvl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_ilvl() const
    {
            return (getU8(0x4)& 0x0f);
    }
  
  
    /**
        true if the start-at value is overridden
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fStartAt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fStartAt() const
    {
            return (getU8(0x4)& 0x10)>> 4;
    }
  
  
    /**
        true if the formatting is overriden (in which case the LFOLVL
                  should contain a pointer to a LVL)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fFormatting(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x20
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fFormatting() const
    {
            return (getU8(0x4)& 0x20)>> 5;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unsigned4_6(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xc0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unsigned4_6() const
    {
            return (getU8(0x4)& 0xc0)>> 6;
    }
  
    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: LFO
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 16
*/
class WW8LFO: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt32 mnIndex;
    public:
    typedef boost::shared_ptr<WW8LFO> Pointer_t;

    WW8LFO(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rStream, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8LFO(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(pParent, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8LFO( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 16)
    
    : WW8StructBase(rSurround, nOffset, nCount), mnIndex(0)
    {
        init();
    }

    WW8LFO(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rSequence, nOffset, nCount), mnIndex(0)
    {
      init();
    }

    virtual ~WW8LFO();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "LFO";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 16; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Set index in parent.

        @param    nIndex    the index
    */
    void setIndex(sal_uInt32 nIndex) { mnIndex = nIndex; }
      
  
    /**
        List ID of corresponding LSTF (see LSTF)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lsid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_lsid() const
    {
            return (getS32(0x0));
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused4(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_unused4() const
    {
            return (getS32(0x4));
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused8(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_unused8() const
    {
            return (getS32(0x8));
    }
  
  
    /**
        count of levels whose format is overridden (see LFOLVL)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        clfolvl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_clfolvl() const
    {
            return (getU8(0xc));
    }
  
      /**
      Array: lfolevel
      ElementType: LFOLevel(Properties)
      */

      sal_uInt32 get_lfolevel_count();

          doctok::Reference < Properties >::Pointer_t get_lfolevel(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: LFOTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
class WW8LFOTable: public WW8StructBase, public doctok::Reference< Table>
{
    sal_uInt32 mnPlcfPayloadOffset;
    vector<sal_uInt32> entryOffsets;
    vector<sal_uInt32> payloadOffsets;
    vector<sal_uInt32> payloadIndices;
      
    public:
    typedef boost::shared_ptr<WW8LFOTable> Pointer_t;

    WW8LFOTable(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8LFOTable(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8LFOTable( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8LFOTable(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8LFOTable();
    void initPayload();
    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "LFOTable";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Return offset for entry of PLCF.

        @param nIndex      index of entry
    */
    sal_uInt32 getEntryOffset(sal_uInt32 nIndex)
    {
        return entryOffsets[nIndex];
    }   

    /**
        Calculate offset for payload.
    */
    sal_uInt32 calcPayloadOffset();

    /**
    Set offset for payloads.

    @param nOffset    the offset to set
    */
    void setPayloadOffset(sal_uInt32 nOffset)
    {
    mnPlcfPayloadOffset = nOffset;
    }

    /**
    Return offset for payload of PLCF.

    @param nIndex      index of entry
    */
    sal_uInt32 getPayloadOffset(sal_uInt32 nIndex)
    {
    return payloadOffsets[nIndex];
    }

    /**
    Return size of payload.
    */
    sal_uInt32 getPayloadSize(sal_uInt32 nIndex) const
    {
    return payloadOffsets[nIndex + 1] - payloadOffsets[nIndex];
    }  


    /**
    Return payload index of an entry.

    */
    sal_uInt32 getPayloadIndex(sal_uInt32 nIndex)
    {
    return payloadIndices[nIndex];
    }
      
  sal_uInt32 getEntryCount();
  doctok::Reference< Properties >::Pointer_t getEntry(sal_uInt32 nIndex);

  void resolve(Table & rHandler);

  };
    
/**
    Automatically generated class: FontTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
class WW8FontTable: public WW8StructBase, public doctok::Reference< Table>
{
    sal_uInt32 mnPlcfPayloadOffset;
    vector<sal_uInt32> entryOffsets;
    vector<sal_uInt32> payloadOffsets;
    vector<sal_uInt32> payloadIndices;
      
    public:
    typedef boost::shared_ptr<WW8FontTable> Pointer_t;

    WW8FontTable(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FontTable(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FontTable( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FontTable(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FontTable();
    void initPayload();
    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FontTable";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Return offset for entry of PLCF.

        @param nIndex      index of entry
    */
    sal_uInt32 getEntryOffset(sal_uInt32 nIndex)
    {
        return entryOffsets[nIndex];
    }   

    /**
        Calculate offset for payload.
    */
    sal_uInt32 calcPayloadOffset();

    /**
    Set offset for payloads.

    @param nOffset    the offset to set
    */
    void setPayloadOffset(sal_uInt32 nOffset)
    {
    mnPlcfPayloadOffset = nOffset;
    }

    /**
    Return offset for payload of PLCF.

    @param nIndex      index of entry
    */
    sal_uInt32 getPayloadOffset(sal_uInt32 nIndex)
    {
    return payloadOffsets[nIndex];
    }

    /**
    Return size of payload.
    */
    sal_uInt32 getPayloadSize(sal_uInt32 nIndex) const
    {
    return payloadOffsets[nIndex + 1] - payloadOffsets[nIndex];
    }  


    /**
    Return payload index of an entry.

    */
    sal_uInt32 getPayloadIndex(sal_uInt32 nIndex)
    {
    return payloadIndices[nIndex];
    }
      
  sal_uInt32 getEntryCount();
  doctok::Reference< Properties >::Pointer_t getEntry(sal_uInt32 nIndex);

  void resolve(Table & rHandler);

  };
    
/**
    Automatically generated class: Font
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 40
*/
class WW8Font: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt32 mnIndex;
    public:
    typedef boost::shared_ptr<WW8Font> Pointer_t;

    WW8Font(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 40)
    : WW8StructBase(rStream, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8Font(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 40)
    : WW8StructBase(pParent, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8Font( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 40)
    
    : WW8StructBase(rSurround, nOffset, nCount), mnIndex(0)
    {
        init();
    }

    WW8Font(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 40)
    : WW8StructBase(rSequence, nOffset, nCount), mnIndex(0)
    {
      init();
    }

    virtual ~WW8Font();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "Font";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 40; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Set index in parent.

        @param    nIndex    the index
    */
    void setIndex(sal_uInt32 nIndex) { mnIndex = nIndex; }
      
  
    /**
        total length of FFN - 1.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbFfnM1(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_cbFfnM1() const
    {
            return (getU8(0x0));
    }
  
  
    /**
        pitch request
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        prq(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x03
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_prq() const
    {
            return (getU8(0x1)& 0x03);
    }
  
  
    /**
        when 1, font is a TrueType font
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fTrueType(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x04
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fTrueType() const
    {
            return (getU8(0x1)& 0x04)>> 2;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused1_3(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x08
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused1_3() const
    {
            return (getU8(0x1)& 0x08)>> 3;
    }
  
  
    /**
        font family id
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ff(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x70
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_ff() const
    {
            return (getU8(0x1)& 0x70)>> 4;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused1_7(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x80
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused1_7() const
    {
            return (getU8(0x1)& 0x80)>> 7;
    }
  
  
    /**
        base weight of font
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        wWeight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_wWeight() const
    {
            return (getS16(0x2));
    }
  
  
    /**
        character set identifier
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        chs(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_chs() const
    {
            return (getU8(0x4));
    }
  
  
    /**
        index into ffn.szFfn to the name of the alternate font
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ixchSzAlt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_ixchSzAlt() const
    {
            return (getU8(0x5));
    }
  
  
    /**
        ? This is supposed to be of type PANOSE.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        panose(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_panose_count() const { return 10; }
sal_uInt8 get_panose(sal_uInt32 nIndex) const { return getU8(0x6 + nIndex * sizeof(sal_uInt8)); }

  
    /**
        ? This is supposed to be of type FONTSIGNATURE.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fs(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_fs_count() const { return 24; }
sal_uInt8 get_fs(sal_uInt32 nIndex) const { return getU8(0x10 + nIndex * sizeof(sal_uInt8)); }

      /**
      Operation: f
      */

          sal_uInt32 get_f();

      /**
      Operation: altName
      */

          rtl::OUString get_altName();

      /**
      Operation: xszFfn
      */

          rtl::OUString get_xszFfn();


  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: Style
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Stereotype withindex

    Parent Resource: Properties
    Size: 0
*/
class WW8Style: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt32 mnIndex;
    public:
    typedef boost::shared_ptr<WW8Style> Pointer_t;

    WW8Style(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8Style(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8Style( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount), mnIndex(0)
    {
        init();
    }

    WW8Style(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount), mnIndex(0)
    {
      init();
    }

    virtual ~WW8Style();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "Style";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Set index in parent.

        @param    nIndex    the index
    */
    void setIndex(sal_uInt32 nIndex) { mnIndex = nIndex; }
      
  
    /**
        invariant style identifier
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        sti(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0fff
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_sti() const
    {
            return (getU16(0x2)& 0x0fff);
    }
  
  
    /**
        spare field for any temporary use, always reset back to
                  zero!
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fScratch(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        12
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fScratch() const
    {
            return (getU16(0x2)& 0x1000)>> 12;
    }
  
  
    /**
        PHEs of all text with this style are wrong
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fInvalHeight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x2000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        13
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fInvalHeight() const
    {
            return (getU16(0x2)& 0x2000)>> 13;
    }
  
  
    /**
        UPEs have been generated
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fHasUpe(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        14
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fHasUpe() const
    {
            return (getU16(0x2)& 0x4000)>> 14;
    }
  
  
    /**
        std has been mass-copied; if unused at save time, style should
                  be deleted
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fMassCopy(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fMassCopy() const
    {
            return (getU16(0x2)& 0x8000)>> 15;
    }
  
  
    /**
        style type code
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        sgc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x000f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_sgc() const
    {
            return (getU16(0x4)& 0x000f);
    }
  
  
    /**
        base style
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        istdBase(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfff0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_istdBase() const
    {
            return (getU16(0x4)& 0xfff0)>> 4;
    }
  
  
    /**
        # of UPXs (and UPEs)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cupx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x000f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_cupx() const
    {
            return (getU16(0x6)& 0x000f);
    }
  
  
    /**
        next style
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        istdNext(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfff0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_istdNext() const
    {
            return (getU16(0x6)& 0xfff0)>> 4;
    }
  
  
    /**
        offset to end of upx's, start of upe's
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        bchUpe(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_bchUpe() const
    {
            return (getU16(0x8));
    }
  
  
    /**
        auto redefine style when appropriate
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fAutoRedef(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xa
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0001
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fAutoRedef() const
    {
            return (getU16(0xa)& 0x0001);
    }
  
  
    /**
        hidden from UI?
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fHidden(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xa
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0002
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fHidden() const
    {
            return (getU16(0xa)& 0x0002)>> 1;
    }
  
  
    /**
        unused bits
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused8_3(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xa
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfffc
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_unused8_3() const
    {
            return (getU16(0xa)& 0xfffc)>> 2;
    }
  
      /**
      Operation: xstzName
      */

          rtl::OUString get_xstzName();

      /**
      Operation: xstzName1
      */

          rtl::OUString get_xstzName1();

      /**
      Operation: upxstart
      */

          sal_uInt32 get_upxstart();

      /**
      Array: upx
      ElementType: UPX(Properties)
      */

      sal_uInt32 get_upx_count();

          doctok::Reference < Properties >::Pointer_t get_upx(sal_uInt32 pos);
    
    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: StyleSheet
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
class WW8StyleSheet: public WW8StructBase, public doctok::Reference< Table>
{
    sal_uInt32 mnPlcfPayloadOffset;
    vector<sal_uInt32> entryOffsets;
    vector<sal_uInt32> payloadOffsets;
    vector<sal_uInt32> payloadIndices;
      
    public:
    typedef boost::shared_ptr<WW8StyleSheet> Pointer_t;

    WW8StyleSheet(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8StyleSheet(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8StyleSheet( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8StyleSheet(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8StyleSheet();
    void initPayload();
    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "StyleSheet";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Return offset for entry of PLCF.

        @param nIndex      index of entry
    */
    sal_uInt32 getEntryOffset(sal_uInt32 nIndex)
    {
        return entryOffsets[nIndex];
    }   

    /**
        Calculate offset for payload.
    */
    sal_uInt32 calcPayloadOffset();

    /**
    Set offset for payloads.

    @param nOffset    the offset to set
    */
    void setPayloadOffset(sal_uInt32 nOffset)
    {
    mnPlcfPayloadOffset = nOffset;
    }

    /**
    Return offset for payload of PLCF.

    @param nIndex      index of entry
    */
    sal_uInt32 getPayloadOffset(sal_uInt32 nIndex)
    {
    return payloadOffsets[nIndex];
    }

    /**
    Return size of payload.
    */
    sal_uInt32 getPayloadSize(sal_uInt32 nIndex) const
    {
    return payloadOffsets[nIndex + 1] - payloadOffsets[nIndex];
    }  


    /**
    Return payload index of an entry.

    */
    sal_uInt32 getPayloadIndex(sal_uInt32 nIndex)
    {
    return payloadIndices[nIndex];
    }
      
  
    /**
        Size of style sheet info
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        size(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_size() const
    {
            return (getU16(0x0));
    }
  
  
    /**
        Count of styles in stylesheet
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cstd(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_cstd() const
    {
            return (getU16(0x2));
    }
  
  
    /**
        Length of STD Base as stored in a file
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbSTDBaseInFile(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_cbSTDBaseInFile() const
    {
            return (getU16(0x4));
    }
  
  
    /**
        Are built-in stylenames stored?
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fStdStylenamesWritten(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0001
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fStdStylenamesWritten() const
    {
            return (getU16(0x6)& 0x0001);
    }
  
  
    /**
        Spare flags
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused4_2(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfffe
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_unused4_2() const
    {
            return (getU16(0x6)& 0xfffe)>> 1;
    }
  
  
    /**
        Max sti known when this file was written
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        stiMaxWhenSaved(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_stiMaxWhenSaved() const
    {
            return (getU16(0x8));
    }
  
  
    /**
        How many fixed-index istds are there?
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        istdMaxFixedWhenSaved(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xa
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_istdMaxFixedWhenSaved() const
    {
            return (getU16(0xa));
    }
  
  
    /**
        Current version of built-in stylenames
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        nVerBuiltInNamesWhenSaved(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_nVerBuiltInNamesWhenSaved() const
    {
            return (getU16(0xc));
    }
  
  
    /**
        ftc used by StandardChpStsh for this document
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        rgftcStandardChpStsh(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xe
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_rgftcStandardChpStsh_count() const { return 3; }
sal_uInt16 get_rgftcStandardChpStsh(sal_uInt32 nIndex) const { return getU16(0xe + nIndex * sizeof(sal_uInt16)); }

  sal_uInt32 getEntryCount();
  doctok::Reference< Properties >::Pointer_t getEntry(sal_uInt32 nIndex);

  void resolve(Table & rHandler);

  };
    
/**
    Automatically generated class: Fib
    
    Stereotype ww8resource

    Stereotype withmembers

    Parent Resource: Properties
    Size: 898
*/
class WW8Fib: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt16 mwIdent;
      sal_uInt16 mnFib;
      sal_uInt16 mnProduct;
      sal_uInt16 mlid;
      sal_Int16 mpnNext;
      sal_uInt16 mfDot;
      sal_uInt16 mfGlsy;
      sal_uInt16 mfComplex;
      sal_uInt16 mfHasPic;
      sal_uInt16 mcQuickSaves;
      sal_uInt16 mfEncrypted;
      sal_uInt16 mfWhichTblStm;
      sal_uInt16 mfReadOnlyRecommended;
      sal_uInt16 mfWriteReservation;
      sal_uInt16 mfExtChar;
      sal_uInt16 mfLoadOverride;
      sal_uInt16 mfFarEast;
      sal_uInt16 mfCrypto;
      sal_uInt16 mnFibBack;
      sal_uInt32 mlKey;
      sal_uInt8 menvr;
      sal_uInt8 mfMac;
      sal_uInt8 mfEmptySpecial;
      sal_uInt8 mfLoadOverridePage;
      sal_uInt8 mfFutureSavedUndo;
      sal_uInt8 mfWord97Saved;
      sal_uInt8 mfSpare0;
      sal_uInt16 mchs;
      sal_uInt16 mchsTables;
      sal_uInt32 mfcMin;
      sal_uInt32 mfcMac;
      sal_uInt16 mcsw;
      sal_uInt16 mwMagicCreated;
      sal_uInt16 mwMagicRevised;
      sal_uInt16 mwMagicCreatedPrivate;
      sal_uInt16 mwMagicRevisedPrivate;
      sal_uInt16 mpnFbpChpFirst_W6;
      sal_uInt16 mpnChpFirst_W6;
      sal_uInt16 mcpnBteChp_W6;
      sal_uInt16 mpnFbpPapFirst_W6;
      sal_uInt16 mpnPapFirst_W6;
      sal_uInt16 mcpnBtePap_W6;
      sal_uInt16 mpnFbpLvcFirst_W6;
      sal_uInt16 mpnLvcFirst_W6;
      sal_uInt16 mcpnBteLvc_W6;
      sal_Int16 mlidFE;
      sal_uInt16 mclw;
      sal_uInt32 mcbMac;
      sal_uInt32 mlProductCreated;
      sal_uInt32 mlProductRevised;
      sal_uInt32 mccpText;
      sal_uInt32 mccpFtn;
      sal_uInt32 mccpHdd;
      sal_uInt32 mccpMcr;
      sal_uInt32 mccpAtn;
      sal_uInt32 mccpEdn;
      sal_uInt32 mccpTxbx;
      sal_uInt32 mccpHdrTxbx;
      sal_uInt32 mpnFbpChpFirst;
      sal_uInt32 mpnChpFirst;
      sal_uInt32 mcpnBteChp;
      sal_uInt32 mpnFbpPapFirst;
      sal_uInt32 mpnPapFirst;
      sal_uInt32 mcpnBtePap;
      sal_uInt32 mpnFbpLvcFirst;
      sal_uInt32 mpnLvcFirst;
      sal_uInt32 mcpnBteLvc;
      sal_uInt32 mfcIslandFirst;
      sal_uInt32 mfcIslandLim;
      sal_uInt16 mcfclcb;
      sal_uInt32 mfcStshfOrig;
      sal_uInt32 mlcbStshfOrig;
      sal_uInt32 mfcStshf;
      sal_uInt32 mlcbStshf;
      sal_uInt32 mfcPlcffndRef;
      sal_uInt32 mlcbPlcffndRef;
      sal_uInt32 mfcPlcffndTxt;
      sal_uInt32 mlcbPlcffndTxt;
      sal_uInt32 mfcPlcfandRef;
      sal_uInt32 mlcbPlcfandRef;
      sal_uInt32 mfcPlcfandTxt;
      sal_uInt32 mlcbPlcfandTxt;
      sal_uInt32 mfcPlcfsed;
      sal_uInt32 mlcbPlcfsed;
      sal_uInt32 mfcPlcfpad;
      sal_uInt32 mlcbPlcfpad;
      sal_uInt32 mfcPlcfphe;
      sal_uInt32 mlcbPlcfphe;
      sal_uInt32 mfcSttbfglsy;
      sal_uInt32 mlcbSttbfglsy;
      sal_uInt32 mfcPlcfglsy;
      sal_uInt32 mlcbPlcfglsy;
      sal_uInt32 mfcPlcfhdd;
      sal_uInt32 mlcbPlcfhdd;
      sal_uInt32 mfcPlcfbteChpx;
      sal_uInt32 mlcbPlcfbteChpx;
      sal_uInt32 mfcPlcfbtePapx;
      sal_uInt32 mlcbPlcfbtePapx;
      sal_uInt32 mfcPlcfsea;
      sal_uInt32 mlcbPlcfsea;
      sal_uInt32 mfcSttbfffn;
      sal_uInt32 mlcbSttbfffn;
      sal_uInt32 mfcPlcffldMom;
      sal_uInt32 mlcbPlcffldMom;
      sal_uInt32 mfcPlcffldHdr;
      sal_uInt32 mlcbPlcffldHdr;
      sal_uInt32 mfcPlcffldFtn;
      sal_uInt32 mlcbPlcffldFtn;
      sal_uInt32 mfcPlcffldAtn;
      sal_uInt32 mlcbPlcffldAtn;
      sal_uInt32 mfcPlcffldMcr;
      sal_uInt32 mlcbPlcffldMcr;
      sal_uInt32 mfcSttbfbkmk;
      sal_uInt32 mlcbSttbfbkmk;
      sal_uInt32 mfcPlcfbkf;
      sal_uInt32 mlcbPlcfbkf;
      sal_uInt32 mfcPlcfbkl;
      sal_uInt32 mlcbPlcfbkl;
      sal_uInt32 mfcCmds;
      sal_uInt32 mlcbCmds;
      sal_uInt32 mfcPlcmcr;
      sal_uInt32 mlcbPlcmcr;
      sal_uInt32 mfcSttbfmcr;
      sal_uInt32 mlcbSttbfmcr;
      sal_uInt32 mfcPrDrvr;
      sal_uInt32 mlcbPrDrvr;
      sal_uInt32 mfcPrEnvPort;
      sal_uInt32 mlcbPrEnvPort;
      sal_uInt32 mfcPrEnvLand;
      sal_uInt32 mlcbPrEnvLand;
      sal_uInt32 mfcWss;
      sal_uInt32 mlcbWss;
      sal_uInt32 mfcDop;
      sal_uInt32 mlcbDop;
      sal_uInt32 mfcSttbfAssoc;
      sal_uInt32 mlcbSttbfAssoc;
      sal_uInt32 mfcClx;
      sal_uInt32 mlcbClx;
      sal_uInt32 mfcPlcfpgdFtn;
      sal_uInt32 mlcbPlcfpgdFtn;
      sal_uInt32 mfcAutosaveSource;
      sal_uInt32 mlcbAutosaveSource;
      sal_uInt32 mfcGrpXstAtnOwners;
      sal_uInt32 mlcbGrpXstAtnOwners;
      sal_uInt32 mfcSttbfAtnbkmk;
      sal_uInt32 mlcbSttbfAtnbkmk;
      sal_uInt32 mfcPlcdoaMom;
      sal_uInt32 mlcbPlcdoaMom;
      sal_uInt32 mfcPlcdoaHdr;
      sal_uInt32 mlcbPlcdoaHdr;
      sal_uInt32 mfcPlcspaMom;
      sal_uInt32 mlcbPlcspaMom;
      sal_uInt32 mfcPlcspaHdr;
      sal_uInt32 mlcbPlcspaHdr;
      sal_uInt32 mfcPlcfAtnbkf;
      sal_uInt32 mlcbPlcfAtnbkf;
      sal_uInt32 mfcPlcfAtnbkl;
      sal_uInt32 mlcbPlcfAtnbkl;
      sal_uInt32 mfcPms;
      sal_uInt32 mlcbPms;
      sal_uInt32 mfcFormFldSttbf;
      sal_uInt32 mlcbFormFldSttbf;
      sal_uInt32 mfcPlcfendRef;
      sal_uInt32 mlcbPlcfendRef;
      sal_uInt32 mfcPlcfendTxt;
      sal_uInt32 mlcbPlcfendTxt;
      sal_uInt32 mfcPlcffldEdn;
      sal_uInt32 mlcbPlcffldEdn;
      sal_uInt32 mfcPlcfpgdEdn;
      sal_uInt32 mlcbPlcfpgdEdn;
      sal_uInt32 mfcDggInfo;
      sal_uInt32 mlcbDggInfo;
      sal_uInt32 mfcSttbfRMark;
      sal_uInt32 mlcbSttbfRMark;
      sal_uInt32 mfcSttbfCaption;
      sal_uInt32 mlcbSttbfCaption;
      sal_uInt32 mfcSttbfAutoCaption;
      sal_uInt32 mlcbSttbfAutoCaption;
      sal_uInt32 mfcPlcfwkb;
      sal_uInt32 mlcbPlcfwkb;
      sal_uInt32 mfcPlcfspl;
      sal_uInt32 mlcbPlcfspl;
      sal_uInt32 mfcPlcftxbxTxt;
      sal_uInt32 mlcbPlcftxbxTxt;
      sal_uInt32 mfcPlcffldTxbx;
      sal_uInt32 mlcbPlcffldTxbx;
      sal_uInt32 mfcPlcfHdrtxbxTxt;
      sal_uInt32 mlcbPlcfHdrtxbxTxt;
      sal_uInt32 mfcPlcffldHdrTxbx;
      sal_uInt32 mlcbPlcffldHdrTxbx;
      sal_uInt32 mfcStwUser;
      sal_uInt32 mlcbStwUser;
      sal_uInt32 mfcSttbttmbd;
      sal_uInt32 mlcbSttbttmbd;
      sal_uInt32 mfcUnused;
      sal_uInt32 mlcbUnused;
      sal_uInt32 mfcPgdMother;
      sal_uInt32 mlcbPgdMother;
      sal_uInt32 mfcBkdMother;
      sal_uInt32 mlcbBkdMother;
      sal_uInt32 mfcPgdFtn;
      sal_uInt32 mlcbPgdFtn;
      sal_uInt32 mfcBkdFtn;
      sal_uInt32 mlcbBkdFtn;
      sal_uInt32 mfcPgdEdn;
      sal_uInt32 mlcbPgdEdn;
      sal_uInt32 mfcBkdEdn;
      sal_uInt32 mlcbBkdEdn;
      sal_uInt32 mfcSttbfIntlFld;
      sal_uInt32 mlcbSttbfIntlFld;
      sal_uInt32 mfcRouteSlip;
      sal_uInt32 mlcbRouteSlip;
      sal_uInt32 mfcSttbSavedBy;
      sal_uInt32 mlcbSttbSavedBy;
      sal_uInt32 mfcSttbFnm;
      sal_uInt32 mlcbSttbFnm;
      sal_uInt32 mfcPlcfLst;
      sal_uInt32 mlcbPlcfLst;
      sal_uInt32 mfcPlfLfo;
      sal_uInt32 mlcbPlfLfo;
      sal_uInt32 mfcPlcftxbxBkd;
      sal_uInt32 mlcbPlcftxbxBkd;
      sal_uInt32 mfcPlcftxbxHdrBkd;
      sal_uInt32 mlcbPlcftxbxHdrBkd;
      sal_uInt32 mfcDocUndo;
      sal_uInt32 mlcbDocUndo;
      sal_uInt32 mfcRgbuse;
      sal_uInt32 mlcbRgbuse;
      sal_uInt32 mfcUsp;
      sal_uInt32 mlcbUsp;
      sal_uInt32 mfcUskf;
      sal_uInt32 mlcbUskf;
      sal_uInt32 mfcPlcupcRgbuse;
      sal_uInt32 mlcbPlcupcRgbuse;
      sal_uInt32 mfcPlcupcUsp;
      sal_uInt32 mlcbPlcupcUsp;
      sal_uInt32 mfcSttbGlsyStyle;
      sal_uInt32 mlcbSttbGlsyStyle;
      sal_uInt32 mfcPlgosl;
      sal_uInt32 mlcbPlgosl;
      sal_uInt32 mfcPlcocx;
      sal_uInt32 mlcbPlcocx;
      sal_uInt32 mfcPlcfbteLvc;
      sal_uInt32 mlcbPlcfbteLvc;
      sal_uInt32 mdwLowDateTime;
      sal_uInt32 mdwHighDateTime;
      sal_uInt32 mfcPlcflvc;
      sal_uInt32 mlcbPlcflvc;
      sal_uInt32 mfcPlcasumy;
      sal_uInt32 mlcbPlcasumy;
      sal_uInt32 mfcPlcfgram;
      sal_uInt32 mlcbPlcfgram;
      sal_uInt32 mfcSttbListNames;
      sal_uInt32 mlcbSttbListNames;
      sal_uInt32 mfcSttbfUssr;
      sal_uInt32 mlcbSttbfUssr;
  
    public:
    typedef boost::shared_ptr<WW8Fib> Pointer_t;

    WW8Fib(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 898)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8Fib(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 898)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8Fib( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 898)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8Fib(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 898)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8Fib();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "Fib";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 898; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        sal_uInt16 get_wIdent() const { return mwIdent; }
      sal_uInt16 get_nFib() const { return mnFib; }
      sal_uInt16 get_nProduct() const { return mnProduct; }
      sal_uInt16 get_lid() const { return mlid; }
      sal_Int16 get_pnNext() const { return mpnNext; }
      sal_uInt16 get_fDot() const { return mfDot; }
      sal_uInt16 get_fGlsy() const { return mfGlsy; }
      sal_uInt16 get_fComplex() const { return mfComplex; }
      sal_uInt16 get_fHasPic() const { return mfHasPic; }
      sal_uInt16 get_cQuickSaves() const { return mcQuickSaves; }
      sal_uInt16 get_fEncrypted() const { return mfEncrypted; }
      sal_uInt16 get_fWhichTblStm() const { return mfWhichTblStm; }
      sal_uInt16 get_fReadOnlyRecommended() const { return mfReadOnlyRecommended; }
      sal_uInt16 get_fWriteReservation() const { return mfWriteReservation; }
      sal_uInt16 get_fExtChar() const { return mfExtChar; }
      sal_uInt16 get_fLoadOverride() const { return mfLoadOverride; }
      sal_uInt16 get_fFarEast() const { return mfFarEast; }
      sal_uInt16 get_fCrypto() const { return mfCrypto; }
      sal_uInt16 get_nFibBack() const { return mnFibBack; }
      sal_uInt32 get_lKey() const { return mlKey; }
      sal_uInt8 get_envr() const { return menvr; }
      sal_uInt8 get_fMac() const { return mfMac; }
      sal_uInt8 get_fEmptySpecial() const { return mfEmptySpecial; }
      sal_uInt8 get_fLoadOverridePage() const { return mfLoadOverridePage; }
      sal_uInt8 get_fFutureSavedUndo() const { return mfFutureSavedUndo; }
      sal_uInt8 get_fWord97Saved() const { return mfWord97Saved; }
      sal_uInt8 get_fSpare0() const { return mfSpare0; }
      sal_uInt16 get_chs() const { return mchs; }
      sal_uInt16 get_chsTables() const { return mchsTables; }
      sal_uInt32 get_fcMin() const { return mfcMin; }
      sal_uInt32 get_fcMac() const { return mfcMac; }
      sal_uInt16 get_csw() const { return mcsw; }
      sal_uInt16 get_wMagicCreated() const { return mwMagicCreated; }
      sal_uInt16 get_wMagicRevised() const { return mwMagicRevised; }
      sal_uInt16 get_wMagicCreatedPrivate() const { return mwMagicCreatedPrivate; }
      sal_uInt16 get_wMagicRevisedPrivate() const { return mwMagicRevisedPrivate; }
      sal_uInt16 get_pnFbpChpFirst_W6() const { return mpnFbpChpFirst_W6; }
      sal_uInt16 get_pnChpFirst_W6() const { return mpnChpFirst_W6; }
      sal_uInt16 get_cpnBteChp_W6() const { return mcpnBteChp_W6; }
      sal_uInt16 get_pnFbpPapFirst_W6() const { return mpnFbpPapFirst_W6; }
      sal_uInt16 get_pnPapFirst_W6() const { return mpnPapFirst_W6; }
      sal_uInt16 get_cpnBtePap_W6() const { return mcpnBtePap_W6; }
      sal_uInt16 get_pnFbpLvcFirst_W6() const { return mpnFbpLvcFirst_W6; }
      sal_uInt16 get_pnLvcFirst_W6() const { return mpnLvcFirst_W6; }
      sal_uInt16 get_cpnBteLvc_W6() const { return mcpnBteLvc_W6; }
      sal_Int16 get_lidFE() const { return mlidFE; }
      sal_uInt16 get_clw() const { return mclw; }
      sal_uInt32 get_cbMac() const { return mcbMac; }
      sal_uInt32 get_lProductCreated() const { return mlProductCreated; }
      sal_uInt32 get_lProductRevised() const { return mlProductRevised; }
      sal_uInt32 get_ccpText() const { return mccpText; }
      sal_uInt32 get_ccpFtn() const { return mccpFtn; }
      sal_uInt32 get_ccpHdd() const { return mccpHdd; }
      sal_uInt32 get_ccpMcr() const { return mccpMcr; }
      sal_uInt32 get_ccpAtn() const { return mccpAtn; }
      sal_uInt32 get_ccpEdn() const { return mccpEdn; }
      sal_uInt32 get_ccpTxbx() const { return mccpTxbx; }
      sal_uInt32 get_ccpHdrTxbx() const { return mccpHdrTxbx; }
      sal_uInt32 get_pnFbpChpFirst() const { return mpnFbpChpFirst; }
      sal_uInt32 get_pnChpFirst() const { return mpnChpFirst; }
      sal_uInt32 get_cpnBteChp() const { return mcpnBteChp; }
      sal_uInt32 get_pnFbpPapFirst() const { return mpnFbpPapFirst; }
      sal_uInt32 get_pnPapFirst() const { return mpnPapFirst; }
      sal_uInt32 get_cpnBtePap() const { return mcpnBtePap; }
      sal_uInt32 get_pnFbpLvcFirst() const { return mpnFbpLvcFirst; }
      sal_uInt32 get_pnLvcFirst() const { return mpnLvcFirst; }
      sal_uInt32 get_cpnBteLvc() const { return mcpnBteLvc; }
      sal_uInt32 get_fcIslandFirst() const { return mfcIslandFirst; }
      sal_uInt32 get_fcIslandLim() const { return mfcIslandLim; }
      sal_uInt16 get_cfclcb() const { return mcfclcb; }
      sal_uInt32 get_fcStshfOrig() const { return mfcStshfOrig; }
      sal_uInt32 get_lcbStshfOrig() const { return mlcbStshfOrig; }
      sal_uInt32 get_fcStshf() const { return mfcStshf; }
      sal_uInt32 get_lcbStshf() const { return mlcbStshf; }
      sal_uInt32 get_fcPlcffndRef() const { return mfcPlcffndRef; }
      sal_uInt32 get_lcbPlcffndRef() const { return mlcbPlcffndRef; }
      sal_uInt32 get_fcPlcffndTxt() const { return mfcPlcffndTxt; }
      sal_uInt32 get_lcbPlcffndTxt() const { return mlcbPlcffndTxt; }
      sal_uInt32 get_fcPlcfandRef() const { return mfcPlcfandRef; }
      sal_uInt32 get_lcbPlcfandRef() const { return mlcbPlcfandRef; }
      sal_uInt32 get_fcPlcfandTxt() const { return mfcPlcfandTxt; }
      sal_uInt32 get_lcbPlcfandTxt() const { return mlcbPlcfandTxt; }
      sal_uInt32 get_fcPlcfsed() const { return mfcPlcfsed; }
      sal_uInt32 get_lcbPlcfsed() const { return mlcbPlcfsed; }
      sal_uInt32 get_fcPlcfpad() const { return mfcPlcfpad; }
      sal_uInt32 get_lcbPlcfpad() const { return mlcbPlcfpad; }
      sal_uInt32 get_fcPlcfphe() const { return mfcPlcfphe; }
      sal_uInt32 get_lcbPlcfphe() const { return mlcbPlcfphe; }
      sal_uInt32 get_fcSttbfglsy() const { return mfcSttbfglsy; }
      sal_uInt32 get_lcbSttbfglsy() const { return mlcbSttbfglsy; }
      sal_uInt32 get_fcPlcfglsy() const { return mfcPlcfglsy; }
      sal_uInt32 get_lcbPlcfglsy() const { return mlcbPlcfglsy; }
      sal_uInt32 get_fcPlcfhdd() const { return mfcPlcfhdd; }
      sal_uInt32 get_lcbPlcfhdd() const { return mlcbPlcfhdd; }
      sal_uInt32 get_fcPlcfbteChpx() const { return mfcPlcfbteChpx; }
      sal_uInt32 get_lcbPlcfbteChpx() const { return mlcbPlcfbteChpx; }
      sal_uInt32 get_fcPlcfbtePapx() const { return mfcPlcfbtePapx; }
      sal_uInt32 get_lcbPlcfbtePapx() const { return mlcbPlcfbtePapx; }
      sal_uInt32 get_fcPlcfsea() const { return mfcPlcfsea; }
      sal_uInt32 get_lcbPlcfsea() const { return mlcbPlcfsea; }
      sal_uInt32 get_fcSttbfffn() const { return mfcSttbfffn; }
      sal_uInt32 get_lcbSttbfffn() const { return mlcbSttbfffn; }
      sal_uInt32 get_fcPlcffldMom() const { return mfcPlcffldMom; }
      sal_uInt32 get_lcbPlcffldMom() const { return mlcbPlcffldMom; }
      sal_uInt32 get_fcPlcffldHdr() const { return mfcPlcffldHdr; }
      sal_uInt32 get_lcbPlcffldHdr() const { return mlcbPlcffldHdr; }
      sal_uInt32 get_fcPlcffldFtn() const { return mfcPlcffldFtn; }
      sal_uInt32 get_lcbPlcffldFtn() const { return mlcbPlcffldFtn; }
      sal_uInt32 get_fcPlcffldAtn() const { return mfcPlcffldAtn; }
      sal_uInt32 get_lcbPlcffldAtn() const { return mlcbPlcffldAtn; }
      sal_uInt32 get_fcPlcffldMcr() const { return mfcPlcffldMcr; }
      sal_uInt32 get_lcbPlcffldMcr() const { return mlcbPlcffldMcr; }
      sal_uInt32 get_fcSttbfbkmk() const { return mfcSttbfbkmk; }
      sal_uInt32 get_lcbSttbfbkmk() const { return mlcbSttbfbkmk; }
      sal_uInt32 get_fcPlcfbkf() const { return mfcPlcfbkf; }
      sal_uInt32 get_lcbPlcfbkf() const { return mlcbPlcfbkf; }
      sal_uInt32 get_fcPlcfbkl() const { return mfcPlcfbkl; }
      sal_uInt32 get_lcbPlcfbkl() const { return mlcbPlcfbkl; }
      sal_uInt32 get_fcCmds() const { return mfcCmds; }
      sal_uInt32 get_lcbCmds() const { return mlcbCmds; }
      sal_uInt32 get_fcPlcmcr() const { return mfcPlcmcr; }
      sal_uInt32 get_lcbPlcmcr() const { return mlcbPlcmcr; }
      sal_uInt32 get_fcSttbfmcr() const { return mfcSttbfmcr; }
      sal_uInt32 get_lcbSttbfmcr() const { return mlcbSttbfmcr; }
      sal_uInt32 get_fcPrDrvr() const { return mfcPrDrvr; }
      sal_uInt32 get_lcbPrDrvr() const { return mlcbPrDrvr; }
      sal_uInt32 get_fcPrEnvPort() const { return mfcPrEnvPort; }
      sal_uInt32 get_lcbPrEnvPort() const { return mlcbPrEnvPort; }
      sal_uInt32 get_fcPrEnvLand() const { return mfcPrEnvLand; }
      sal_uInt32 get_lcbPrEnvLand() const { return mlcbPrEnvLand; }
      sal_uInt32 get_fcWss() const { return mfcWss; }
      sal_uInt32 get_lcbWss() const { return mlcbWss; }
      sal_uInt32 get_fcDop() const { return mfcDop; }
      sal_uInt32 get_lcbDop() const { return mlcbDop; }
      sal_uInt32 get_fcSttbfAssoc() const { return mfcSttbfAssoc; }
      sal_uInt32 get_lcbSttbfAssoc() const { return mlcbSttbfAssoc; }
      sal_uInt32 get_fcClx() const { return mfcClx; }
      sal_uInt32 get_lcbClx() const { return mlcbClx; }
      sal_uInt32 get_fcPlcfpgdFtn() const { return mfcPlcfpgdFtn; }
      sal_uInt32 get_lcbPlcfpgdFtn() const { return mlcbPlcfpgdFtn; }
      sal_uInt32 get_fcAutosaveSource() const { return mfcAutosaveSource; }
      sal_uInt32 get_lcbAutosaveSource() const { return mlcbAutosaveSource; }
      sal_uInt32 get_fcGrpXstAtnOwners() const { return mfcGrpXstAtnOwners; }
      sal_uInt32 get_lcbGrpXstAtnOwners() const { return mlcbGrpXstAtnOwners; }
      sal_uInt32 get_fcSttbfAtnbkmk() const { return mfcSttbfAtnbkmk; }
      sal_uInt32 get_lcbSttbfAtnbkmk() const { return mlcbSttbfAtnbkmk; }
      sal_uInt32 get_fcPlcdoaMom() const { return mfcPlcdoaMom; }
      sal_uInt32 get_lcbPlcdoaMom() const { return mlcbPlcdoaMom; }
      sal_uInt32 get_fcPlcdoaHdr() const { return mfcPlcdoaHdr; }
      sal_uInt32 get_lcbPlcdoaHdr() const { return mlcbPlcdoaHdr; }
      sal_uInt32 get_fcPlcspaMom() const { return mfcPlcspaMom; }
      sal_uInt32 get_lcbPlcspaMom() const { return mlcbPlcspaMom; }
      sal_uInt32 get_fcPlcspaHdr() const { return mfcPlcspaHdr; }
      sal_uInt32 get_lcbPlcspaHdr() const { return mlcbPlcspaHdr; }
      sal_uInt32 get_fcPlcfAtnbkf() const { return mfcPlcfAtnbkf; }
      sal_uInt32 get_lcbPlcfAtnbkf() const { return mlcbPlcfAtnbkf; }
      sal_uInt32 get_fcPlcfAtnbkl() const { return mfcPlcfAtnbkl; }
      sal_uInt32 get_lcbPlcfAtnbkl() const { return mlcbPlcfAtnbkl; }
      sal_uInt32 get_fcPms() const { return mfcPms; }
      sal_uInt32 get_lcbPms() const { return mlcbPms; }
      sal_uInt32 get_fcFormFldSttbf() const { return mfcFormFldSttbf; }
      sal_uInt32 get_lcbFormFldSttbf() const { return mlcbFormFldSttbf; }
      sal_uInt32 get_fcPlcfendRef() const { return mfcPlcfendRef; }
      sal_uInt32 get_lcbPlcfendRef() const { return mlcbPlcfendRef; }
      sal_uInt32 get_fcPlcfendTxt() const { return mfcPlcfendTxt; }
      sal_uInt32 get_lcbPlcfendTxt() const { return mlcbPlcfendTxt; }
      sal_uInt32 get_fcPlcffldEdn() const { return mfcPlcffldEdn; }
      sal_uInt32 get_lcbPlcffldEdn() const { return mlcbPlcffldEdn; }
      sal_uInt32 get_fcPlcfpgdEdn() const { return mfcPlcfpgdEdn; }
      sal_uInt32 get_lcbPlcfpgdEdn() const { return mlcbPlcfpgdEdn; }
      sal_uInt32 get_fcDggInfo() const { return mfcDggInfo; }
      sal_uInt32 get_lcbDggInfo() const { return mlcbDggInfo; }
      sal_uInt32 get_fcSttbfRMark() const { return mfcSttbfRMark; }
      sal_uInt32 get_lcbSttbfRMark() const { return mlcbSttbfRMark; }
      sal_uInt32 get_fcSttbfCaption() const { return mfcSttbfCaption; }
      sal_uInt32 get_lcbSttbfCaption() const { return mlcbSttbfCaption; }
      sal_uInt32 get_fcSttbfAutoCaption() const { return mfcSttbfAutoCaption; }
      sal_uInt32 get_lcbSttbfAutoCaption() const { return mlcbSttbfAutoCaption; }
      sal_uInt32 get_fcPlcfwkb() const { return mfcPlcfwkb; }
      sal_uInt32 get_lcbPlcfwkb() const { return mlcbPlcfwkb; }
      sal_uInt32 get_fcPlcfspl() const { return mfcPlcfspl; }
      sal_uInt32 get_lcbPlcfspl() const { return mlcbPlcfspl; }
      sal_uInt32 get_fcPlcftxbxTxt() const { return mfcPlcftxbxTxt; }
      sal_uInt32 get_lcbPlcftxbxTxt() const { return mlcbPlcftxbxTxt; }
      sal_uInt32 get_fcPlcffldTxbx() const { return mfcPlcffldTxbx; }
      sal_uInt32 get_lcbPlcffldTxbx() const { return mlcbPlcffldTxbx; }
      sal_uInt32 get_fcPlcfHdrtxbxTxt() const { return mfcPlcfHdrtxbxTxt; }
      sal_uInt32 get_lcbPlcfHdrtxbxTxt() const { return mlcbPlcfHdrtxbxTxt; }
      sal_uInt32 get_fcPlcffldHdrTxbx() const { return mfcPlcffldHdrTxbx; }
      sal_uInt32 get_lcbPlcffldHdrTxbx() const { return mlcbPlcffldHdrTxbx; }
      sal_uInt32 get_fcStwUser() const { return mfcStwUser; }
      sal_uInt32 get_lcbStwUser() const { return mlcbStwUser; }
      sal_uInt32 get_fcSttbttmbd() const { return mfcSttbttmbd; }
      sal_uInt32 get_lcbSttbttmbd() const { return mlcbSttbttmbd; }
      sal_uInt32 get_fcUnused() const { return mfcUnused; }
      sal_uInt32 get_lcbUnused() const { return mlcbUnused; }
      sal_uInt32 get_fcPgdMother() const { return mfcPgdMother; }
      sal_uInt32 get_lcbPgdMother() const { return mlcbPgdMother; }
      sal_uInt32 get_fcBkdMother() const { return mfcBkdMother; }
      sal_uInt32 get_lcbBkdMother() const { return mlcbBkdMother; }
      sal_uInt32 get_fcPgdFtn() const { return mfcPgdFtn; }
      sal_uInt32 get_lcbPgdFtn() const { return mlcbPgdFtn; }
      sal_uInt32 get_fcBkdFtn() const { return mfcBkdFtn; }
      sal_uInt32 get_lcbBkdFtn() const { return mlcbBkdFtn; }
      sal_uInt32 get_fcPgdEdn() const { return mfcPgdEdn; }
      sal_uInt32 get_lcbPgdEdn() const { return mlcbPgdEdn; }
      sal_uInt32 get_fcBkdEdn() const { return mfcBkdEdn; }
      sal_uInt32 get_lcbBkdEdn() const { return mlcbBkdEdn; }
      sal_uInt32 get_fcSttbfIntlFld() const { return mfcSttbfIntlFld; }
      sal_uInt32 get_lcbSttbfIntlFld() const { return mlcbSttbfIntlFld; }
      sal_uInt32 get_fcRouteSlip() const { return mfcRouteSlip; }
      sal_uInt32 get_lcbRouteSlip() const { return mlcbRouteSlip; }
      sal_uInt32 get_fcSttbSavedBy() const { return mfcSttbSavedBy; }
      sal_uInt32 get_lcbSttbSavedBy() const { return mlcbSttbSavedBy; }
      sal_uInt32 get_fcSttbFnm() const { return mfcSttbFnm; }
      sal_uInt32 get_lcbSttbFnm() const { return mlcbSttbFnm; }
      sal_uInt32 get_fcPlcfLst() const { return mfcPlcfLst; }
      sal_uInt32 get_lcbPlcfLst() const { return mlcbPlcfLst; }
      sal_uInt32 get_fcPlfLfo() const { return mfcPlfLfo; }
      sal_uInt32 get_lcbPlfLfo() const { return mlcbPlfLfo; }
      sal_uInt32 get_fcPlcftxbxBkd() const { return mfcPlcftxbxBkd; }
      sal_uInt32 get_lcbPlcftxbxBkd() const { return mlcbPlcftxbxBkd; }
      sal_uInt32 get_fcPlcftxbxHdrBkd() const { return mfcPlcftxbxHdrBkd; }
      sal_uInt32 get_lcbPlcftxbxHdrBkd() const { return mlcbPlcftxbxHdrBkd; }
      sal_uInt32 get_fcDocUndo() const { return mfcDocUndo; }
      sal_uInt32 get_lcbDocUndo() const { return mlcbDocUndo; }
      sal_uInt32 get_fcRgbuse() const { return mfcRgbuse; }
      sal_uInt32 get_lcbRgbuse() const { return mlcbRgbuse; }
      sal_uInt32 get_fcUsp() const { return mfcUsp; }
      sal_uInt32 get_lcbUsp() const { return mlcbUsp; }
      sal_uInt32 get_fcUskf() const { return mfcUskf; }
      sal_uInt32 get_lcbUskf() const { return mlcbUskf; }
      sal_uInt32 get_fcPlcupcRgbuse() const { return mfcPlcupcRgbuse; }
      sal_uInt32 get_lcbPlcupcRgbuse() const { return mlcbPlcupcRgbuse; }
      sal_uInt32 get_fcPlcupcUsp() const { return mfcPlcupcUsp; }
      sal_uInt32 get_lcbPlcupcUsp() const { return mlcbPlcupcUsp; }
      sal_uInt32 get_fcSttbGlsyStyle() const { return mfcSttbGlsyStyle; }
      sal_uInt32 get_lcbSttbGlsyStyle() const { return mlcbSttbGlsyStyle; }
      sal_uInt32 get_fcPlgosl() const { return mfcPlgosl; }
      sal_uInt32 get_lcbPlgosl() const { return mlcbPlgosl; }
      sal_uInt32 get_fcPlcocx() const { return mfcPlcocx; }
      sal_uInt32 get_lcbPlcocx() const { return mlcbPlcocx; }
      sal_uInt32 get_fcPlcfbteLvc() const { return mfcPlcfbteLvc; }
      sal_uInt32 get_lcbPlcfbteLvc() const { return mlcbPlcfbteLvc; }
      sal_uInt32 get_dwLowDateTime() const { return mdwLowDateTime; }
      sal_uInt32 get_dwHighDateTime() const { return mdwHighDateTime; }
      sal_uInt32 get_fcPlcflvc() const { return mfcPlcflvc; }
      sal_uInt32 get_lcbPlcflvc() const { return mlcbPlcflvc; }
      sal_uInt32 get_fcPlcasumy() const { return mfcPlcasumy; }
      sal_uInt32 get_lcbPlcasumy() const { return mlcbPlcasumy; }
      sal_uInt32 get_fcPlcfgram() const { return mfcPlcfgram; }
      sal_uInt32 get_lcbPlcfgram() const { return mlcbPlcfgram; }
      sal_uInt32 get_fcSttbListNames() const { return mfcSttbListNames; }
      sal_uInt32 get_lcbSttbListNames() const { return mlcbSttbListNames; }
      sal_uInt32 get_fcSttbfUssr() const { return mfcSttbfUssr; }
      sal_uInt32 get_lcbSttbfUssr() const { return mlcbSttbfUssr; }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: BKD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 6
*/
class WW8BKD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8BKD> Pointer_t;

    WW8BKD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8BKD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8BKD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 6)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8BKD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8BKD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "BKD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 6; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        index to BKL entry in plcfbkl that describes the
                  ending position of this bookmark in the CP stream.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ibkl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_ibkl() const
    {
            return (getS16(0x0));
    }
  
  
    /**
        when bkf.fCol is 1, this is the index to the first column of a
                  table column bookmark.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        itcFirst(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x007f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_itcFirst() const
    {
            return (getU16(0x2)& 0x007f);
    }
  
  
    /**
        when 1, this indicates that this bookmark is marking the range
                  of a Macintosh Publisher section.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fPub(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0080
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fPub() const
    {
            return (getU16(0x2)& 0x0080)>> 7;
    }
  
  
    /**
        when bkf.fCol is 1, this is the index to limit column of a
                  table column bookmark.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        itcLim(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x7f00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_itcLim() const
    {
            return (getU16(0x2)& 0x7f00)>> 8;
    }
  
  
    /**
        when 1, this bookmark marks a range of columns in a table
                  specified by [bkf.itcFirst, bkf.itcLim).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fCol(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fCol() const
    {
            return (getU16(0x2)& 0x8000)>> 15;
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: SED
    
    Stereotype ww8resource

    Stereotype needsdocument

    Parent Resource: Properties
    Size: 12
*/
class WW8SED: public WW8StructBase, public doctok::Reference< Properties>
{    WW8DocumentImplPointer mpDoc;

    public:
    typedef boost::shared_ptr<WW8SED> Pointer_t;

    WW8SED(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 12)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8SED(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 12)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8SED( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 12)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8SED(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 12)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8SED();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "SED";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 12; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    void setDoc(WW8DocumentImplPointer pDoc)
    {
        mpDoc = pDoc;
    }
      
  
    /**
        used internally by Word
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fn(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_fn() const
    {
            return (getS16(0x0));
    }
  
  
    /**
        file offset in main stream to beginning of SEPX stored for
                  section. If sed.fcSepx == 0xFFFFFFFF, the section properties for
                  the section are equal to the standard SEP (see SEP
                  definition).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fcSepx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_fcSepx() const
    {
            return (getU32(0x2));
    }
  
  
    /**
        used internally by Word
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fnMpr(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_fnMpr() const
    {
            return (getS16(0x6));
    }
  
  
    /**
        points to offset in FC space of main stream where the Macintosh
                  Print Record for a document created on a Mac will be stored
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fcMpr(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_fcMpr() const
    {
            return (getU32(0x8));
    }
  
      /**
      Operation: sepx
      */

          doctok::Reference < Properties >::Pointer_t get_sepx();


  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: SHD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
class WW8SHD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8SHD> Pointer_t;

    WW8SHD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8SHD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8SHD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 2)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8SHD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8SHD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "SHD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 2; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        foreground color (see chp.ico)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        icoFore(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x001f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_icoFore() const
    {
            return (getU16(0x0)& 0x001f);
    }
  
  
    /**
        background color (see chp.ico)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        icoBack(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x03e0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_icoBack() const
    {
            return (getU16(0x0)& 0x03e0)>> 5;
    }
  
  
    /**
        shading pattern (see ipat table below)
                  0 Automatic
                  1 Solid
                  2 5 Percent
                  3 10 Percent
                  4 20 Percent
                  5 25 Percent
                  6 30 Percent
                  7 40 Percent
                  8 50 Percent
                  9 60 Percent
                  10 70 Percent
                  11 75 Percent
                  12 80 Percent
                  13 90 Percent
                  14 Dark Horizontal
                  15 Dark Vertical
                  16 Dark Forward Diagonal
                  17 Dark Backward Diagonal
                  18 Dark Cross
                  19 Dark Diagonal Cross
                  20 Horizontal
                  21 Vertical
                  22 Forward Diagonal
                  23 Backward Diagonal
                  24 Cross
                  25 Diagonal Cross
                  35 2.5 Percent
                  36 7.5 Percent
                  37 12.5 Percent
                  38 15 Percent
                  39 17.5 Percent
                  40 22.5 Percent
                  41 27.5 Percent
                  42 32.5 Percent
                  43 35 Percent
                  44 37.5 Percent
                  45 42.5 Percent
                  46 45 Percent
                  47 47.5 Percent
                  48 52.5 Percent
                  49 55 Percent
                  50 57.5 Percent
                  51 62.5 Percent
                  52 65 Percent
                  53 67.5 Percent
                  54 72.5 Percent
                  55 77.5 Percent
                  56 82.5 Percent
                  57 85 Percent
                  58 87.5 Percent
                  59 92.5 Percent
                  60 95 Percent
                  61 97.5 Percent
                  62 97 Percent
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ipat(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfc00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        10
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_ipat() const
    {
            return (getU16(0x0)& 0xfc00)>> 10;
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: CellShd
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 10
*/
class WW8CellShd: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8CellShd> Pointer_t;

    WW8CellShd(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 10)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8CellShd(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 10)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8CellShd( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 10)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8CellShd(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 10)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8CellShd();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "CellShd";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 10; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        foreground color
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shdForeColor(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shdForeColor() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        background color
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shdBackColor(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shdBackColor() const
    {
            return (getU32(0x4));
    }
  
  
    /**
        pattern
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shdPattern(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_shdPattern() const
    {
            return (getU16(0x8));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: BRC
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
class WW8BRC: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8BRC> Pointer_t;

    WW8BRC(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8BRC(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8BRC( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 4)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8BRC(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8BRC();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "BRC";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 4; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        width of a single line in 1/8 pt, max of 32 pt.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dptLineWidth(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x00ff
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_dptLineWidth() const
    {
            return (getU16(0x0)& 0x00ff);
    }
  
  
    /**
        border type code:
                  0 none
                  1 single
                  2 thick
                  3 double
                  5 hairline
                  6 dot
                  7 dash large gap
                  8 dot dash
                  9 dot dot dash
                  10 triple
                  11 thin-thick small gap
                  12 thick-thin small gap
                  13 thin-thick-thin small gap
                  14 thin-thick medium gap
                  15 thick-thin medium gap
                  16 thin-thick-thin medium gap
                  17 thin-thick large gap
                  18 thick-thin large gap
                  19 thin-thick-thin large gap
                  20 wave
                  21 double wave
                  22 dash small gap
                  23 dash dot stroked
                  24 emboss 3D
                  25 engrave 3D
                  codes 64 - 230 represent border art types and are used only for
                  page borders.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcType(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xff00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_brcType() const
    {
            return (getU16(0x0)& 0xff00)>> 8;
    }
  
  
    /**
        color code (see chp.ico)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ico(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x00ff
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_ico() const
    {
            return (getU16(0x2)& 0x00ff);
    }
  
  
    /**
        width of space to maintain between border and text within
                  border. Must be 0 when BRC is a substructure of TC. Stored in
                  points.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dptSpace(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1f00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_dptSpace() const
    {
            return (getU16(0x2)& 0x1f00)>> 8;
    }
  
  
    /**
        when 1, border is drawn with shadow. Must be 0 when BRC is a
                  substructure of the TC
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fShadow(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x2000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        13
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fShadow() const
    {
            return (getU16(0x2)& 0x2000)>> 13;
    }
  
  
    /**
        
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fFrame(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        14
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fFrame() const
    {
            return (getU16(0x2)& 0x4000)>> 14;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused2_15(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_unused2_15() const
    {
            return (getU16(0x2)& 0x8000)>> 15;
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: TC
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 20
*/
class WW8TC: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8TC> Pointer_t;

    WW8TC(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 20)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8TC(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 20)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8TC( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 20)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8TC(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 20)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8TC();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "TC";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 20; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        set to 1 when cell is first cell of a range of cells that have
                  been merged. When a cell is merged, the display areas of the merged
                  cells are consolidated and the text within the cells is interpreted
                  as belonging to one text stream for purposes of calculating line
                  breaks.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fFirstMerged(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0001
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fFirstMerged() const
    {
            return (getU16(0x0)& 0x0001);
    }
  
  
    /**
        set to 1 when cell has been merged with preceding cell.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fMerged(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0002
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fMerged() const
    {
            return (getU16(0x0)& 0x0002)>> 1;
    }
  
  
    /**
        set to 1 when cell has vertical text flow
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fVertical(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0004
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fVertical() const
    {
            return (getU16(0x0)& 0x0004)>> 2;
    }
  
  
    /**
        for a vertical table cell, text flow is bottom to top when 1
                  and is bottom to top when 0.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fBackward(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0008
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fBackward() const
    {
            return (getU16(0x0)& 0x0008)>> 3;
    }
  
  
    /**
        set to 1 when cell has rotated characters (i.e. uses
                  @font)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fRotateFont(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0010
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fRotateFont() const
    {
            return (getU16(0x0)& 0x0010)>> 4;
    }
  
  
    /**
        set to 1 when cell is vertically merged with the cell(s) above
                  and/or below. When cells are vertically merged, the display area of
                  the merged cells are consolidated. The consolidated area is used to
                  display the contents of the first vertically merged cell (the cell
                  with fVertRestart set to 1), and all other vertically merged cells
                  (those with fVertRestart set to 0) must be empty. Cells can only be
                  merged vertically if their left and right boundaries are (nearly)
                  identical (i.e. if corresponding entries in rgdxaCenter of the
                  table rows differ by at most 3).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fVertMerge(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0020
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fVertMerge() const
    {
            return (getU16(0x0)& 0x0020)>> 5;
    }
  
  
    /**
        set to 1 when the cell is the first of a set of vertically
                  merged cells. The contents of a cell with fVertStart set to 1 are
                  displayed in the consolidated area belonging to the entire set of
                  vertically merged cells. Vertically merged cells with fVertRestart
                  set to 0 must be empty.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fVertRestart(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0040
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fVertRestart() const
    {
            return (getU16(0x0)& 0x0040)>> 6;
    }
  
  
    /**
        specifies the alignment of the cell contents relative to text
                  flow (e.g. in a cell with bottom to top text flow and bottom
                  vertical alignment, the text is shifted horizontally to match the
                  cell's right boundary):
                  0 top
                  1 center
                  2 bottom
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        vertAlign(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0180
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_vertAlign() const
    {
            return (getU16(0x0)& 0x0180)>> 7;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fUnused(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfe00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        9
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fUnused() const
    {
            return (getU16(0x0)& 0xfe00)>> 9;
    }
  
  
    /**
        preferred size of cell
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        CellPreferredSize(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_CellPreferredSize() const
    {
            return (getU16(0x2));
    }
  
  
    /**
        BRC[cbrcTc] rgbrc: notational convenience for referring to
                  brcTop, brcLeft, etc. fields.
                  specification of the top border of a table cell
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcTop() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x4));

    }
  
  
    /**
        specification of left border of table row
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcLeft() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x8));

    }
  
  
    /**
        specification of bottom border of table row
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcBottom() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0xc));

    }
  
  
    /**
        specification of right border of table row.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcRight() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x10));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: BKF
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
class WW8BKF: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8BKF> Pointer_t;

    WW8BKF(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8BKF(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8BKF( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 4)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8BKF(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8BKF();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "BKF";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 4; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        index to BKL entry in plcfbkl that describes the
                  ending position of this bookmark in the CP stream.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ibkl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_ibkl() const
    {
            return (getS16(0x0));
    }
  
  
    /**
        when bkf.fCol is 1, this is the index to the first column of a
                  table column bookmark.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        itcFirst(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x007f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_itcFirst() const
    {
            return (getU16(0x2)& 0x007f);
    }
  
  
    /**
        when 1, this indicates that this bookmark is marking the range
                  of a Macintosh Publisher section.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fPub(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0080
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fPub() const
    {
            return (getU16(0x2)& 0x0080)>> 7;
    }
  
  
    /**
        when bkf.fCol is 1, this is the index to limit column of a
                  table column bookmark.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        itcLim(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x7f00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_itcLim() const
    {
            return (getU16(0x2)& 0x7f00)>> 8;
    }
  
  
    /**
        when 1, this bookmark marks a range of columns in a table
                  specified by [bkf.itcFirst, bkf.itcLim).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fCol(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fCol() const
    {
            return (getU16(0x2)& 0x8000)>> 15;
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: LineProps
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 8
*/
class WW8LineProps: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8LineProps> Pointer_t;

    WW8LineProps(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8LineProps(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8LineProps( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 8)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8LineProps(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 8)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8LineProps();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "LineProps";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 8; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        color of line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linecolor(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_linecolor() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        width of line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linewidth(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_linewidth() const
    {
            return (getU8(0x4));
    }
  
  
    /**
        type of line, see border type code (BRC)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linetype(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_linetype() const
    {
            return (getU8(0x5));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: TBD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8TBD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8TBD> Pointer_t;

    WW8TBD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8TBD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8TBD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8TBD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8TBD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "TBD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        justification code
                  0 left tab
                  1 centered tab
                  2 right tab
                  3 decimal tab
                  4 bar
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        jc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x07
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_jc() const
    {
            return (getU8(0x0)& 0x07);
    }
  
  
    /**
        tab leader code
                  0 no leader
                  1 dotted leader
                  2 hyphenated leader
                  3 single line leader
                  4 heavy line leader
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        tlc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x38
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_tlc() const
    {
            return (getU8(0x0)& 0x38)>> 3;
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused0_6(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xc0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused0_6() const
    {
            return (getU8(0x0)& 0xc0)>> 6;
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: METAFILEPICT
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8METAFILEPICT: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8METAFILEPICT> Pointer_t;

    WW8METAFILEPICT(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8METAFILEPICT(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8METAFILEPICT( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8METAFILEPICT(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8METAFILEPICT();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "METAFILEPICT";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        Specifies the mapping mode in which the picture is drawn. 
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        mm(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_mm() const
    {
            return (getS16(0x0));
    }
  
  
    /**
        Specifies the size of the metafile picture for all modes except
                  the MM_ISOTROPIC and MM_ANISOTROPIC modes. (For more information
                  about these modes, see the yExt member.) The x-extent specifies the
                  width of the rectangle within which the picture is drawn. The
                  coordinates are in units that correspond to the mapping mode.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        xExt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_xExt() const
    {
            return (getS16(0x2));
    }
  
  
    /**
        Specifies the size of the metafile picture for all modes except
                  the MM_ISOTROPIC and MM_ANISOTROPIC modes. The y-extent specifies
                  the height of the rectangle within which the picture is drawn. The
                  coordinates are in units that correspond to the mapping mode. 
                  For MM_ISOTROPIC and MM_ANISOTROPIC modes, which can be scaled,
                  the xExt and yExt members contain an optional suggested size in
                  MM_HIMETRIC units.
                  For MM_ANISOTROPIC pictures, xExt and yExt can be zero when no
                  suggested size is supplied. For MM_ISOTROPIC pictures, an aspect
                  ratio must be supplied even when no suggested size is given. (If a
                  suggested size is given, the aspect ratio is implied by the size.)
                  To give an aspect ratio without implying a suggested size, set xExt
                  and yExt to negative values whose ratio is the appropriate aspect
                  ratio. The magnitude of the negative xExt and yExt values is
                  ignored; only the ratio is used.
                  
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        yExt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_yExt() const
    {
            return (getS16(0x4));
    }
  
  
    /**
        Identifies a memory metafile.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        hMF(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_hMF() const
    {
            return (getS16(0x6));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FFDATA
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 0
*/
class WW8FFDATA: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FFDATA> Pointer_t;

    WW8FFDATA(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FFDATA(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FFDATA( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FFDATA(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FFDATA();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FFDATA";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        unkonwn
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unknown(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unknown() const
    {
            return (getU8(0x4)& 0x3);
    }
  
  
    /**
        unkonwn
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dropdownIndex(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfc
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_dropdownIndex() const
    {
            return (getU8(0x4)& 0xfc)>> 2;
    }
  
  
    /**
        tool tip
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fTooltip(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fTooltip() const
    {
            return (getU8(0x5)& 0x1);
    }
  
  
    /**
        no mark
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fNomark(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fNomark() const
    {
            return (getU8(0x5)& 0x2)>> 1;
    }
  
  
    /**
        use size
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fUseSize(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fUseSize() const
    {
            return (getU8(0x5)& 0x4)>> 2;
    }
  
  
    /**
        numbers only
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fNumersOnly(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fNumersOnly() const
    {
            return (getU8(0x5)& 0x8)>> 3;
    }
  
  
    /**
        date only
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fDateOnly(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fDateOnly() const
    {
            return (getU8(0x5)& 0x10)>> 4;
    }
  
  
    /**
        unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fUnused(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x5
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xe0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_fUnused() const
    {
            return (getU8(0x5)& 0xe0)>> 5;
    }
  
  
    /**
        size
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        size(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_size() const
    {
            return (getU16(0x6));
    }
  
  
    /**
        
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        hpsCheckbox(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_hpsCheckbox() const
    {
            return (getU16(0x8));
    }
  
  
    /**
        title of the field
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        title(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xa
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
rtl::OUString get_title() const
    {
            return (getString(0xa));
    }
  
      /**
      Operation: FLT
      */

          sal_uInt32 get_FLT();

      /**
      Operation: default
      */

          rtl::OUString get_default();

      /**
      Operation: checked
      */

          sal_uInt16 get_checked();

      /**
      Operation: formatting
      */

          rtl::OUString get_formatting();

      /**
      Operation: help
      */

          rtl::OUString get_help();

      /**
      Operation: tooltip
      */

          rtl::OUString get_tooltip();

    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: PICF
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 0
*/
class WW8PICF: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8PICF> Pointer_t;

    WW8PICF(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8PICF(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8PICF( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8PICF(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8PICF();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "PICF";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        number of bytes in the PIC structure plus size of following
                  picture data which may be a Window's metafile, a bitmap, or the
                  filename of a TIFF file. In the case of a Macintosh PICT picture,
                  this includes the size of the PIC, the standard "x" metafile, and
                  the Macintosh PICT data. See Appendix B for more information.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lcb(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_lcb() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        number of bytes in the PIC (to allow for future
                  expansion).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbHeader(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_cbHeader() const
    {
            return (getU16(0x4));
    }
  
  
    /**
        If a Windows metafile is stored immediately following the PIC
                  structure, the mfp is a Window's METAFILEPICT structure. When the
                  data immediately following the PIC is a TIFF filename, mfp.mm == 98
                  If a bitmap is stored after the pic, mfp.mm == 99
                  When the PIC describes a bitmap, mfp.xExt is the width of the
                  bitmap in pixels and mfp.yExt is the height of the bitmap in
                  pixels..
                  
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        mfp(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x6
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_mfp() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8METAFILEPICT(*this, 0x6));

    }
  
  
    /**
        Window's bitmap structure when PIC describes a BITMAP (14
                  bytes).
                  Rect for window origin and extents when metafile is stored --
                  ignored if 0 (8 bytes).
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        bm_rcWinMF(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xe
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_bm_rcWinMF_count() const { return 14; }
sal_uInt8 get_bm_rcWinMF(sal_uInt32 nIndex) const { return getU8(0xe + nIndex * sizeof(sal_uInt8)); }

  
    /**
        horizontal measurement in twips of the rectangle the picture
                  should be imaged within. when scaling bitmaps, dxaGoal and dyaGoal
                  may be ignored if the operation would cause the bitmap to shrink or
                  grow by a non -power-of-two factor
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaGoal(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dxaGoal() const
    {
            return (getS16(0x1c));
    }
  
  
    /**
        vertical measurement in twips of the rectangle the picture
                  should be imaged within.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dyaGoal(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1e
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dyaGoal() const
    {
            return (getS16(0x1e));
    }
  
  
    /**
        horizontal scaling factor supplied by user expressed in .001%
                  units.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        mx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x20
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_mx() const
    {
            return (getU16(0x20));
    }
  
  
    /**
        vertical scaling factor supplied by user expressed in .001%
                  units.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        my(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x22
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_my() const
    {
            return (getU16(0x22));
    }
  
  
    /**
        the amount the picture has been cropped on the left in twips.
                  for all of the Crop values, a positive measurement means the
                  specified border has been moved inward from its original setting
                  and a negative measurement means the border has been moved outward
                  from its original setting.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaCropLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x24
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dxaCropLeft() const
    {
            return (getS16(0x24));
    }
  
  
    /**
        the amount the picture has been cropped on the top in
                  twips.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dyaCropTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x26
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dyaCropTop() const
    {
            return (getS16(0x26));
    }
  
  
    /**
        the amount the picture has been cropped on the right in
                  twips.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaCropRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x28
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dxaCropRight() const
    {
            return (getS16(0x28));
    }
  
  
    /**
        the amount the picture has been cropped on the bottom in
                  twips.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dyaCropBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dyaCropBottom() const
    {
            return (getS16(0x2a));
    }
  
  
    /**
        Obsolete, superseded by brcTop, etc. In WinWord 1.x, it was the
                  type of border to place around picture
                  0 single
                  1 thick
                  2 double
                  3 shadow
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x000f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_brcl() const
    {
            return (getU16(0x2c)& 0x000f);
    }
  
  
    /**
        picture consists of a single frame
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fFrameEmpty(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0010
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fFrameEmpty() const
    {
            return (getU16(0x2c)& 0x0010)>> 4;
    }
  
  
    /**
        ==1, when picture is just a bitmap
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fBitmap(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0020
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fBitmap() const
    {
            return (getU16(0x2c)& 0x0020)>> 5;
    }
  
  
    /**
        ==1, when picture is an active OLE object
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fDrawHatch(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0040
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fDrawHatch() const
    {
            return (getU16(0x2c)& 0x0040)>> 6;
    }
  
  
    /**
        ==1, when picture is just an error message
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fError(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0080
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fError() const
    {
            return (getU16(0x2c)& 0x0080)>> 7;
    }
  
  
    /**
        bits per pixel
                  0 unknown
                  1 monochrome
                  4 VGA
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        bpp(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xff00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_bpp() const
    {
            return (getU16(0x2c)& 0xff00)>> 8;
    }
  
  
    /**
        specification for border above picture
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2e
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcTop() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2e));

    }
  
  
    /**
        specification for border to the left of picture
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x32
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcLeft() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x32));

    }
  
  
    /**
        specification for border below picture
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x36
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcBottom() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x36));

    }
  
  
    /**
        specification for border to the right of picture
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcRight() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x3a));

    }
  
  
    /**
        horizontal offset of hand annotation origin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dxaOrigin(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3e
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dxaOrigin() const
    {
            return (getS16(0x3e));
    }
  
  
    /**
        vertical offset of hand annotation origin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dyaOrigin(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x40
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_dyaOrigin() const
    {
            return (getS16(0x40));
    }
  
  
    /**
        unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cProps(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x42
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_cProps() const
    {
            return (getS16(0x42));
    }
  
      /**
      Operation: DffRecord
      */

          doctok::Reference < Properties >::Pointer_t get_DffRecord();

      /**
      Operation: ffdata
      */

          doctok::Reference < Properties >::Pointer_t get_ffdata();

    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FSPA
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 26
*/
class WW8FSPA: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FSPA> Pointer_t;

    WW8FSPA(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 26)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FSPA(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 26)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FSPA( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 26)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FSPA(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 26)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FSPA();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FSPA";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 26; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        Shape Identifier. Used in conjunction with the office art data
                  (found via fcDggInfo in the FIB) to find the actual
                  data for this shape.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        spid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_spid() const
    {
            return (getS32(0x0));
    }
  
  
    /**
        xa left of rectangle enclosing shape relative to the origin of
                  the shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        xaLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_xaLeft() const
    {
            return (getS32(0x4));
    }
  
  
    /**
        ya top of rectangle enclosing shape relative to the origin of
                  the shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        yaTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_yaTop() const
    {
            return (getS32(0x8));
    }
  
  
    /**
        xa right of rectangle enclosing shape relative to the origin of
                  the shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        xaRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_xaRight() const
    {
            return (getS32(0xc));
    }
  
  
    /**
        ya bottom of the rectangle enclosing shape relative to the
                  origin of the shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        yaBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_yaBottom() const
    {
            return (getS32(0x10));
    }
  
  
    /**
        1 in the undo doc when shape is from the header doc, 0
                  otherwise (undefined when not in the undo doc)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fHdr(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0001
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fHdr() const
    {
            return (getU16(0x14)& 0x0001);
    }
  
  
    /**
        x position of shape relative to anchor CP
                  0 relative to page margin
                  1 relative to top of page
                  2 relative to text (column for horizontal text; paragraph for
                  vertical text)
                  3 reserved for future use
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        bx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0006
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_bx() const
    {
            return (getU16(0x14)& 0x0006)>> 1;
    }
  
  
    /**
        y position of shape relative to anchor CP
                  0 relative to page margin
                  1 relative to top of page
                  2 relative to text (paragraph for horizontal text; column for
                  vertical text)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        by(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0018
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_by() const
    {
            return (getU16(0x14)& 0x0018)>> 3;
    }
  
  
    /**
        text wrapping mode
                  0 like 2, but doesn't require absolute object
                  1 no text next to shape
                  2 wrap around absolute object
                  3 wrap as if no object present
                  4 wrap tightly around object
                  5 wrap tightly, but allow holes
                  6-15 reserved for future use
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        wr(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x01e0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_wr() const
    {
            return (getU16(0x14)& 0x01e0)>> 5;
    }
  
  
    /**
        text wrapping mode type (valid only for wrapping modes 2 and
                  4
                  0 wrap both sides
                  1 wrap only on left
                  2 wrap only on right
                  3 wrap only on largest side
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        wrk(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1e00
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        9
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_wrk() const
    {
            return (getU16(0x14)& 0x1e00)>> 9;
    }
  
  
    /**
        when set, temporarily overrides bx, by, forcing the xaLeft,
                  xaRight, yaTop, and yaBottom fields to all be page relative.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fRcaSimple(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x2000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        13
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fRcaSimple() const
    {
            return (getU16(0x14)& 0x2000)>> 13;
    }
  
  
    /**
        1 shape is below text
                  0 shape is above text
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fBelowText(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        14
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fBelowText() const
    {
            return (getU16(0x14)& 0x4000)>> 14;
    }
  
  
    /**
        1 anchor is locked
                  0 anchor is not locked
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fAnchorLock(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fAnchorLock() const
    {
            return (getU16(0x14)& 0x8000)>> 15;
    }
  
  
    /**
        count of textboxes in shape (undo doc only)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cTxbx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x16
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_cTxbx() const
    {
            return (getS32(0x16));
    }
  
      /**
      Operation: shape
      */

          doctok::Reference < Properties >::Pointer_t get_shape();


  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FLD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
class WW8FLD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FLD> Pointer_t;

    WW8FLD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FLD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FLD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 2)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FLD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FLD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FLD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 2; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        type of field boundary the FLD describes:
                  19 field begin mark
                  20 field separator mark
                  21 field end mark
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ch(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1f
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_ch() const
    {
            return (getU8(0x0)& 0x1f);
    }
  
  
    /**
        reserved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused0_5(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xe0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused0_5() const
    {
            return (getU8(0x0)& 0xe0)>> 5;
    }
  
  
    /**
        fld.ch == 19 (field begin mark) -> U8 field type (see flt
                  table below).
                  fld.ch == 20 (field separator mark) -> not present
                  fld.ch == 21 (field end mark) ->
                  fDiffer:1 - ignored for saved file
                  fZombieEmbed:1 - 1 when result still believes this field is an
                  EMBED or LINK field.
                  fResultDirty:1 -  when user has edited or formatted the result. ==
                  0 otherwise.
                  fResultEdited:1 - 1 when user has inserted text into or deleted
                  text from the result.
                  fLocked:1 - 1 when field is locked from recalc.
                  fPrivateResult:1 - 1 whenever the result of the field is never to
                  be shown.
                  fNested:1 - 1 when field is nested within another field.
                  fHasSep:1 - 1 when field has a field separator.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        flt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int8 get_flt() const
    {
            return (getS8(0x1));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: Rectangle
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 16
*/
class WW8Rectangle: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8Rectangle> Pointer_t;

    WW8Rectangle(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8Rectangle(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8Rectangle( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 16)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8Rectangle(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8Rectangle();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "Rectangle";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 16; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        left margin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        left(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_left() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        top margin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        top(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_top() const
    {
            return (getU32(0x4));
    }
  
  
    /**
        right margin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        right(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_right() const
    {
            return (getU32(0x8));
    }
  
  
    /**
        bottom margin
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        bottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_bottom() const
    {
            return (getU32(0xc));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FOPTE
    
    Stereotype ww8resource

    Stereotype withindex

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 6
*/
class WW8FOPTE: public WW8StructBase, public doctok::Reference< Properties>
{    sal_uInt32 mnIndex;
    public:
    typedef boost::shared_ptr<WW8FOPTE> Pointer_t;

    WW8FOPTE(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(rStream, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8FOPTE(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(pParent, nOffset, nCount), mnIndex(0)
    {
      init();
    }
    WW8FOPTE( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 6)
    
    : WW8StructBase(rSurround, nOffset, nCount), mnIndex(0)
    {
        init();
    }

    WW8FOPTE(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8StructBase(rSequence, nOffset, nCount), mnIndex(0)
    {
      init();
    }

    virtual ~WW8FOPTE();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FOPTE";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 6; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
    /**
        Set index in parent.

        @param    nIndex    the index
    */
    void setIndex(sal_uInt32 nIndex) { mnIndex = nIndex; }
      
  
    /**
        Property ID
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        pid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x3fff
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_pid() const
    {
            return (getU16(0x0)& 0x3fff);
    }
  
  
    /**
        value is a blip ID u2013 only valid if fComplex is FALSE
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fBid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        14
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fBid() const
    {
            return (getU16(0x0)& 0x4000)>> 14;
    }
  
  
    /**
        complex property, value is length
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fComplex(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8000
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        15
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_fComplex() const
    {
            return (getU16(0x0)& 0x8000)>> 15;
    }
  
  
    /**
        Value
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        op(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_op() const
    {
            return (getU32(0x2));
    }
  
      /**
      Operation: name
      */

          rtl::OUString get_name();

      /**
      Operation: value
      */

          WW8Value::Pointer_t get_value();

      /**
      Operation: stringValue
      */

          WW8Value::Pointer_t get_stringValue();

    void resolveNoAuto(Properties & rHandler);
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FDGG
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 16
*/
class WW8FDGG: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FDGG> Pointer_t;

    WW8FDGG(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FDGG(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FDGG( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 16)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FDGG(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 16)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FDGG();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FDGG";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 16; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        The current maximum shape ID
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        spidMax(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_spidMax() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        The number of ID clusters (FIDCLs)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cidcl(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_cidcl() const
    {
            return (getU32(0x4));
    }
  
  
    /**
        The total number of shapes saved (including deleted shapes, if undo information was saved)
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cspSaved(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_cspSaved() const
    {
            return (getU32(0x8));
    }
  
  
    /**
        The total number of drawings saved
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cdgSaved(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xc
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_cdgSaved() const
    {
            return (getU32(0xc));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FIDCL
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
class WW8FIDCL: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FIDCL> Pointer_t;

    WW8FIDCL(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FIDCL(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FIDCL( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 4)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FIDCL(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 4)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FIDCL();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FIDCL";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 4; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        DG owning the SPIDs in this cluster
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        dgid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_dgid() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        number of SPIDs used so far
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cspidCur(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_cspidCur() const
    {
            return (getU32(0x4));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FBSE
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0x24
*/
class WW8FBSE: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FBSE> Pointer_t;

    WW8FBSE(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x24)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FBSE(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x24)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FBSE( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0x24)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FBSE(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x24)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FBSE();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FBSE";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0x24; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        Required type on Win32
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        btWin32(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_btWin32() const
    {
            return (getU8(0x0));
    }
  
  
    /**
        Required type on Mac
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        btMacOS(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_btMacOS() const
    {
            return (getU8(0x1));
    }
  
  
    /**
        Identifier of blip
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        rgbUid(array)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_rgbUid_count() const { return 16; }
sal_uInt8 get_rgbUid(sal_uInt32 nIndex) const { return getU8(0x2 + nIndex * sizeof(sal_uInt8)); }

  
    /**
        currently unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        tag(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x12
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_tag() const
    {
            return (getU16(0x12));
    }
  
  
    /**
        Blip size in stream
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        size(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_size() const
    {
            return (getU32(0x14));
    }
  
  
    /**
        Reference count on the blip
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cRef(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x18
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_cRef() const
    {
            return (getU32(0x18));
    }
  
  
    /**
        File offset in the delay stream
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        foDelay(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1c
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_foDelay() const
    {
            return (getU32(0x1c));
    }
  
  
    /**
        How this blip is used (MSOBLIPUSAGE
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        usage(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x20
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_usage() const
    {
            return (getU8(0x20));
    }
  
  
    /**
        length of the blip name
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cbName(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x21
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_cbName() const
    {
            return (getU8(0x21));
    }
  
  
    /**
        for the future
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused2(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x22
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused2() const
    {
            return (getU8(0x22));
    }
  
  
    /**
        for the future
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused3(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x23
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unused3() const
    {
            return (getU8(0x23));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FRD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
class WW8FRD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FRD> Pointer_t;

    WW8FRD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FRD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FRD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 2)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FRD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 2)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FRD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FRD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 2; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        pid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_pid() const
    {
            return (getS16(0x0));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: ATRD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 28
*/
class WW8ATRD: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8ATRD> Pointer_t;

    WW8ATRD(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8ATRD(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8ATRD( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 28)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8ATRD(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 28)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8ATRD();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "ATRD";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 28; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        index into GrpXstAtnOwners
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ibst(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x14
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_ibst() const
    {
            return (getS16(0x14));
    }
  
  
    /**
        unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        ak(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x16
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x0003
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_ak() const
    {
            return (getU16(0x16)& 0x0003);
    }
  
  
    /**
        unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unused22_2(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x16
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfffc
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_unused22_2() const
    {
            return (getU16(0x16)& 0xfffc)>> 2;
    }
  
  
    /**
        unused
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        grfbmc(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x18
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_grfbmc() const
    {
            return (getU16(0x18));
    }
  
  
    /**
        when not -1, this tag identifies the annotation bookmark that
                  locates the range of CPs in the main document which this annotation
                  references.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lTagBkmk(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1a
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_lTagBkmk() const
    {
            return (getS32(0x1a));
    }
  
      /**
      Operation: xstUsrInitl
      */

          rtl::OUString get_xstUsrInitl();


  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: FTXBXS
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 22
*/
class WW8FTXBXS: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FTXBXS> Pointer_t;

    WW8FTXBXS(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 22)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FTXBXS(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 22)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FTXBXS( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 22)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FTXBXS(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 22)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FTXBXS();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FTXBXS";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 22; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        when not fReusable, counts the number of textboxes in this
                  story chain
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cTxbx(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_cTxbx() const
    {
            return (getS32(0x0));
    }
  
  
    /**
        when fReusable, the index of the next in the linked list of
                  reusable FTXBXSs
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        iNextReuse(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_iNextReuse() const
    {
            return (getS32(0x0));
    }
  
  
    /**
        if fReusable, counts the number of reusable FTXBXSs follow this
                  one in the linked list
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        cReusable(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_cReusable() const
    {
            return (getS32(0x4));
    }
  
  
    /**
        this FTXBXS is not currently in use
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fReusable(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int16 get_fReusable() const
    {
            return (getS16(0x8));
    }
  
  
    /**
        Shape Identifier (see FSPA) for first Office Shape in textbox
                  chain.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xe
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_lid() const
    {
            return (getU32(0xe));
    }
  
  
    /**
        
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        txidUndo(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x12
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_Int32 get_txidUndo() const
    {
            return (getS32(0x12));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPChgTabsPapx
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPChgTabsPapx: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPChgTabsPapx> Pointer_t;

    WW8sprmPChgTabsPapx(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPChgTabsPapx(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPChgTabsPapx( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPChgTabsPapx(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPChgTabsPapx();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPChgTabsPapx";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPChgTabsPapx(*this)); 
    }
        
      /**
      Array: dxaDel
      ElementType: S16()
      */

      sal_uInt32 get_dxaDel_count();

          sal_Int16 get_dxaDel(sal_uInt32 pos);
    
      /**
      Array: dxaAdd
      ElementType: S16()
      */

      sal_uInt32 get_dxaAdd_count();

          sal_Int16 get_dxaAdd(sal_uInt32 pos);
    
      /**
      Array: tbdAdd
      ElementType: TBD(Properties)
      */

      sal_uInt32 get_tbdAdd_count();

          doctok::Reference < Properties >::Pointer_t get_tbdAdd(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmCPicLocation
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmCPicLocation: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmCPicLocation> Pointer_t;

    WW8sprmCPicLocation(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmCPicLocation(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmCPicLocation( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmCPicLocation(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmCPicLocation();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmCPicLocation";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmCPicLocation(*this)); 
    }
        
  
    /**
        picture location
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fcPic(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_fcPic() const
    {
            return (getU32(0x2));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmCSymbol
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmCSymbol: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmCSymbol> Pointer_t;

    WW8sprmCSymbol(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmCSymbol(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmCSymbol( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmCSymbol(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmCSymbol();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmCSymbol";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmCSymbol(*this)); 
    }
        
  
    /**
        index of font for symbol in font table
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        font(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x02
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_font() const
    {
            return (getU16(0x02));
    }
  
  
    /**
        character code of symbol
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        char(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x04
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_char() const
    {
            return (getU16(0x04));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTTableBorders
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTTableBorders: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTTableBorders> Pointer_t;

    WW8sprmTTableBorders(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTableBorders(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTableBorders( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTTableBorders(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTTableBorders();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTTableBorders";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTTableBorders(*this)); 
    }
        
      /**
      Array: rgbbrc
      ElementType: BRC(Properties)
      */

      sal_uInt32 get_rgbbrc_count();

          doctok::Reference < Properties >::Pointer_t get_rgbbrc(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTDefTable
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTDefTable: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTDefTable> Pointer_t;

    WW8sprmTDefTable(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTDefTable(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTDefTable( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTDefTable(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTDefTable();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTDefTable";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTDefTable(*this)); 
    }
        
      /**
      Array: cellx
      ElementType: U16()
      */

      sal_uInt32 get_cellx_count();

          sal_uInt16 get_cellx(sal_uInt32 pos);
    
      /**
      Array: tc
      ElementType: TC(Properties)
      */

      sal_uInt32 get_tc_count();

          doctok::Reference < Properties >::Pointer_t get_tc(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTDefTableShd
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTDefTableShd: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTDefTableShd> Pointer_t;

    WW8sprmTDefTableShd(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTDefTableShd(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTDefTableShd( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTDefTableShd(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTDefTableShd();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTDefTableShd";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTDefTableShd(*this)); 
    }
        
      /**
      Array: shd
      ElementType: SHD(Properties)
      */

      sal_uInt32 get_shd_count();

          doctok::Reference < Properties >::Pointer_t get_shd(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellShd
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellShd: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellShd> Pointer_t;

    WW8sprmTCellShd(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellShd(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellShd( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellShd(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellShd();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellShd";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellShd(*this)); 
    }
        
      /**
      Array: shd
      ElementType: CellShd(Properties)
      */

      sal_uInt32 get_shd_count();

          doctok::Reference < Properties >::Pointer_t get_shd(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellTopColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellTopColor: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellTopColor> Pointer_t;

    WW8sprmTCellTopColor(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellTopColor(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellTopColor( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellTopColor(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellTopColor();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellTopColor";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellTopColor(*this)); 
    }
        
      /**
      Array: cellTopColor
      ElementType: U32()
      */

      sal_uInt32 get_cellTopColor_count();

          sal_uInt32 get_cellTopColor(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellLeftColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellLeftColor: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellLeftColor> Pointer_t;

    WW8sprmTCellLeftColor(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellLeftColor(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellLeftColor( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellLeftColor(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellLeftColor();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellLeftColor";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellLeftColor(*this)); 
    }
        
      /**
      Array: cellLeftColor
      ElementType: U32()
      */

      sal_uInt32 get_cellLeftColor_count();

          sal_uInt32 get_cellLeftColor(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellBottomColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellBottomColor: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellBottomColor> Pointer_t;

    WW8sprmTCellBottomColor(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellBottomColor(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellBottomColor( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellBottomColor(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellBottomColor();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellBottomColor";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellBottomColor(*this)); 
    }
        
      /**
      Array: cellBottomColor
      ElementType: U32()
      */

      sal_uInt32 get_cellBottomColor_count();

          sal_uInt32 get_cellBottomColor(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellRightColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellRightColor: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellRightColor> Pointer_t;

    WW8sprmTCellRightColor(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellRightColor(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellRightColor( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellRightColor(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellRightColor();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellRightColor";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellRightColor(*this)); 
    }
        
      /**
      Array: cellRightColor
      ElementType: U32()
      */

      sal_uInt32 get_cellRightColor_count();

          sal_uInt32 get_cellRightColor(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTGridLineProps
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0x33
*/
class WW8sprmTGridLineProps: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTGridLineProps> Pointer_t;

    WW8sprmTGridLineProps(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x33)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTGridLineProps(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x33)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTGridLineProps( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0x33)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTGridLineProps(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0x33)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTGridLineProps();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTGridLineProps";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0x33; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTGridLineProps(*this)); 
    }
        
  
    /**
        top line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsTop() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  
  
    /**
        left line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0xb
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsLeft() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0xb));

    }
  
  
    /**
        bottom line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x13
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsBottom() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x13));

    }
  
  
    /**
        right line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x1b
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsRight() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x1b));

    }
  
  
    /**
        horizontal line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsHorizontal(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x23
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsHorizontal() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x23));

    }
  
  
    /**
        vertical line properties
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsVertical(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2b
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsVertical() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x2b));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTCellShadow
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmTCellShadow: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTCellShadow> Pointer_t;

    WW8sprmTCellShadow(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellShadow(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTCellShadow( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTCellShadow(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTCellShadow();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTCellShadow";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTCellShadow(*this)); 
    }
        
      /**
      Array: cellShadow
      ElementType: CellShd(Properties)
      */

      sal_uInt32 get_cellShadow_count();

          doctok::Reference < Properties >::Pointer_t get_cellShadow(sal_uInt32 pos);
    

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBrcTop
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBrcTop: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBrcTop> Pointer_t;

    WW8sprmPBrcTop(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcTop(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcTop( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBrcTop(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBrcTop();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBrcTop";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBrcTop(*this)); 
    }
        
  
    /**
        BRC of top line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcTop() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBrcLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBrcLeft: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBrcLeft> Pointer_t;

    WW8sprmPBrcLeft(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcLeft(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcLeft( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBrcLeft(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBrcLeft();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBrcLeft";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBrcLeft(*this)); 
    }
        
  
    /**
        BRC of left line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcLeft() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBrcBottom
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBrcBottom: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBrcBottom> Pointer_t;

    WW8sprmPBrcBottom(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcBottom(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcBottom( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBrcBottom(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBrcBottom();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBrcBottom";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBrcBottom(*this)); 
    }
        
  
    /**
        BRC of bottom line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcBottom() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBrcRight
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBrcRight: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBrcRight> Pointer_t;

    WW8sprmPBrcRight(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcRight(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcRight( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBrcRight(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBrcRight();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBrcRight";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBrcRight(*this)); 
    }
        
  
    /**
        BRC of top line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcRight() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBrcBetween
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBrcBetween: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBrcBetween> Pointer_t;

    WW8sprmPBrcBetween(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcBetween(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBrcBetween( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBrcBetween(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBrcBetween();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBrcBetween";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBrcBetween(*this)); 
    }
        
  
    /**
        BRC
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        brcBetween(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_brcBetween() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8BRC(*this, 0x2));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBorderTop
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBorderTop: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBorderTop> Pointer_t;

    WW8sprmPBorderTop(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderTop(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderTop( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBorderTop(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBorderTop();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBorderTop";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBorderTop(*this)); 
    }
        
  
    /**
        properties of top line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsTop(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsTop() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBorderLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBorderLeft: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBorderLeft> Pointer_t;

    WW8sprmPBorderLeft(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderLeft(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderLeft( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBorderLeft(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBorderLeft();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBorderLeft";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBorderLeft(*this)); 
    }
        
  
    /**
        properties of left line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsLeft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsLeft() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBorderBottom
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBorderBottom: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBorderBottom> Pointer_t;

    WW8sprmPBorderBottom(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderBottom(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderBottom( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBorderBottom(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBorderBottom();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBorderBottom";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBorderBottom(*this)); 
    }
        
  
    /**
        properties of bottom line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsBottom(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsBottom() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBorderRight
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBorderRight: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBorderRight> Pointer_t;

    WW8sprmPBorderRight(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderRight(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderRight( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBorderRight(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBorderRight();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBorderRight";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBorderRight(*this)); 
    }
        
  
    /**
        properties of right line
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsRight(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsRight() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmPBorderBetween
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmPBorderBetween: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmPBorderBetween> Pointer_t;

    WW8sprmPBorderBetween(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderBetween(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmPBorderBetween( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmPBorderBetween(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmPBorderBetween();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmPBorderBetween";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmPBorderBetween(*this)); 
    }
        
  
    /**
        properties of line in between
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        linePropsBetween(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_linePropsBetween() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmCBorder
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmCBorder: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmCBorder> Pointer_t;

    WW8sprmCBorder(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmCBorder(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmCBorder( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmCBorder(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmCBorder();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmCBorder";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmCBorder(*this)); 
    }
        
  
    /**
        properties of line in between
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        lineProps(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_lineProps() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8LineProps(*this, 0x3));

    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTTPreferredWidth
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 6
*/
class WW8sprmTTPreferredWidth: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTTPreferredWidth> Pointer_t;

    WW8sprmTTPreferredWidth(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTPreferredWidth(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTPreferredWidth( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 6)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTTPreferredWidth(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTTPreferredWidth();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTTPreferredWidth";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 6; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTTPreferredWidth(*this)); 
    }
        
  
    /**
        unit
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unit(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unit() const
    {
            return (getU8(0x2));
    }
  
  
    /**
        preferred width
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        preferredWidth(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_preferredWidth() const
    {
            return (getU16(0x3));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmTTRLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 6
*/
class WW8sprmTTRLeft: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmTTRLeft> Pointer_t;

    WW8sprmTTRLeft(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTRLeft(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmTTRLeft( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 6)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmTTRLeft(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 6)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmTTRLeft();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmTTRLeft";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 6; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmTTRLeft(*this)); 
    }
        
  
    /**
        unit
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        unit(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt8 get_unit() const
    {
            return (getU8(0x2));
    }
  
  
    /**
        table indent from left
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        trleft(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x3
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt16 get_trleft() const
    {
            return (getU16(0x3));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/**
    Automatically generated class: sprmCEastAsianLayout
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
class WW8sprmCEastAsianLayout: public WW8PropertyImpl, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8sprmCEastAsianLayout> Pointer_t;

    WW8sprmCEastAsianLayout(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rStream, nOffset, nCount)
    {
      init();
    }
    WW8sprmCEastAsianLayout(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(pParent, nOffset, nCount)
    {
      init();
    }
    WW8sprmCEastAsianLayout( const WW8PropertyImpl& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8PropertyImpl(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8sprmCEastAsianLayout(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8PropertyImpl(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8sprmCEastAsianLayout();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "sprmCEastAsianLayout";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

        /**
      Return reference to properties of Sprm.
    */
      doctok::Reference < Properties >::Pointer_t getProps()
    { 
        return doctok::Reference < Properties >::Pointer_t (new WW8sprmCEastAsianLayout(*this)); 
    }
        
  
    /**
        East Asian Typography Setting
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fcEastAsianLayout(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_fcEastAsianLayout() const
    {
            return (getU32(0x2));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/** 
    Automaticallay generated class:
  DffUDefProp

*/

class DffUDefProp : public DffRecord
{
public:
    typedef boost::shared_ptr < DffUDefProp > Pointer_t;

    DffUDefProp(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffUDefProp(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffUDefProp(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffUDefProp();

    virtual void resolveLocal(Properties & props);
      void resolveNoAuto(Properties & rHandler);
    
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffUDefProp(*this); }

    virtual string getType() const 
    {
        return "DffUDefProp";
    }

    virtual string getName() const { return ""; }
    
};

/** 
    Automaticallay generated class:
  DffFSPGR

*/

class DffFSPGR : public DffRecord
{
public:
    typedef boost::shared_ptr < DffFSPGR > Pointer_t;

    DffFSPGR(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffFSPGR(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffFSPGR(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffFSPGR();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffFSPGR(*this); }

    virtual string getType() const 
    {
        return "DffFSPGR";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        the rectangle of the grouped shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        rectangle(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_rectangle() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8Rectangle(*this, 0x8));

    }
  
};

/** 
    Automaticallay generated class:
  DffOPT

*/

class DffOPT : public DffRecord
{
public:
    typedef boost::shared_ptr < DffOPT > Pointer_t;

    DffOPT(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffOPT(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffOPT(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffOPT();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffOPT(*this); }

    virtual string getType() const 
    {
        return "DffOPT";
    }

    virtual string getName() const { return ""; }
    
      /**
      Array: property
      ElementType: FOPTE(Properties)
      */

      sal_uInt32 get_property_count();

          doctok::Reference < Properties >::Pointer_t get_property(sal_uInt32 pos);
    
      /**
      Array: extraoffset
      ElementType: U32()
      */

      sal_uInt32 get_extraoffset_count();

          sal_uInt32 get_extraoffset(sal_uInt32 pos);
    
};

/** 
    Automaticallay generated class:
  DffFSP

*/

class DffFSP : public DffRecord
{
public:
    typedef boost::shared_ptr < DffFSP > Pointer_t;

    DffFSP(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffFSP(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffFSP(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffFSP();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffFSP(*this); }

    virtual string getType() const 
    {
        return "DffFSP";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        shape type
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shptype(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0xfff0
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shptype() const
    {
            return (getU32(0x0)& 0xfff0)>> 4;
    }
  
  
    /**
        shape id
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpid(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpid() const
    {
            return (getU32(0x8));
    }
  
  
    /**
        This shape is a group shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfGroup(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x1
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfGroup() const
    {
            return (getU32(0x10)& 0x1);
    }
  
  
    /**
        Not a top-level shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfChild(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x2
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        1
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfChild() const
    {
            return (getU32(0x10)& 0x2)>> 1;
    }
  
  
    /**
        This is the topmost group shape. Exactly one of these per drawing.
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfPatriarch(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        2
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfPatriarch() const
    {
            return (getU32(0x10)& 0x4)>> 2;
    }
  
  
    /**
        The shape has been deleted
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfDeleted(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        3
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfDeleted() const
    {
            return (getU32(0x10)& 0x8)>> 3;
    }
  
  
    /**
        The shape is an OLE object
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfOleShape(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        4
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfOleShape() const
    {
            return (getU32(0x10)& 0x10)>> 4;
    }
  
  
    /**
        Shape has a hspMaster property
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfHaveMaster(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x20
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        5
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfHaveMaster() const
    {
            return (getU32(0x10)& 0x20)>> 5;
    }
  
  
    /**
        Shape is flipped horizontally
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfFlipH(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x40
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        6
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfFlipH() const
    {
            return (getU32(0x10)& 0x40)>> 6;
    }
  
  
    /**
        Shape is flipped vertically
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfFlipV(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x80
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        7
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfFlipV() const
    {
            return (getU32(0x10)& 0x80)>> 7;
    }
  
  
    /**
        Connector type of shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfConnector(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x100
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        8
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfConnector() const
    {
            return (getU32(0x10)& 0x100)>> 8;
    }
  
  
    /**
        Shape has an anchor of some kind
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfHaveAnchor(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x200
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        9
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfHaveAnchor() const
    {
            return (getU32(0x10)& 0x200)>> 9;
    }
  
  
    /**
        Background shape
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfBackground(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x400
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        10
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfBackground() const
    {
            return (getU32(0x10)& 0x400)>> 10;
    }
  
  
    /**
        Shape has a shape type property
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        shpfHaveSpt(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x10
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        0x800
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        11
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_shpfHaveSpt() const
    {
            return (getU32(0x10)& 0x800)>> 11;
    }
  
      /**
      Operation: shptypename
      */

          rtl::OUString get_shptypename();

};

/** 
    Automaticallay generated class:
  DffDGG

*/

class DffDGG : public DffRecord
{
public:
    typedef boost::shared_ptr < DffDGG > Pointer_t;

    DffDGG(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffDGG(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffDGG(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffDGG();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffDGG(*this); }

    virtual string getType() const 
    {
        return "DffDGG";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        the dgg structure
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fdgg(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_fdgg() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8FDGG(*this, 0x8));

    }
  
      /**
      Array: fidcl
      ElementType: FIDCL(Properties)
      */

      sal_uInt32 get_fidcl_count();

          doctok::Reference < Properties >::Pointer_t get_fidcl(sal_uInt32 pos);
    
};

/** 
    Automaticallay generated class:
  DffBSE

*/

class DffBSE : public DffRecord
{
public:
    typedef boost::shared_ptr < DffBSE > Pointer_t;

    DffBSE(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffBSE(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffBSE(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffBSE();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffBSE(*this); }

    virtual string getType() const 
    {
        return "DffBSE";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        the FBSE structure
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fbse(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        0
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_fbse() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8FBSE(*this, 0x8));

    }
  
      /**
      Operation: blipname
      */

          rtl::OUString get_blipname();

      /**
      Operation: blip
      */

          doctok::Reference < Properties >::Pointer_t get_blip();

};

/** 
    Automaticallay generated class:
  DffBlipPng

*/

class DffBlipPng : public DffRecord
{
public:
    typedef boost::shared_ptr < DffBlipPng > Pointer_t;

    DffBlipPng(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffBlipPng(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffBlipPng(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffBlipPng();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffBlipPng(*this); }

    virtual string getType() const 
    {
        return "DffBlipPng";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        the actual PNG
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        payload(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x19
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < BinaryObj >::Pointer_t get_payload() const
    {
    return doctok::Reference < BinaryObj >::Pointer_t(new WW8BinaryObjReference(getRemainder(0x19)));

    }
  
};

/** 
    Automaticallay generated class:
  DffBlipDib

*/

class DffBlipDib : public DffRecord
{
public:
    typedef boost::shared_ptr < DffBlipDib > Pointer_t;

    DffBlipDib(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffBlipDib(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffBlipDib(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffBlipDib();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffBlipDib(*this); }

    virtual string getType() const 
    {
        return "DffBlipDib";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        the actual DIB
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        payload(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x19
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < BinaryObj >::Pointer_t get_payload() const
    {
    return doctok::Reference < BinaryObj >::Pointer_t(new WW8BinaryObjReference(getRemainder(0x19)));

    }
  
};

/** 
    Automaticallay generated class:
  DffSpContainer

*/

class DffSpContainer : public DffRecord
{
public:
    typedef boost::shared_ptr < DffSpContainer > Pointer_t;

    DffSpContainer(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffSpContainer(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffSpContainer(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffSpContainer();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffSpContainer(*this); }

    virtual string getType() const 
    {
        return "DffSpContainer";
    }

    virtual string getName() const { return ""; }
    
      /**
      Operation: blip
      */

          doctok::Reference < Properties >::Pointer_t get_blip();

      /**
      Operation: shptxt
      */

          doctok::Reference < Stream >::Pointer_t get_shptxt();

};

/**
    Automatically generated class: FDG
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
class WW8FDG: public WW8StructBase, public doctok::Reference< Properties>
{
    public:
    typedef boost::shared_ptr<WW8FDG> Pointer_t;

    WW8FDG(
        WW8Stream & rStream, 
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rStream, nOffset, nCount)
    {
      init();
    }
    WW8FDG(
        WW8StructBase * pParent,
        sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(pParent, nOffset, nCount)
    {
      init();
    }
    WW8FDG( const WW8StructBase& rSurround,
    sal_uInt32 nOffset = 0, sal_uInt32 nCount = 0)
    
    : WW8StructBase(rSurround, nOffset, nCount)
    {
        init();
    }

    WW8FDG(
        const Sequence & 
        rSequence, sal_uInt32 nOffset = 0, 
        sal_uInt32 nCount = 0)
    : WW8StructBase(rSequence, nOffset, nCount)
    {
      init();
    }

    virtual ~WW8FDG();

    void init();

    /**
        Return type of resource.
    */
    virtual string getType() const
    {
        return "FDG";
    }

    /**
        Return static size.
    */
    static sal_uInt32 getSize() { return 0; }

    /**
        Calculate actual size.
    */  
    sal_uInt32 calcSize();

    
  
    /**
        The number of shapes in this drawing
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        csp(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x0
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_csp() const
    {
            return (getU32(0x0));
    }
  
  
    /**
        The last MSOSPID given to an SP in this DG
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        spidCur(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x4
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
sal_uInt32 get_spidCur() const
    {
            return (getU32(0x4));
    }
  

  void dump(OutputWithDepth < string > & o) const;

  void resolve(Properties & rHandler);

  };
    
/** 
    Automaticallay generated class:
  DffDg

*/

class DffDg : public DffRecord
{
public:
    typedef boost::shared_ptr < DffDg > Pointer_t;

    DffDg(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(pParent, nOffset, nCount) {}

    DffDg(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 nCount)

    : DffRecord(rStream, nOffset, nCount) {}

    DffDg(DffRecord & rRecord)

    : DffRecord(rRecord) {}
    virtual ~DffDg();

    virtual void resolveLocal(Properties & props);
    virtual void dump(OutputWithDepth < string > & o) const;

    virtual DffRecord * clone() const { return new DffDg(*this); }

    virtual string getType() const 
    {
        return "DffDg";
    }

    virtual string getName() const { return ""; }
    
  
    /**
        The FDG data structure
        
        <table>
        <tr>
        <th>
        Name
        </th>
        <td>
        fdg(attribute)
        </td>
        </tr>
        <tr>
        <th>
        Offset
        </th>
        <td>
        0x8
        </td>
        </tr>
        <tr>
        <th>
        Mask
        </th>
        <td>
        
        </td>
        </tr>
        <tr>
        <th>
        Shift
        </th>
        <td>
        
        </td>
        </tr>
        </table>
        */
        
doctok::Reference < Properties >::Pointer_t get_fdg() const
    {
            return doctok::Reference < Properties >::Pointer_t(new WW8FDG(*this, 0x8));

    }
  
};

      
rtl::OUString getDffOptName(sal_uInt32 nPid);
bool isBooleanDffOpt(sal_uInt32 nId);
}
#endif // INCLUDED_RESOURCES_HXX
