/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SectionsWindow.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/09 11:56:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "precompiled_reportdesign.hxx"

#ifndef RPTUI_SECTIONSWINDOW_HXX
#include "SectionsWindow.hxx"
#endif
#ifndef RPTUI_REPORT_WINDOW_HXX
#include "ReportWindow.hxx"
#endif
#ifndef RPTUI_RULER_HXX
#include "ReportRuler.hxx"
#endif
#ifndef _RPTUI_SLOTID_HRC_
#include "rptui_slotid.hrc"
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif
#ifndef RPTUI_REPORTCONTROLLER_HXX
#include "ReportController.hxx"
#endif
#ifndef _REPORT_SECTIONVIEW_HXX
#include "SectionView.hxx"
#endif
#ifndef _REPORT_RPTUIDEF_HXX
#include "RptDef.hxx"
#endif
#ifndef REPORT_REPORTSECTION_HXX
#include "ReportSection.hxx"
#endif
#ifndef RPTUI_DESIGNVIEW_HXX
#include "DesignView.hxx"
#endif
#ifndef REPORTDESIGN_SHARED_UISTRINGS_HRC
#include "uistrings.hrc"
#endif
#ifndef RTPUI_REPORTDESIGN_HELPID_HRC
#include "helpids.hrc"
#endif
#ifndef _RPTUI_DLGRESID_HRC
#include "RptResId.hrc"
#endif
#include <boost/bind.hpp>
#include <functional>
#include <algorithm>
#include <vcl/svapp.hxx>

namespace rptui
{
#define SECTION_OFFSET	3

using namespace ::com::sun::star;
using namespace ::comphelper;

OSectionsWindow::TSectionsMap::iterator lcl_getIteratorAtPos(USHORT _nPos,OSectionsWindow::TSectionsMap& _aSection)
{
    if ( _nPos < _aSection.size() )
    {
        OSectionsWindow::TSectionsMap::iterator aRet = _aSection.begin();
        ::std::advance(aRet,_nPos);
        return aRet;
    }
    return _aSection.end();
}
// -----------------------------------------------------------------------------

DBG_NAME( rpt_OSectionsWindow );
OSectionsWindow::OSectionsWindow( Window* _pParent,OReportWindow* _pReportWindow) 
: Window( _pParent,WB_DIALOGCONTROL)
,OPropertyChangeListener(m_aMutex)
,m_pParent(_pReportWindow)
{
	DBG_CTOR( rpt_OSectionsWindow,NULL);
	SetUniqueId(UID_SECTIONSWINDOW);
	SetMapMode( MapMode( MAP_100TH_MM ) );
	ImplInitSettings();
}
// -----------------------------------------------------------------------------
OSectionsWindow::~OSectionsWindow()
{
	try
	{
		TSectionsMap::iterator aIter = m_aSections.begin();
		TSectionsMap::iterator aEnd = m_aSections.end();
		for (;aIter != aEnd ; ++aIter)
			aIter->second.first->dispose();

        ::std::for_each(m_aGroupChangeMultiplexer.begin(),m_aGroupChangeMultiplexer.end(),
            ::std::compose1(::boost::mem_fn(&OPropertyChangeMultiplexer::dispose),::std::select2nd<TGroupChangeMultiplexer::value_type>()));
	}
	catch (uno::Exception&)
	{
	}
	m_aSections.clear();

	DBG_DTOR( rpt_OSectionsWindow,NULL);
}
// -----------------------------------------------------------------------------
OSectionsWindow::TSectionsMap::iterator lcl_findSection(OSectionsWindow::TSectionsMap& _rMap,const uno::Reference< report::XSection>& _xSection)
{
    OSectionsWindow::TSectionsMap::iterator aIter = _rMap.begin();
	OSectionsWindow::TSectionsMap::iterator aEnd = _rMap.end();
	for (;aIter != aEnd && aIter->second.second != _xSection; ++aIter)
		;
    return aIter;
}
// -----------------------------------------------------------------------------
void OSectionsWindow::_propertyChanged(const beans::PropertyChangeEvent& _rEvent) throw( uno::RuntimeException)
{
	uno::Reference< report::XSection > xSection(_rEvent.Source,uno::UNO_QUERY);
    if ( xSection.is() )
    {
        TSectionsMap::iterator aIter = lcl_findSection(m_aSections,xSection);

	    if ( aIter != m_aSections.end() )
	    {
		    if ( _rEvent.PropertyName.equals(PROPERTY_NAME) )
            {
                if ( !xSection->getGroup().is() )
                {
                    aIter->first->setTitle(xSection->getName());
			        aIter->first->Invalidate(INVALIDATE_NOERASE);
                }
            }
		    else if ( _rEvent.PropertyName.equals(PROPERTY_HEIGHT) )
		    {
                m_pParent->SetUpdateMode(FALSE);
			    m_pParent->notifyHeightChanged();
			    Resize();
                m_pParent->SetUpdateMode(TRUE);
			    aIter->first->Invalidate(INVALIDATE_NOERASE);
			    /*m_pParent->GetParent()->*/Invalidate(INVALIDATE_NOCHILDREN|INVALIDATE_NOERASE|INVALIDATE_TRANSPARENT);
		    }
	    }
    }
    else if ( _rEvent.PropertyName.equals(PROPERTY_EXPRESSION) )
    {
        uno::Reference< report::XGroup > xGroup(_rEvent.Source,uno::UNO_QUERY);
        if ( xGroup.is() )
        {
            setGroupSectionTitle(xGroup,RID_STR_HEADER,::std::mem_fun(&OGroupHelper::getHeader),::std::mem_fun(&OGroupHelper::getHeaderOn));
            setGroupSectionTitle(xGroup,RID_STR_FOOTER,::std::mem_fun(&OGroupHelper::getFooter),::std::mem_fun(&OGroupHelper::getFooterOn));
        }
    }
}
// -----------------------------------------------------------------------------
void OSectionsWindow::setGroupSectionTitle(const uno::Reference< report::XGroup>& _xGroup,USHORT _nResId,::std::mem_fun_t<uno::Reference<report::XSection> , OGroupHelper> _pGetSection,::std::mem_fun_t<sal_Bool,OGroupHelper> _pIsSectionOn)
{
    OGroupHelper aGroupHelper(_xGroup);
    if ( _pIsSectionOn(&aGroupHelper) )
    {
        uno::Reference< report::XSection > xSection = _pGetSection(&aGroupHelper);
        String sTitle = String(ModuleRes(_nResId));
        sTitle.SearchAndReplace('#',_xGroup->getExpression());
        TSectionsMap::iterator aIter = lcl_findSection(m_aSections,xSection);
        if ( m_aSections.end() != aIter )
        {
            aIter->first->setTitle(sTitle);
            aIter->first->Invalidate(INVALIDATE_CHILDREN);
        }
    }
}
//------------------------------------------------------------------------------
void OSectionsWindow::Resize()
{
	Window::Resize();	
	if ( m_aSections.empty() )
		return;
	
	const Point aOffset = LogicToPixel( Point( SECTION_OFFSET, SECTION_OFFSET ), MAP_APPFONT );
	Point aStartPoint(0,-m_pParent->getScrollOffset().Y());

	TSectionsMap::iterator aIter = m_aSections.begin();
	TSectionsMap::iterator aEnd = m_aSections.end();
	for (sal_Int32 i = 0;aIter != aEnd ; ++aIter,++i)
	{
		::boost::shared_ptr<OStartMarker> pStartMarker = aIter->first;
		uno::Reference< report::XSection> xSection = aIter->second.second;
		Size aSectionSize = LogicToPixel( Size( 0,xSection->getHeight() ),MAP_100TH_MM );
		
		if ( !pStartMarker->isCollapsed() )
		{	
			if ( pStartMarker->getMinHeight() > aSectionSize.Height() )
			{
				const sal_Int32 nMinHeight = pStartMarker->getMinHeight();
				pStartMarker->SetPosSizePixel(Point(aOffset.X(),aStartPoint.Y()),Size(REPORT_STARTMARKER_WIDTH,nMinHeight));
				aSectionSize.Height() = nMinHeight;
			}
			else
				pStartMarker->SetPosSizePixel(Point(aOffset.X(),aStartPoint.Y()),Size(REPORT_STARTMARKER_WIDTH,aSectionSize.Height()));
    	}
		else
		{
			aSectionSize.Height() = pStartMarker->getMinHeight();
			pStartMarker->SetPosSizePixel(Point(aOffset.X(),aStartPoint.Y()),Size(REPORT_STARTMARKER_WIDTH,aSectionSize.Height()));			
		}
		aStartPoint.Y() += aSectionSize.Height() + m_pParent->getSplitterHeight();
	} // for (;aIter != aEnd ; ++aIter)
}
//------------------------------------------------------------------------------
void OSectionsWindow::ImplInitSettings()
{
	SetBackground( );
}
//-----------------------------------------------------------------------------
void OSectionsWindow::DataChanged( const DataChangedEvent& rDCEvt )
{
	Window::DataChanged( rDCEvt );

	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		ImplInitSettings();		
		Invalidate();
	}
}
//----------------------------------------------------------------------------
void OSectionsWindow::addSection(const uno::Reference< report::XSection >& _xSection,const ::rtl::OUString& _sColorEntry,USHORT _nPosition)
{
	::boost::shared_ptr<OStartMarker> pMarker( new OStartMarker(this,_sColorEntry) );
    pMarker->setCollapsedHdl(LINK(m_pParent,OReportWindow,Collapsed));
	pMarker->Show();

	::rtl::Reference< comphelper::OPropertyChangeMultiplexer> pMulti = new OPropertyChangeMultiplexer(this,_xSection.get());
	pMulti->addProperty(PROPERTY_NAME);
	pMulti->addProperty(PROPERTY_HEIGHT);
	
    beans::PropertyChangeEvent aEvent;
    aEvent.Source = _xSection;
    aEvent.PropertyName = PROPERTY_NAME;
    uno::Reference< report::XGroup > xGroup(_xSection->getGroup());
    if ( xGroup.is() )
    {
        if ( m_aGroupChangeMultiplexer.find(xGroup) == m_aGroupChangeMultiplexer.end() )
        {
            ::rtl::Reference< comphelper::OPropertyChangeMultiplexer> pGroupMulti = new OPropertyChangeMultiplexer(this,xGroup.get());
	        pGroupMulti->addProperty(PROPERTY_EXPRESSION);
            m_aGroupChangeMultiplexer.insert(TGroupChangeMultiplexer::value_type(xGroup,pGroupMulti));
        }
        aEvent.Source = xGroup;
        aEvent.PropertyName = PROPERTY_EXPRESSION;
    }
    
    TSectionsMap::iterator aInsertPos = m_aSections.insert(lcl_getIteratorAtPos(_nPosition,m_aSections) , TSectionsMap::value_type(TSectionPair(pMarker,TSectionMutilPair(pMulti,_xSection))));
    OSL_ENSURE(_nPosition || aInsertPos == m_aSections.begin(),"Wrong position!");
    _propertyChanged(aEvent);
	Resize();
}
//----------------------------------------------------------------------------
USHORT OSectionsWindow::getPosition(const uno::Reference< report::XSection >& _xSection) const
{
	USHORT nPos = 0;
	TSectionsMap::const_iterator aIter = m_aSections.begin();
	TSectionsMap::const_iterator aEnd = m_aSections.end();
	for (;aIter != aEnd && aIter->second.second != _xSection; ++aIter,++nPos)
		;
	return nPos;
}
//----------------------------------------------------------------------------
void OSectionsWindow::removeSection(USHORT _nPosition)
{
	if ( _nPosition < m_aSections.size() )
	{
		TSectionsMap::iterator aPos = lcl_getIteratorAtPos(_nPosition,m_aSections);
		aPos->second.first->dispose();
		m_aSections.erase(aPos);
		Resize();
	} // if ( _nPosition < m_aSections.size() )
}
//------------------------------------------------------------------------------
//----------------------------------------------------------------------------
sal_Int32 OSectionsWindow::getRulerWidth() const
{
	OSL_ENSURE(!m_aSections.empty(),"You have to check the size before calling this method");
	return m_aSections.begin()->first->getRulerOffset();
}

//----------------------------------------------------------------------------
USHORT OSectionsWindow::find(const OStartMarker* _pMarker) const
{
	TSectionsMap::const_iterator aIter = m_aSections.begin();
	TSectionsMap::const_iterator aEnd = m_aSections.end();
	USHORT i = 0;
	for (;aIter != aEnd && _pMarker != aIter->first.get(); ++aIter,++i)
		;
	return i;
}
//----------------------------------------------------------------------------
void OSectionsWindow::showRuler(sal_Bool _bShow)
{
	::std::for_each(m_aSections.begin(),m_aSections.end(),
		::std::compose1(::boost::bind(&OStartMarker::showRuler,_1,_bShow),::std::select1st<TSectionsMap::value_type>()));
    ::std::for_each(m_aSections.begin(),m_aSections.end(),
        ::std::compose1(::boost::bind(&OStartMarker::Window::Invalidate,_1,USHORT(INVALIDATE_NOERASE)),::std::select1st<TSectionsMap::value_type>()));
}
//----------------------------------------------------------------------------
sal_Int32 OSectionsWindow::getMinHeight(USHORT _nPos) const
{
	sal_Int32 nHeight = 0;
	if ( _nPos < m_aSections.size() )
    {
        OSectionsWindow::TSectionsMap::const_iterator aRet = m_aSections.begin();
        ::std::advance(aRet,_nPos);
		nHeight = aRet->first->getMinHeight();
    }
	return nHeight;
}
//-----------------------------------------------------------------------------
void OSectionsWindow::showProperties(const OStartMarker* _pStartMarker)
{
	m_pParent->showProperties( lcl_getIteratorAtPos(find(_pStartMarker),m_aSections)->second.second.get() );
}
//----------------------------------------------------------------------------
void OSectionsWindow::MouseButtonDown( const MouseEvent& rMEvt )
{
	if ( rMEvt.IsLeft() )
	{
        GrabFocus();
		uno::Sequence< beans::PropertyValue> aArgs;
		m_pParent->getReportView()->getController()->executeChecked(SID_SELECT_REPORT,aArgs);
	}
    Window::MouseButtonDown(rMEvt);
}
//------------------------------------------------------------------------
void OSectionsWindow::setMarked(const uno::Reference< report::XSection >& _xSection,sal_Bool _bMark)
{
	TSectionsMap::iterator aIter = m_aSections.begin();
	TSectionsMap::iterator aEnd = m_aSections.end();
	for (;aIter != aEnd ; ++aIter)
	{
        if ( aIter->second.second != _xSection )
        {
			aIter->first->setMarked(sal_False);
			aIter->first->Invalidate(INVALIDATE_NOCHILDREN|INVALIDATE_NOERASE);
		}
        else if ( _bMark != aIter->first->isMarked() )
		{
			aIter->first->setMarked(_bMark);
			aIter->first->Invalidate(INVALIDATE_NOCHILDREN|INVALIDATE_NOERASE);
		}
	}
}
// -----------------------------------------------------------------------------
void OSectionsWindow::fillCollapsedSections(::std::vector<sal_uInt16>& _rCollapsedPositions) const
{
    TSectionsMap::const_iterator aIter = m_aSections.begin();
	TSectionsMap::const_iterator aEnd = m_aSections.end();
	for (sal_uInt16 i = 0;aIter != aEnd ; ++aIter,++i)
	{
		if ( aIter->first->isCollapsed() )
            _rCollapsedPositions.push_back(i);
	}
}
// -----------------------------------------------------------------------------
void OSectionsWindow::collapseSections(const uno::Sequence< beans::PropertyValue>& _aCollpasedSections)
{
    const beans::PropertyValue* pIter = _aCollpasedSections.getConstArray();
    const beans::PropertyValue* pEnd = pIter + _aCollpasedSections.getLength();
    for (; pIter != pEnd; ++pIter)
    {
        sal_Int32 nPos = -1;
        if ( pIter->Value >>= nPos )
        {
            TSectionsMap::iterator aPos = lcl_getIteratorAtPos(static_cast<sal_uInt16>(nPos),m_aSections);
            if ( m_aSections.end() != aPos )
                aPos->first->setCollapsed(sal_True);
        }
    }
}
//==============================================================================
} // rptui
//==============================================================================

