/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: st_unit.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:06:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_ST_UNIT_HXX
#define ARY_STORE_ST_UNIT_HXX

// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
#include <vector>
#include <cosv/template/dyn.hxx>
#include <cosv/template/tplutil.hxx>
    // PARAMETERS
#include <ary/x_ary.hxx>


namespace ary
{
namespace store
{


/** @att
    This class is ONLY to be used as element of ::ary::store::Container.
    Any other use may result in unpredictable behaviour.
*/
template <class ELEM>
class StorageUnit
{
  public:
    typedef StorageUnit<ELEM>                               self;
    typedef ELEM                                            element_type;

    // LIFECYCLE
                        StorageUnit()           {}
                        ~StorageUnit()          {}
    // OPERATIONS

    // INQUIRY
    bool                IsEmpty() const         { return bool(pEntity); }
    const element_type &
                        Entity() const          /// @precond bool(pEntity)
                                                { return *pEntity; }
    const element_type *
                        EntityPtr() const       { return pEntity.Ptr(); }
    RCid                EntityClass() const     { return pEntity
                                                    ?   pEntity->ClassId()
                                                    :   RCid(0);
                                                }
    // ACCESS
    /// Deletes an eventually previous present Entity.
    void                Set_Entity(
                            DYN ELEM &          let_drEntity )
                                                { pEntity = &let_drEntity; }
    element_type &      Entity()                /// @precond bool(pEntity)
                                                { return *pEntity; }
    element_type *      EntityPtr()             { return pEntity.Ptr(); }

  private:
    // Forbidden:
                        StorageUnit(const self & i_rOther);
    self &              operator=(const self & i_rOther);

    // DATA
    Dyn<ELEM>           pEntity;
};




}   // namespace store
}   // namespace ary

#endif
