/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MFramePeer;
import sun.java2d.SurfaceData;

public class MEmbeddedFramePeer
extends MFramePeer {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.motif.xembed.MEmbeddedFramePeer");
    static final int XEMBED_FOCUS_CURRENT = 0;
    static final int XEMBED_FOCUS_FIRST = 1;
    static final int XEMBED_FOCUS_LAST = 2;
    LinkedList<AWTKeyStroke> strokes = new LinkedList();

    public MEmbeddedFramePeer(EmbeddedFrame embeddedFrame) {
        super(embeddedFrame);
        xembedLog.fine("Creating XEmbed-enabled motif embedded frame, frame supports XEmbed:" + this.supportsXEmbed());
    }

    void create(MComponentPeer mComponentPeer) {
        this.NEFcreate(mComponentPeer, ((MEmbeddedFrame)this.target).handle);
    }

    native void NEFcreate(MComponentPeer var1, long var2);

    native void pShowImpl();

    void pShow() {
        this.pShowImpl();
    }

    boolean supportsXEmbed() {
        EmbeddedFrame embeddedFrame = (EmbeddedFrame)this.target;
        if (embeddedFrame != null) {
            return embeddedFrame.supportsXEmbed();
        }
        return false;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        xembedLog.fine("Peer made visible");
        if (bl && !this.supportsXEmbed()) {
            xembedLog.fine("Synthesizing FocusIn");
            this.synthesizeFocusInOut(true);
        }
    }

    public native void synthesizeFocusInOut(boolean var1);

    native boolean isXEmbedActive();

    native boolean isXEmbedApplicationActive();

    native void requestXEmbedFocus();

    public boolean requestWindowFocus() {
        xembedLog.fine("In requestWindowFocus");
        if (this.isXEmbedActive()) {
            if (this.isXEmbedApplicationActive()) {
                xembedLog.fine("Requesting focus from embedding host");
                this.requestXEmbedFocus();
                return true;
            }
            xembedLog.fine("Host application is not active");
            return false;
        }
        xembedLog.fine("Requesting focus from X");
        return super.requestWindowFocus();
    }

    void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    void notifyStarted() {
        this.updateDropTarget();
    }

    native void traverseOut(boolean var1);

    void handleFocusIn(int n) {
        xembedLog.log(Level.FINE, "handleFocusIn {0}", new Object[]{n});
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                    public void run() {
                        Component component = ((Container)MEmbeddedFramePeer.this.target).getFocusTraversalPolicy().getFirstComponent((Container)MEmbeddedFramePeer.this.target);
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }
                });
                break;
            }
            case 2: {
                SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                    public void run() {
                        Component component = ((Container)MEmbeddedFramePeer.this.target).getFocusTraversalPolicy().getLastComponent((Container)MEmbeddedFramePeer.this.target);
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    public void handleWindowFocusIn() {
        super.handleWindowFocusIn();
        xembedLog.fine("windowFocusIn");
    }

    public void handleWindowFocusOut(Window window) {
        super.handleWindowFocusOut(window);
        xembedLog.fine("windowFocusOut, opposite is null?:" + (window == null));
    }

    native void pReshapePrivate(int var1, int var2, int var3, int var4);

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        if (this.disposed) {
            return;
        }
        this.paintPending = false;
        this.pReshapePrivate(n, n2, n3, n4);
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            SurfaceData surfaceData = this.surfaceData;
            if (surfaceData != null) {
                this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                surfaceData.invalidate();
            }
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
        this.validateSurface(n3, n4);
        ++this.serialNum;
    }

    public native Rectangle getBoundsPrivate();
}

