/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Installer;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.InstallerHelper.LinuxHelper;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.ProductDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.ExecuteProcess;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;

public class LinuxInstaller
extends Installer {
    LinuxHelper helper = new LinuxHelper();

    public void preInstall(PackageDescription packageData) {
        InstallData installData = InstallData.getInstance();
        this.helper.getLinuxPackageNamesFromRpmquery(packageData, installData);
        this.helper.getLinuxFileInfo(packageData);
    }

    public void postInstall(PackageDescription packageData) {
        InstallData data = InstallData.getInstance();
        if (!data.isAbortedInstallation()) {
            data.setStillRunning(true);
            this.helper.createPackageNameFileAtPostinstall(data, packageData);
            this.helper.saveModulesLogFile(data);
            data.setStillRunning(false);
        }
    }

    public void preUninstall(PackageDescription packageData) {
        HashMap packageNames = this.helper.readPackageNamesFile();
        this.helper.setFullPackageNameAtUninstall(packageData, packageNames);
        this.helper.getLinuxFileInfo(packageData);
    }

    public void defineDatabasePath() {
        InstallData data = InstallData.getInstance();
        String oldDatabasePath = data.getDatabasePath();
        data.setDatabasePath(null);
        if (data.isUserInstallation()) {
            String databasePath = this.helper.getLinuxDatabasePath(data);
            data.setDatabasePath(databasePath);
            if (!databasePath.equals(oldDatabasePath)) {
                data.setDatabaseAnalyzed(false);
            }
        }
    }

    public String getChangeInstallDir(PackageDescription packageData) {
        String installDir = null;
        InstallData installData = InstallData.getInstance();
        String packageName = packageData.getPkgRealName();
        if (packageName != null) {
            String rpmCommand = "rpm -q --queryformat %{INSTALLPREFIX} " + packageName;
            String[] rpmCommandArray = new String[]{"rpm", "-q", "--queryformat", "%{INSTALLPREFIX}", packageName};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, returnVector, returnErrorVector);
            String returnString = (String)returnVector.get(0);
            returnString = returnString.replaceAll("//", "/");
            String log = rpmCommand + "<br><b>Returns: " + returnString + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
            installDir = returnString;
        }
        return installDir;
    }

    public void installPackage(PackageDescription packageData) {
        String packageName;
        ProductDescription productData = SetupDataProvider.getProductDescription();
        InstallData data = InstallData.getInstance();
        String log = "";
        String installDir = data.getInstallDir();
        String packagePath = data.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((packageName = packageData.getPackageName()).equals("") || packageName == null) {
            log = "<b>No package name specified. Nothing to do</b>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            log = "<b>Package Name: " + packageName + "</b>";
            LogManager.addCommandsLogfileComment(log);
            File completePackage = new File(packagePath, packageName);
            packageName = completePackage.getPath();
            if (completePackage.exists()) {
                String[] rpmCommandArray;
                String fixedInstallDir = this.helper.fixInstallationDirectory(installDir);
                String relocations = this.helper.getRelocationString(packageData, packageName);
                if (relocations != null) {
                    relocations = relocations + fixedInstallDir;
                }
                String rpmCommand = "";
                String databasePath = null;
                String databaseString = "";
                boolean useLocalDatabase = false;
                if (data.isUserInstallation() && (databasePath = data.getDatabasePath()) == null) {
                    databasePath = this.helper.getLinuxDatabasePath(data);
                    data.setDatabasePath(databasePath);
                }
                if (databasePath != null && !databasePath.equalsIgnoreCase("null")) {
                    databaseString = "--dbpath";
                    useLocalDatabase = true;
                }
                if (useLocalDatabase) {
                    if (relocations != null) {
                        rpmCommand = "rpm --upgrade --nodeps --ignoresize -vh --relocate " + relocations + " " + databaseString + " " + databasePath + " " + packageName;
                        rpmCommandArray = new String[]{"rpm", "--upgrade", "--nodeps", "--ignoresize", "-vh", "--relocate", relocations, databaseString, databasePath, packageName};
                    } else {
                        rpmCommand = "rpm --upgrade --nodeps --ignoresize -vh " + databaseString + " " + databasePath + " " + packageName;
                        rpmCommandArray = new String[]{"rpm", "--upgrade", "--nodeps", "--ignoresize", "-vh", databaseString, databasePath, packageName};
                    }
                } else if (relocations != null) {
                    rpmCommand = "rpm --upgrade --nodeps --ignoresize -vh --relocate " + relocations + " " + packageName;
                    rpmCommandArray = new String[]{"rpm", "--upgrade", "--nodeps", "--ignoresize", "-vh", "--relocate", relocations, packageName};
                } else {
                    rpmCommand = "rpm --upgrade --nodeps --ignoresize -vh " + packageName;
                    rpmCommandArray = new String[]{"rpm", "--upgrade", "--nodeps", "--ignoresize", "-vh", packageName};
                }
                Vector returnVector = new Vector();
                Vector returnErrorVector = new Vector();
                int returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, returnVector, returnErrorVector);
                if (returnValue == 0) {
                    log = rpmCommand + "<br><b>Returns: " + returnValue + " Successful installation</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                } else {
                    log = rpmCommand + "<br><b>Returns: " + returnValue + " Error during installation</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                    for (int i = 0; i < returnErrorVector.size(); ++i) {
                        LogManager.addCommandsLogfileComment((String)returnErrorVector.get(i));
                    }
                    data.setIsErrorInstallation(true);
                }
                packageData.setIsNewInstalled(true);
            } else {
                log = "<b>Error: Did not find package " + packageName + "</b><br>";
                System.err.println(log);
                String message = ResourceManager.getString("String_File_Not_Found") + ": " + packageName;
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                LogManager.addCommandsLogfileComment(log);
                data.setIsErrorInstallation(true);
            }
        }
    }

    public void uninstallPackage(PackageDescription packageData) {
        ProductDescription productData = SetupDataProvider.getProductDescription();
        InstallData data = InstallData.getInstance();
        String log = "";
        String rpmPackageName = packageData.getPackageName();
        if (rpmPackageName.equals("") || rpmPackageName == null) {
            log = "<b>No package name specified. Nothing to do</b>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            String[] rpmCommandArray;
            String rpmCommand;
            log = "<b>Package Name: " + rpmPackageName + "</b>";
            LogManager.addCommandsLogfileComment(log);
            String packageName = packageData.getPkgRealName();
            String databasePath = data.getDatabasePath();
            String databaseString = "";
            boolean useLocalDatabase = false;
            if (databasePath != null && !databasePath.equalsIgnoreCase("null")) {
                databaseString = "--dbpath";
                useLocalDatabase = true;
            }
            if (useLocalDatabase) {
                rpmCommand = "rpm -ev --nodeps " + databaseString + " " + databasePath + " " + packageName;
                rpmCommandArray = new String[]{"rpm", "-ev", "--nodeps", databaseString, databasePath, packageName};
            } else {
                rpmCommand = "rpm -ev --nodeps " + packageName;
                rpmCommandArray = new String[]{"rpm", "-ev", "--nodeps", packageName};
            }
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, returnVector, returnErrorVector);
            if (returnValue == 0) {
                log = rpmCommand + "<br><b>Returns: " + returnValue + " Successful uninstallation</b><br>";
                LogManager.addCommandsLogfileComment(log);
            } else {
                log = rpmCommand + "<br><b>Returns: " + returnValue + " Error during uninstallation</b><br>";
                LogManager.addCommandsLogfileComment(log);
                for (int i = 0; i < returnErrorVector.size(); ++i) {
                    LogManager.addCommandsLogfileComment((String)returnErrorVector.get(i));
                }
                data.setIsErrorInstallation(true);
            }
        }
    }

    public boolean isPackageInstalled(PackageDescription packageData, InstallData installData) {
        String rpmPackageName;
        boolean isInstalled = false;
        boolean doCheck = false;
        if (packageData.pkgExists() || installData.isUninstallationMode()) {
            doCheck = true;
        }
        if ((rpmPackageName = packageData.getPackageName()).equals("")) {
            rpmPackageName = null;
        }
        if (rpmPackageName != null && doCheck) {
            String databaseString = "";
            String databasePath = null;
            String packageName = packageData.getPkgRealName();
            Object allPackages = null;
            boolean useLocalDatabase = false;
            if (installData.isUserInstallation()) {
                databasePath = installData.getDatabasePath();
            }
            if (databasePath != null && !databasePath.equals("null")) {
                databaseString = "--dbpath";
                useLocalDatabase = true;
            }
            if (packageName != null) {
                String[] rpmCommandArray;
                String rpmCommand;
                if (useLocalDatabase) {
                    rpmCommand = "rpm " + databaseString + " " + databasePath + " --query " + packageName;
                    rpmCommandArray = new String[]{"rpm", databaseString, databasePath, "--query", packageName};
                } else {
                    rpmCommand = "rpm --query " + packageName;
                    rpmCommandArray = new String[]{"rpm", "--query", packageName};
                }
                int returnValue = ExecuteProcess.executeProcessReturnValue(rpmCommandArray);
                if (returnValue == 0) {
                    isInstalled = true;
                    packageData.setWasAlreadyInstalled(true);
                    String log = rpmCommand + "<br><b>Returns: " + returnValue + " Package is installed" + "</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                } else {
                    String log = rpmCommand + "<br><b>Returns: " + returnValue + " Package is not installed" + "</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                }
            } else {
                System.err.println("Error: No packageName defined for package: " + rpmPackageName);
            }
        }
        return isInstalled;
    }

    public boolean isInstallSetPackageOlder(PackageDescription packageData, InstallData installData) {
        boolean installSetPackageIsOlder = false;
        boolean checkIfInstalledIsOlder = false;
        installSetPackageIsOlder = this.findOlderPackage(packageData, installData, checkIfInstalledIsOlder);
        return installSetPackageIsOlder;
    }

    public boolean isInstalledPackageOlder(PackageDescription packageData, InstallData installData) {
        boolean installedPackageIsOlder = false;
        boolean checkIfInstalledIsOlder = true;
        installedPackageIsOlder = this.findOlderPackage(packageData, installData, checkIfInstalledIsOlder);
        return installedPackageIsOlder;
    }

    private boolean findOlderPackage(PackageDescription packageData, InstallData installData, boolean checkIfInstalledIsOlder) {
        boolean isOlder = false;
        String rpmPackageName = packageData.getPackageName();
        if (rpmPackageName.equals("")) {
            rpmPackageName = null;
        }
        if (rpmPackageName != null) {
            String databaseString = "";
            String databasePath = null;
            String packageName = packageData.getPkgRealName();
            Object allPackages = null;
            boolean useLocalDatabase = false;
            if (installData.isUserInstallation()) {
                databasePath = installData.getDatabasePath();
            }
            if (databasePath != null && !databasePath.equals("null")) {
                databaseString = "--dbpath";
                useLocalDatabase = true;
            }
            if (packageName != null) {
                String[] rpmCommandArray;
                String rpmCommand;
                if (useLocalDatabase) {
                    rpmCommand = "rpm " + databaseString + " " + databasePath + " -q --queryformat %{VERSION}\\n " + packageName;
                    rpmCommandArray = new String[]{"rpm", databaseString, databasePath, "-q", "--queryformat", "%{VERSION}\\n", packageName};
                } else {
                    rpmCommand = "rpm -q --queryformat %{VERSION}\\n " + packageName;
                    rpmCommandArray = new String[]{"rpm", "-q", "--queryformat", "%{VERSION}\\n", packageName};
                }
                Vector versionVector = new Vector();
                Vector returnErrorVector = new Vector();
                int returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, versionVector, returnErrorVector);
                String version = (String)versionVector.lastElement();
                String log = rpmCommand + "<br><b>Returns: " + version + "</b><br>";
                LogManager.addCommandsLogfileComment(log);
                if (useLocalDatabase) {
                    rpmCommand = "rpm " + databaseString + " " + databasePath + " -q --queryformat %{RELEASE}\\n " + packageName;
                    rpmCommandArray[5] = "%{RELEASE}\\n";
                } else {
                    rpmCommand = "rpm -q --queryformat %{RELEASE}\\n " + packageName;
                    rpmCommandArray[3] = "%{RELEASE}\\n";
                }
                Vector releaseVector = new Vector();
                returnValue = ExecuteProcess.executeProcessReturnVector(rpmCommandArray, releaseVector, returnErrorVector);
                String release = (String)releaseVector.lastElement();
                log = rpmCommand + "<br><b>Returns: " + release + "</b><br>";
                LogManager.addCommandsLogfileComment(log);
                isOlder = this.helper.compareVersionAndRelease(version, release, packageData, checkIfInstalledIsOlder);
                if (checkIfInstalledIsOlder) {
                    if (isOlder) {
                        LogManager.addCommandsLogfileComment("<b>-> Installed package is older</b><br>");
                    } else {
                        LogManager.addCommandsLogfileComment("<b>-> Installed package is not older</b><br>");
                    }
                } else if (isOlder) {
                    LogManager.addCommandsLogfileComment("<b>-> Package in installation set is older</b><br>");
                } else {
                    LogManager.addCommandsLogfileComment("<b>-> Package in installation set is not older</b><br>");
                }
            } else {
                System.err.println("Error: No packageName defined for package: " + rpmPackageName);
            }
        }
        return isOlder;
    }
}

