/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import sun.misc.JavaIOAccess;
import sun.misc.SharedSecrets;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

public final class Console
implements Flushable {
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private Reader reader;
    private Writer out;
    private PrintWriter pw;
    private Formatter formatter;
    private Charset cs;
    private char[] rcb;
    private static boolean echoOff;
    private static Console cons;

    public PrintWriter writer() {
        return this.pw;
    }

    public Reader reader() {
        return this.reader;
    }

    public Console format(String string, Object ... objectArray) {
        this.formatter.format(string, objectArray).flush();
        return this;
    }

    public Console printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String string, Object ... objectArray) {
        String string2 = null;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (string.length() != 0) {
                    this.pw.format(string, objectArray);
                }
                try {
                    char[] cArray = this.readline(false);
                    if (cArray != null) {
                        string2 = new String(cArray);
                    }
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
            }
        }
        return string2;
    }

    public String readLine() {
        return this.readLine("", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] readPassword(String string, Object ... objectArray) {
        char[] cArray = null;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (string.length() != 0) {
                    this.pw.format(string, objectArray);
                }
                try {
                    echoOff = Console.echo(false);
                    cArray = this.readline(true);
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
                finally {
                    try {
                        echoOff = Console.echo(true);
                    }
                    catch (IOException iOException) {}
                }
                this.pw.println();
            }
        }
        return cArray;
    }

    public char[] readPassword() {
        return this.readPassword("", new Object[0]);
    }

    public void flush() {
        this.pw.flush();
    }

    private static native String encoding();

    private static native boolean echo(boolean var0) throws IOException;

    private char[] readline(boolean bl) throws IOException {
        int n = this.reader.read(this.rcb, 0, this.rcb.length);
        if (n < 0) {
            return null;
        }
        if (this.rcb[n - 1] == '\r') {
            --n;
        } else if (this.rcb[n - 1] == '\n' && --n > 0 && this.rcb[n - 1] == '\r') {
            --n;
        }
        char[] cArray = new char[n];
        if (n > 0) {
            System.arraycopy(this.rcb, 0, cArray, 0, n);
            if (bl) {
                Arrays.fill(this.rcb, 0, n, ' ');
            }
        }
        return cArray;
    }

    private char[] grow() {
        assert (Thread.holdsLock(this.readLock));
        char[] cArray = new char[this.rcb.length * 2];
        System.arraycopy(this.rcb, 0, cArray, 0, this.rcb.length);
        this.rcb = cArray;
        return this.rcb;
    }

    private static native boolean istty();

    private Console() {
        String string = Console.encoding();
        if (string != null) {
            try {
                this.cs = Charset.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cs == null) {
            this.cs = Charset.defaultCharset();
        }
        this.out = StreamEncoder.forOutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), this.writeLock, this.cs);
        this.pw = new PrintWriter(this.out, true){

            public void close() {
            }
        };
        this.formatter = new Formatter(this.out);
        this.reader = new LineReader(StreamDecoder.forInputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), this.readLock, this.cs));
        this.rcb = new char[1024];
    }

    static {
        SharedSecrets.setJavaIOAccess(new JavaIOAccess(){

            public Console console() {
                if (Console.istty()) {
                    if (cons == null) {
                        cons = new Console();
                    }
                    return cons;
                }
                return null;
            }

            public Runnable consoleRestoreHook() {
                return new Runnable(){

                    public void run() {
                        try {
                            if (echoOff) {
                                Console.echo(true);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
            }

            public Charset charset() {
                return cons.cs;
            }
        });
    }

    class LineReader
    extends Reader {
        private Reader in;
        private char[] cb;
        private int nChars;
        private int nextChar;
        boolean leftoverLF;

        LineReader(Reader reader) {
            this.in = reader;
            this.cb = new char[1024];
            this.nChars = 0;
            this.nextChar = 0;
            this.leftoverLF = false;
        }

        public void close() {
        }

        public boolean ready() throws IOException {
            return this.in.ready();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            int n4 = n + n2;
            if (n < 0 || n > cArray.length || n2 < 0 || n4 < 0 || n4 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            Object object = Console.this.readLock;
            synchronized (object) {
                boolean bl = false;
                char c = '\u0000';
                do {
                    if (this.nextChar >= this.nChars) {
                        int n5 = 0;
                        while ((n5 = this.in.read(this.cb, 0, this.cb.length)) == 0) {
                        }
                        if (n5 > 0) {
                            this.nChars = n5;
                            this.nextChar = 0;
                            if (n5 < this.cb.length && this.cb[n5 - 1] != '\n' && this.cb[n5 - 1] != '\r') {
                                bl = true;
                            }
                        } else {
                            if (n3 - n == 0) {
                                return -1;
                            }
                            return n3 - n;
                        }
                    }
                    if (this.leftoverLF && cArray == Console.this.rcb && this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.leftoverLF = false;
                    while (this.nextChar < this.nChars) {
                        int n6 = n3++;
                        char c2 = this.cb[this.nextChar];
                        cArray[n6] = c2;
                        c = c2;
                        this.cb[this.nextChar++] = '\u0000';
                        if (c == '\n') {
                            return n3 - n;
                        }
                        if (c == '\r') {
                            if (n3 == n4) {
                                if (cArray == Console.this.rcb) {
                                    cArray = Console.this.grow();
                                    n4 = cArray.length;
                                } else {
                                    this.leftoverLF = true;
                                    return n3 - n;
                                }
                            }
                            if (this.nextChar == this.nChars && this.in.ready()) {
                                this.nChars = this.in.read(this.cb, 0, this.cb.length);
                                this.nextChar = 0;
                            }
                            if (this.nextChar < this.nChars && this.cb[this.nextChar] == '\n') {
                                cArray[n3++] = 10;
                                ++this.nextChar;
                            }
                            return n3 - n;
                        }
                        if (n3 != n4) continue;
                        if (cArray == Console.this.rcb) {
                            cArray = Console.this.grow();
                            n4 = cArray.length;
                            continue;
                        }
                        return n3 - n;
                    }
                } while (!bl);
                return n3 - n;
            }
        }
    }
}

