/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ButtonPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends Component
implements Accessible {
    String label;
    String actionCommand;
    transient ActionListener actionListener;
    private static final String base = "button";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -8774683716313001058L;
    private int buttonSerializedDataVersion = 1;

    private static native void initIDs();

    public Button() throws HeadlessException {
        this("");
    }

    public Button(String string) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.label = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createButton(this);
            }
            super.addNotify();
        }
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        boolean bl = false;
        Button button = this;
        synchronized (button) {
            if (!(string == this.label || this.label != null && this.label.equals(string))) {
                this.label = string;
                ButtonPeer buttonPeer = (ButtonPeer)this.peer;
                if (buttonPeer != null) {
                    buttonPeer.setLabel(string);
                }
                bl = true;
            }
        }
        if (bl && this.valid) {
            this.invalidate();
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        ActionListener actionListener = null;
        if (clazz != ActionListener.class) {
            return super.getListeners(clazz);
        }
        actionListener = this.actionListener;
        return AWTEventMulticaster.getListeners((EventListener)actionListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",label=" + this.label;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTButton();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Button.initIDs();
        }
    }

    protected class AccessibleAWTButton
    extends Component.AccessibleAWTComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -5932203980244017102L;

        protected AccessibleAWTButton() {
            super(Button.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (Button.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return Button.this.getLabel();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("click");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(Button.this, 1001, Button.this.getActionCommand()));
                return true;
            }
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return 0;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return 0;
        }

        public Number getMaximumAccessibleValue() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

