/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi.runtime;

import com.sun.xml.internal.ws.spi.runtime.MessageContext;
import com.sun.xml.internal.ws.spi.runtime.SystemHandlerDelegate;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public abstract class SystemHandlerDelegateFactory {
    private static final String DEFAULT_FACTORY_NAME = "com.sun.xml.internal.xwss.SystemHandlerDelegateFactory";
    private static String factoryName;
    private static HashMap factoryMap;

    private static synchronized void init() {
        factoryName = DEFAULT_FACTORY_NAME;
        factoryMap = new HashMap();
    }

    public SystemHandlerDelegate getDelegate(QName qName) {
        return this.create();
    }

    public abstract SystemHandlerDelegate create();

    public abstract boolean isEnabled(MessageContext var1);

    public static synchronized void setFactoryName(String string) {
        factoryName = string;
    }

    public static synchronized String getFactoryName() {
        return factoryName;
    }

    public static synchronized SystemHandlerDelegateFactory getFactory() {
        SystemHandlerDelegateFactory systemHandlerDelegateFactory = (SystemHandlerDelegateFactory)factoryMap.get(factoryName);
        if (systemHandlerDelegateFactory != null || factoryMap.containsKey(factoryName)) {
            return systemHandlerDelegateFactory;
        }
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = classLoader == null ? Class.forName(factoryName) : classLoader.loadClass(factoryName);
            if (clazz != null) {
                systemHandlerDelegateFactory = (SystemHandlerDelegateFactory)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            systemHandlerDelegateFactory = null;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        finally {
            factoryMap.put(factoryName, systemHandlerDelegateFactory);
        }
        return systemHandlerDelegateFactory;
    }

    static {
        SystemHandlerDelegateFactory.init();
    }
}

