/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appletshape.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2006/12/15 01:50:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_slideshow.hxx"
 
// must be first
#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>
#include <canvas/canvastools.hxx>

#include "appletshape.hxx"
#include "tools.hxx"

#include <boost/bind.hpp>
#include <boost/mem_fn.hpp>
#include <algorithm>


using namespace ::com::sun::star;


namespace slideshow
{
    namespace internal
    {
        AppletShape::AppletShape( const uno::Reference< drawing::XShape >& xShape,
                                  double                                   nPrio,
                                  const ::rtl::OUString&                   rServiceName,
                                  const char**                             pPropCopyTable,
                                  sal_Size                                 nNumPropEntries,
                                  const SlideShowContext&                  rContext ) :
            ExternalShapeBase( xShape, nPrio, rContext ),
            maServiceName( rServiceName ),
            mpPropCopyTable( pPropCopyTable ),
            mnNumPropEntries( nNumPropEntries ),
            maViewAppletShapes()
        {
        }

		// ---------------------------------------------------------------------
		
        void AppletShape::addViewLayer( const ViewLayerSharedPtr& rNewLayer,
                                        bool                      bRedrawLayer )
        {
            ViewAppletShapeVector::iterator aEnd( maViewAppletShapes.end() );

            try
            {
                // already added?
                if( ::std::find_if( maViewAppletShapes.begin(), 
                                    aEnd, 
                                    ::boost::bind<bool>( 
                                        ::std::equal_to< ViewLayerSharedPtr >(),
                                        ::boost::bind( &ViewAppletShape::getViewLayer,
                                                       _1 ),
                                        ::boost::cref( rNewLayer ) ) ) == aEnd )
                {
                    maViewAppletShapes.push_back( 
                        ViewAppletShapeSharedPtr( new ViewAppletShape( rNewLayer, 
                                                                       getXShape(),
                                                                       maServiceName,
                                                                       mpPropCopyTable,
                                                                       mnNumPropEntries,
                                                                       mxComponentContext )));
                
                    // push new size to view shape
                    maViewAppletShapes.back()->resize( AppletShape::getPosSize() );
                
                    // render the Shape on the newly added ViewLayer
                    if( bRedrawLayer )
                        maViewAppletShapes.back()->render( AppletShape::getPosSize() );
                }
            }
            catch (com::sun::star::uno::RuntimeException &) 
            {
                throw;
            }
            catch (com::sun::star::uno::Exception &) 
            {
                // ignore failed shapes - slideshow should run with
                // the remaining content
            }
        }

		// ---------------------------------------------------------------------
		
        bool AppletShape::removeViewLayer( const ViewLayerSharedPtr& rLayer )
        {
            const ViewAppletShapeVector::iterator aEnd( maViewAppletShapes.end() );

            OSL_ENSURE( ::std::count_if(maViewAppletShapes.begin(), 
                                        aEnd, 
                                        ::boost::bind<bool>( 
                                            ::std::equal_to< ViewLayerSharedPtr >(),
                                            ::boost::bind( &ViewAppletShape::getViewLayer, _1 ),
                                            ::boost::cref( rLayer ) ) ) < 2,
                        "AppletShape::removeViewLayer(): Duplicate ViewLayer entries!" );

            ViewAppletShapeVector::iterator aIter;

            if( (aIter=::std::remove_if( maViewAppletShapes.begin(), 
                                         aEnd, 
                                         ::boost::bind<bool>( 
                                             ::std::equal_to< ViewLayerSharedPtr >(),
                                             ::boost::bind( &ViewAppletShape::getViewLayer,
                                                            _1 ),
                                             ::boost::cref( rLayer ) ) )) == aEnd )
            {
                // view layer seemingly was not added, failed
                return false;
            }

            // actually erase from container
            maViewAppletShapes.erase( aIter, aEnd );

            return true;
        }

		// ---------------------------------------------------------------------
		
        bool AppletShape::clearAllViewLayers()
        {
            maViewAppletShapes.clear();
            return true;
        }

		// ---------------------------------------------------------------------

        void AppletShape::viewLayerChanged( const ViewLayerSharedPtr& /*rNewLayer*/ )
        {
            ::std::for_each( maViewAppletShapes.begin(),
                             maViewAppletShapes.end(),
                             ::boost::bind( 
                                 &ViewAppletShape::resize, 
                                 _1,
                                 ::boost::cref( AppletShape::getPosSize())) );
        }

		// ---------------------------------------------------------------------

        bool AppletShape::implRender( const ::basegfx::B2DRange& rCurrBounds ) const
        {
            // redraw all view shapes, by calling their update() method
            if( ::std::count_if( maViewAppletShapes.begin(),
                                 maViewAppletShapes.end(),
                                 ::boost::bind<bool>( 
                                     ::boost::mem_fn( &ViewAppletShape::render ), 
                                     _1,
                                     ::boost::cref( rCurrBounds ) ) ) 
                != static_cast<ViewAppletShapeVector::difference_type>(maViewAppletShapes.size()) )
            {
                // at least one of the ViewShape::update() calls did return 
                // false - update failed on at least one ViewLayer
                return false;
            }

            return true;
        }

		// ---------------------------------------------------------------------
        
        bool AppletShape::implStartIntrinsicAnimation( const SlideShowContext& /*rContext*/,
                                                       const ShapeSharedPtr&   /*rShape*/ )
        {
            ::std::for_each( maViewAppletShapes.begin(),
                             maViewAppletShapes.end(),
                             ::boost::bind( &ViewAppletShape::startApplet,
                                            _1,
                                            ::boost::cref( getPosSize() )));
            
            return true;
        }
        
		// ---------------------------------------------------------------------
        
        bool AppletShape::implEndIntrinsicAnimation()
        {
            ::std::for_each( maViewAppletShapes.begin(),
                             maViewAppletShapes.end(),
                             ::boost::mem_fn( &ViewAppletShape::endApplet ) );

            return true;
        }
    }
}
