/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: untitle.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:21:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

// TOOLS
#define _BIGINT_HXX
#define _SFXMULTISEL_HXX
#define _STACK_HXX
#define _QUEUE_HXX
#define _DYNARR_HXX
#define _TREELIST_HXX
#define _CACHESTR_HXX
#define _NEW_HXX
//#define _SHL_HXX
//#define _LINK_HXX
//#define _ERRCODE_HXX
//#define _GEN_HXX
//#define _FRACT_HXX
//#define _STRING_HXX
//#define _MTF_HXX
//#define _CONTNR_HXX
//#define _LIST_HXX
//#define _TABLE_HXX
#define _DYNARY_HXX
//#define _UNQIDX_HXX
#define _SVMEMPOOL_HXX
//#define _UNQID_HXX
//#define _DEBUG_HXX
//#define _DATE_HXX
//#define _TIME_HXX
//#define _DATETIME_HXX
//#define _INTN_HXX
//#define _WLDCRD_HXX
//#define _FSYS_HXX
//#define _STREAM_HXX
#define _CACHESTR_HXX
#define _SV_MULTISEL_HXX

//SV
//#define _CLIP_HXX
//#define _CONFIG_HXX ***
#define _CURSOR_HXX
#define _FONTDLG_HXX
#define _PRVWIN_HXX
//#define _COLOR_HXX
//#define _PAL_HXX
//#define _BITMAP_HXX
//#define _GDIOBJ_HXX
//#define _POINTR_HXX
//#define _ICON_HXX
//#define _IMAGE_HXX
//#define _KEYCOD_HXX
//#define _EVENT_HXX
#define _HELP_HXX
//#define _APP_HXX
//#define _MDIAPP_HXX
//#define _TIMER_HXX
//#define _METRIC_HXX
//#define _REGION_HXX
//#define _OUTDEV_HXX
//#define _SYSTEM_HXX
//#define _VIRDEV_HXX
//#define _JOBSET_HXX
//#define _PRINT_HXX
//#define _WINDOW_HXX
//#define _SYSWIN_HXX
//#define _WRKWIN_HXX
#define _MDIWIN_HXX
//#define _FLOATWIN_HXX
//#define _DOCKWIN_HXX
//#define _CTRL_HXX
//#define _SCRBAR_HXX
//#define _BUTTON_HXX
//#define _IMAGEBTN_HXX
//#define _FIXED_HXX
//#define _GROUP_HXX
//#define _EDIT_HXX
//#define _COMBOBOX_HXX
//#define _LSTBOX_HXX
//#define _SELENG_HXX
//#define _SPLIT_HXX
#define _SPIN_HXX
//#define _FIELD_HXX
//#define _MOREBTN_HXX
//#define _TOOLBOX_HXX
//#define _STATUS_HXX
//#define _DIALOG_HXX
//#define _MSGBOX_HXX
//#define _SYSDLG_HXX
//#define _FILDLG_HXX ***
//#define _PRNDLG_HXX
#define _COLDLG_HXX
//#define _TABDLG_HXX
//#define _MENU_HXX
//#define _GDIMTF_HXX
//#define _POLY_HXX
//#define _ACCEL_HXX
//#define _GRAPH_HXX
#define _SOUND_HXX

#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif


#include "schdll.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "schview.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "objid.hxx"
#include "untitle.hxx"

TYPEINIT1(SchUndoTitle, SchUndoAttr);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchUndoTitle::SchUndoTitle(ChartModel& rChDoc, UINT16 nId,
						   const SfxItemSet& rOldMainAttr,
						   const SfxItemSet& rOldSubAttr,
						   const SfxItemSet& rOldXAxisAttr,
						   const SfxItemSet& rOldYAxisAttr,
						   const SfxItemSet& rOldZAxisAttr,
						   const SfxItemSet& rOldAttr,
						   const SfxItemSet& rNewAttr) :
	SchUndoAttr(rChDoc, rOldAttr, rNewAttr),
	nTitleId(nId),
	pOldMainTitleAttr(new SfxItemSet(rOldMainAttr)),
	pOldSubTitleAttr(new SfxItemSet(rOldSubAttr)),
	pOldXAxisTitleAttr(new SfxItemSet(rOldXAxisAttr)),
	pOldYAxisTitleAttr(new SfxItemSet(rOldYAxisAttr)),
	pOldZAxisTitleAttr(new SfxItemSet(rOldZAxisAttr))
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchUndoTitle::~SchUndoTitle()
{
	delete pOldMainTitleAttr;
	delete pOldSubTitleAttr;
	delete pOldXAxisTitleAttr;
	delete pOldYAxisTitleAttr;
	delete pOldZAxisTitleAttr;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoTitle::Undo()
{
	if (nTitleId == 0)
		rDoc.ChangeTitleAttr(*pOldMainTitleAttr, *pOldSubTitleAttr,
							 *pOldXAxisTitleAttr, *pOldYAxisTitleAttr,
							 *pOldZAxisTitleAttr, FALSE);
	else
		rDoc.ChangeTitleAttr(*pOldAttr,
							 (SdrTextObj*)rDoc.GetChartObj(nTitleId),
							 FALSE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoTitle::Redo()
{
	rDoc.ChangeTitleAttr(*pNewAttr,
						 (SdrTextObj*)rDoc.GetChartObj(nTitleId));
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoTitle::Repeat(SfxRepeatTarget& rView)
{
	if (((SchView&)rView).AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = ((SchView&)rView).GetMarkedObjectList();

		if (rMarkList.GetMarkCount() == 1)
		{
			SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();
			SchObjectId* pObjId = GetObjectId(*pObj);

			if (pObjId)
			{
				UINT16 nId = pObjId->GetObjId();

				switch (nId)
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					{
						SfxItemSet aOldAttr     ( rDoc.GetTitleAttr((SdrTextObj*)pObj));
						SfxItemSet aOldMainAttr	( rDoc.GetMainTitleAttr());
						SfxItemSet aOldSubAttr	( rDoc.GetSubTitleAttr());
						SfxItemSet aOldXAxisAttr ( rDoc.GetXAxisTitleAttr());
						SfxItemSet aOldYAxisAttr ( rDoc.GetYAxisTitleAttr());
						SfxItemSet aOldZAxisAttr ( rDoc.GetZAxisTitleAttr());

						if (rDoc.ChangeTitleAttr(*pNewAttr,
												 (SdrTextObj*)pObj))
						{
							SchUndoTitle* pUndo =
								new SchUndoTitle(rDoc, nId,
												 aOldMainAttr, aOldSubAttr,
												 aOldXAxisAttr, aOldYAxisAttr,
												 aOldZAxisAttr,
												 aOldAttr, *pNewAttr);
							pUndo->SetComment
								(String(SchResId(STR_UNDO_TITLE)));

							rDoc.GetObjectShell()->
								GetUndoManager()->AddUndoAction(pUndo);
						}
						break;
					}
				}
			}
		}
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoTitle::CanRepeat(SfxRepeatTarget& rView) const
{
	if (((SchView&)rView).AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = ((SchView&)rView).GetMarkedObjectList();

		if (rMarkList.GetMarkCount() == 1)
		{
			SchObjectId* pObjId =
				GetObjectId(*rMarkList.GetMark(0)->GetMarkedSdrObj());

			if (pObjId)
				switch (pObjId->GetObjId())
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						return TRUE;
				}
		}
	}

	return FALSE;
}



