/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:08:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include "schresid.hxx"
#include "viewdlg.hxx"
#include "viewdlg.hrc"



/*************************************************************************
|*
|* Dialog
|*
\************************************************************************/

SchView3DDlg::SchView3DDlg( Window* pWindow , short nXAngle,
							short nYAngle, short nZAngle) :
				ModalDialog 	( pWindow, SchResId( DLG_3D_VIEW ) ),
				aFtXAxis		( this, ResId( FT_X_AXIS ) ),
				aMtrFldXAxis	( this, ResId( MTR_FLD_X_AXIS ) ),
				aFtYAxis		( this, ResId( FT_Y_AXIS ) ),
				aMtrFldYAxis	( this, ResId( MTR_FLD_Y_AXIS ) ),
				aFtZAxis		( this, ResId( FT_Z_AXIS ) ),
				aMtrFldZAxis	( this, ResId( MTR_FLD_Z_AXIS ) ),
				aFlAxis			( this, ResId( FL_AXIS ) ),
				aBtnOK			( this, ResId( BTN_OK ) ),
				aBtnCancel		( this, ResId( BTN_CANCEL ) ),
				aBtnHelp		( this, ResId( BTN_HELP ) )
{
	FreeResource();

	aMtrFldXAxis.SetValue(nXAngle);
	aMtrFldYAxis.SetValue(nYAngle);
	aMtrFldZAxis.SetValue(nZAngle);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchView3DDlg::~SchView3DDlg()
{
}

/*************************************************************************
|*
|* Maxima setzen
|*
\************************************************************************/

void SchView3DDlg::SetMax(short nXMax, short nYMax, short nZMax)
{
	aMtrFldXAxis.SetMax(nXMax);
	aMtrFldXAxis.SetFirst(nXMax);
	aMtrFldYAxis.SetMax(nYMax);
	aMtrFldYAxis.SetFirst(nYMax);
	aMtrFldZAxis.SetMax(nZMax);
	aMtrFldZAxis.SetFirst(nZMax);
}

/*************************************************************************
|*
|* Minima setzen
|*
\************************************************************************/

void SchView3DDlg::SetMin(short nXMin, short nYMin, short nZMin)
{
	if ( nXMin == -1 )
	{
		aFtXAxis.Disable();
		aMtrFldXAxis.Disable();
	}
	else
	{
		aMtrFldXAxis.SetMin(nXMin);
		aMtrFldXAxis.SetLast(nXMin);
	}
	if ( nYMin == -1 )
	{
		aFtYAxis.Disable();
		aMtrFldYAxis.Disable();
	}
	else
	{
		aMtrFldYAxis.SetMin(nYMin);
		aMtrFldYAxis.SetLast(nYMin);
	}
	if ( nZMin == -1 )
	{
		aFtZAxis.Disable();
		aMtrFldZAxis.Disable();
	}
	else
	{
		aMtrFldZAxis.SetMin(nZMin);
		aMtrFldZAxis.SetLast(nZMin);
	}
}

/*************************************************************************
|*
|* Pie-Charts koennen nur an einer Achse gedreht werden
|*
\************************************************************************/

void SchView3DDlg::DisableOnPie ()
{
//    aMtrFldYAxis.Disable();
	aMtrFldZAxis.Disable();
}



