/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: launcher.cxx,v $
 *
 *  $Revision: 1.5.70.1 $
 *
 *  last change: $Author: obo $ $Date: 2007/05/08 11:04:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_desktop.hxx"

#define UNICODE
#include "launcher.hxx"


#ifndef _WINDOWS_
#	define WIN32_LEAN_AND_MEAN
#if defined _MSC_VER
#pragma warning(push, 1)
#endif
#	include <windows.h>
#	include <shellapi.h>
#if defined _MSC_VER
#pragma warning(pop)
#endif
#endif


#include <stdlib.h>
#include <malloc.h>


extern "C" int APIENTRY _tWinMain( HINSTANCE, HINSTANCE, LPTSTR, int )
{
	// Retreive startup info

	STARTUPINFO	aStartupInfo;

	ZeroMemory( &aStartupInfo, sizeof(aStartupInfo) );
	aStartupInfo.cb = sizeof( aStartupInfo );
	GetStartupInfo( &aStartupInfo );

	// Retrieve command line

	LPTSTR	lpCommandLine = GetCommandLine();

	LPTSTR	*ppArguments = NULL;
	int		nArguments = 0;

	ppArguments = GetArgv( &nArguments );

    // if ( 1 == nArguments )
	{
		lpCommandLine = (LPTSTR)_alloca( sizeof(_TCHAR) * (_tcslen(lpCommandLine) + _tcslen(APPLICATION_SWITCH) + 2) );

		_tcscpy( lpCommandLine, GetCommandLine() );
		_tcscat( lpCommandLine, _T(" ") );
		_tcscat( lpCommandLine, APPLICATION_SWITCH );
	}


	// Calculate application name

	TCHAR	szApplicationName[MAX_PATH];
	TCHAR	szDrive[MAX_PATH];
	TCHAR	szDir[MAX_PATH];
	TCHAR	szFileName[MAX_PATH];
	TCHAR	szExt[MAX_PATH];

	GetModuleFileName( NULL, szApplicationName, MAX_PATH );
	_tsplitpath( szApplicationName, szDrive, szDir, szFileName, szExt );
	_tmakepath( szApplicationName, szDrive, szDir, OFFICE_IMAGE_NAME, _T(".exe") );

	PROCESS_INFORMATION	aProcessInfo;

	BOOL	fSuccess = CreateProcess(
		szApplicationName,
		lpCommandLine,
		NULL,
		NULL,
		TRUE,
		0,
		NULL,
		NULL,
		&aStartupInfo,
		&aProcessInfo );

	if ( fSuccess )
	{
		CloseHandle( aProcessInfo.hProcess );
		CloseHandle( aProcessInfo.hThread );

		return 0;
	}

	DWORD	dwError = GetLastError();

	LPVOID lpMsgBuf;

	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		dwError,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR)&lpMsgBuf,
		0,
		NULL
	);

	// Display the string.
	MessageBox( NULL, (LPCTSTR)lpMsgBuf, NULL, MB_OK | MB_ICONERROR );

	// Free the buffer.
	LocalFree( lpMsgBuf );

	return GetLastError();
}

