/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: LayoutHelper.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:41:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef CHART2_LAYOUTHELPER_HXX
#define CHART2_LAYOUTHELPER_HXX

#include "LayoutDefaults.hxx"

namespace chart
{
namespace helper
{

class LayoutHelper
{
public:
    /** See ::com::sun::star::layout::AnchorPoint.

        @param fAngle
            Lies in the range of [0.0, 360.0)

        @return An Alignment that fits the EscapeDirection of an AnchorPoint.
     */
    static ::com::sun::star::layout::Alignment
        getStandardAlignmentByAngle( double fAngle );

    /** rotates the given point by the angle given in degrees

        @param fAngle
            Lies in the range of [0.0, 360.0)
        @param rOutX
            Contains the original x coordinate of the point before call.  After
            the function terminated it contains the rotated x coordinate.
        @param rOutY
            Contains the original y coordinate of the point before call.  After
            the function terminated it contains the rotated y coordinate.
     */
    static void rotatePoint( double fAngle,
                             double & rOutX,
                             double & rOutY );

private:
    // not implemented
    LayoutHelper();
};

} //  namespace helper
} //  namespace chart

// CHART2_LAYOUTHELPER_HXX
#endif
