/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NodeUtils.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:40:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.tree;

import java.util.Vector;
import java.util.Hashtable;
import com.jclark.xsl.om.*;

public final class NodeUtils {
    private static final int NSpaces         = 64;
    private static final char[] Spaces       = new char[NSpaces];
    private static final String NBSP         = "&nbsp;";
    //  private static final Hashtable Modifiers = new Hashtable();

    static {
	for (int i = 0; i < NSpaces; i++)
	    Spaces[i] = ' ';
    }

    public static String xPathOf(NodeIterator nodeSet) {
	try {
	    Node first = nodeSet.next();
	    if (first != null)
		return xPath(first);
	}
	catch (XSLException e) {
	}
	return null;
    }

    public static String numberOf(NodeIterator nodeSet) {
	try {
	    return numberOf(nodeSet.next());
	}
	catch (XSLException e) {
	    return null;
	}
    }

    public static String xPathOfParentOf(NodeIterator nodeSet) {
	try {
	    final Node first = nodeSet.next();
	    if (first != null) {
		System.out.println(first.toString());
		return xPath(first.getParent());
	    }
	}
	catch (XSLException e) {
	}
	return null;
    }

    public static String preformattedSynopsis(NodeIterator nodeSet) {
	try {
	    final Node first = nodeSet.next();
	    if (first != null)
		return preformattedSynopsis(first);
	}
	catch (XSLException e) {
	}
	return null;
    }

    public static String preformattedFieldDetail(NodeIterator nodeSet) {
	try {
	    final Node first = nodeSet.next();
	    if (first != null)
		return preformattedFieldDetail(first);
	}
	catch (XSLException e) {
	}
	return null;
    }

    private static String attributeValue(Node node, String name) {
	SafeNodeIterator attributes = node.getAttributes();
	Node attribute;
	while ((attribute = attributes.next()) != null)
	    if (name.equals(attribute.getName().toString()))
		return attribute.getData();
	return null;
    }

    private static String nameAttribute(Node node) {
	return attributeValue(node, "name");
    }
  
    private static String modifiers(Node node) {
	//    return modifiers(attributeValue(node, "mod"));
	// not an acronym since 3/9/2000
	return attributeValue(node, "mod");
    }

    private static String preformattedSynopsis(Node node) {
	StringBuffer buffer = new StringBuffer(512);
	boolean method = false;
	final String nodeName = node.getName().toString();
	// the name attribute of this el will be the name of executable member
	// it will be the enclosing 'class' element for constructors
	Node namedElement = node, child, returns = null;
	if ("method".equals(nodeName))
	    method = true;
	else if ("constructor".equals(nodeName)) {
	    // find name of the class
	    Node parent = node;
	    do {
		parent = parent.getParent();
	    }
	    while (!"class".equals(parent.getName().toString()));
	    namedElement = parent;
	}
	else
	    return "executable member formatting error";

	final String memberName = nameAttribute(namedElement);
	SafeNodeIterator children = node.getChildren();
	Vector parameters = null, throwsDecls = null;
	// collect parameters, throws and set 'returns'
	while ((child = children.next()) != null)
	    if (child.getType() == Node.ELEMENT) {
		final String name = child.getName().toString();
		if ("parameter".equals(name)) {
		    if (parameters == null)
			parameters = new Vector();
		    parameters.addElement(child);
		}
		else if ("returns".equals(name))
		    returns = child;
		else if ("throws".equals(name)) {
		    if (throwsDecls == null)
			throwsDecls = new Vector();
		    throwsDecls.addElement(child);
		}
	    }

	buffer.append(modifiers(node));
	buffer.append(' ');
	// 2 for space and LPAR
	int indent = buffer.length() + memberName.length() + 2;
	if (method)			// add 'stype' length
	    indent += outputTypeInformation(returns, buffer, false).length();
	buffer.append(" <B>");
	buffer.append(memberName);
	buffer.append("</B>(");
	final int nParams = parameters != null ? parameters.size() : 0;
	for (int i = 0; i < nParams; i++) {
	    parameter((Node)parameters.elementAt(i), buffer);
	    if (i < nParams - 1) {
		buffer.append(",\n");
		buffer.append(Spaces, 0, indent);
	    }
	}
	buffer.append(")\n");
	final int nThrows = throwsDecls != null ? throwsDecls.size() : 0;
	if (nThrows > 0) {
	    buffer.append(Spaces, 0, indent - 7); // "throws "
	    buffer.append("throws ");
	    for (int i = 0; i < nThrows; i++) {
		outputClassInformation((Node)throwsDecls.elementAt(i), buffer);
		if (i < nThrows - 1) {
		    buffer.append(",\n");
		    buffer.append(Spaces, 0, indent);
		}
	    }
	}
	return buffer.toString();
    }

    private static String preformattedFieldDetail(Node node) {
	// !!! will be more efficient to scan attrs just once
	StringBuffer buffer = new StringBuffer(256);
	buffer.append(modifiers(node));
	buffer.append(' ');
	outputTypeInformation(node, buffer, false);
	buffer.append(" <B>");
	buffer.append(nameAttribute(node));
	buffer.append("</B>");
	return buffer.toString();
    }

    private static void parameter(Node parameter, StringBuffer buffer) {
	String name = outputTypeInformation(parameter, buffer, true);
	buffer.append(NBSP);
	buffer.append(name);
    }
  
    private static String outputTypeInformation(Node typeInfoEl, StringBuffer buffer,
						boolean returnName) {
	SafeNodeIterator attributes = typeInfoEl.getAttributes();
	Node attribute;
	String stype = null, qtype = null, dim = null, name = null;
	while ((attribute = attributes.next()) != null) {
	    String attName = attribute.getName().toString();      
	    if (attName.equals("qtype"))
		qtype = attribute.getData();
	    else if (attName.equals("stype"))
		stype = attribute.getData();
	    else if (attName.equals("dimension"))
		dim = attribute.getData();
	    else if (attName.equals("name"))
		name = attribute.getData();
	}
	if (qtype != null) {
	    buffer.append("<a href=\"JAVADOC,/servlet/document?doc=");
	    buffer.append(qtype);
	    buffer.append("\" target=\"_top\">");
	    buffer.append(stype);
	    buffer.append("</a>");
	}
	else
	    buffer.append(stype);
	if (dim != null)
	    buffer.append(dim);
	return returnName ? name : stype;
    }

    private static void outputClassInformation(Node classInfoEl,
					       StringBuffer buffer) {
	SafeNodeIterator attributes = classInfoEl.getAttributes();
	Node attribute;
	String name = null, inPackage = null;
	while ((attribute = attributes.next()) != null) {
	    String attName = attribute.getName().toString();      
	    if (attName.equals("name"))
		name = attribute.getData();
	    else if (attName.equals("inPackage"))
		inPackage = attribute.getData();
	}
	buffer.append("<a href=\"JAVADOC,/servlet/document?doc=");
	buffer.append(inPackage);
	buffer.append('.');
	buffer.append(name);
	buffer.append("\" target=\"_top\">");
	buffer.append(name);
	buffer.append("</a>");
    }

    /*
      private static String modifiers(String acronym) {
      if (acronym.equals("p"))	// common case
      return "public ";
      else {
      Object cached = Modifiers.get(acronym);
      if (cached != null)
      return (String)cached;
      else {
      StringBuffer buffer = new StringBuffer();
      for (int i = 0; i < acronym.length(); i++) {
      switch (acronym.charAt(i)) {
      case 'p':
      buffer.append("public");
      break;
      case 'r':
      buffer.append("protected");
      break;
      case 'i':
      buffer.append("private");
      break;
      case 'a':
      buffer.append("abstract");
      break;
      case 's':
      buffer.append("static");
      break;
      case 'f':
      buffer.append("final");
      break;
      case 'c':
      buffer.append("synchronized");
      break;
      case 'n':
      buffer.append("native");
      break;
      case 't':
      buffer.append("transient");
      break;
      case 'v':
      buffer.append("volatile");
      break;
      }
      buffer.append(' ');
      }
      String result = buffer.toString();
      Modifiers.put(acronym, result);
      return result;
      }
      }
      }
    */

    private static String numberOf(Node node) {
	return "1";
    }

    private static String xPath(Node node) {
	StringBuffer buffer = new StringBuffer();
	xPathAux(node.getParent(), node, buffer);
	return buffer.toString();
    }
    
    private static void xPathAux(Node parent, Node node, StringBuffer buffer) {
	if (parent != null) {
	    // recursive call
	    xPathAux(parent.getParent(), parent, buffer);
	    // real work
	    SafeNodeIterator siblings = parent.getChildren();
	    Node sibling; int seqNumber = 1;
	    buffer.append('/');
	    switch (node.getType()) {
	    case Node.ELEMENT:
		Name name = node.getName();
		buffer.append(name.toString());
		while ((sibling = siblings.next()) != null && sibling != node)
		    if (sibling.getName() == name)
			++seqNumber;
		break;

	    case Node.TEXT:
		buffer.append("text()");
		while ((sibling = siblings.next()) != null && sibling != node)
		    if (sibling.getType() == Node.TEXT)
			++seqNumber;
		break;
	    }
	    buffer.append('[');
	    buffer.append(seqNumber);
	    buffer.append(']');
	}
    }
}
