/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.IntervalMarker;
import com.jrefinery.chart.Marker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HorizontalMarkerAxisBand {
    private HorizontalNumberAxis axis;
    private double topOuterGap;
    private double topInnerGap;
    private double bottomOuterGap;
    private double bottomInnerGap;
    private Font font;
    private List markers;

    public HorizontalMarkerAxisBand(HorizontalNumberAxis horizontalNumberAxis, double d, double d2, double d3, double d4, Font font) {
        this.axis = horizontalNumberAxis;
        this.topOuterGap = d;
        this.topInnerGap = d2;
        this.bottomOuterGap = d3;
        this.bottomInnerGap = d4;
        this.font = font;
        this.markers = new ArrayList();
    }

    public void addMarker(Marker marker) {
        this.markers.add(marker);
    }

    public double getHeight(Graphics2D graphics2D) {
        double d = 0.0;
        if (this.markers.size() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics("123g", graphics2D.getFontRenderContext());
            d = this.topOuterGap + this.topInnerGap + (double)lineMetrics.getHeight() + this.bottomInnerGap + this.bottomOuterGap;
        }
        return d;
    }

    private void drawStringInRect(Graphics2D graphics2D, Rectangle2D rectangle2D, Font font, String string) {
        graphics2D.setFont(font);
        Rectangle2D rectangle2D2 = font.getStringBounds(string, graphics2D.getFontRenderContext());
        double d = rectangle2D.getX();
        if (rectangle2D2.getWidth() < rectangle2D.getWidth()) {
            d += (rectangle2D.getWidth() - rectangle2D2.getWidth()) / 2.0;
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, graphics2D.getFontRenderContext());
        graphics2D.drawString(string, (float)d, (float)(rectangle2D.getMaxY() - this.bottomInnerGap - (double)lineMetrics.getDescent()));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2) {
        double d3 = this.getHeight(graphics2D);
        Iterator iterator = this.markers.iterator();
        while (iterator.hasNext()) {
            IntervalMarker intervalMarker = (IntervalMarker)iterator.next();
            double d4 = Math.max(intervalMarker.getStartValue(), this.axis.getRange().getLowerBound());
            double d5 = Math.min(intervalMarker.getEndValue(), this.axis.getRange().getUpperBound());
            double d6 = this.axis.translateValueToJava2D(d4, rectangle2D2);
            double d7 = this.axis.translateValueToJava2D(d5, rectangle2D2);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6, d2 + this.topOuterGap, d7 - d6, d3 - this.topOuterGap - this.bottomOuterGap);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, intervalMarker.getAlpha()));
            graphics2D.setPaint(intervalMarker.getPaint());
            graphics2D.fill(double_);
            graphics2D.setPaint(intervalMarker.getOutlinePaint());
            graphics2D.draw(double_);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(Color.black);
            this.drawStringInRect(graphics2D, double_, this.font, intervalMarker.getLabel());
        }
    }
}

