/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

class GTKGraphicsUtils
extends SynthGraphicsUtils {
    GTKGraphicsUtils() {
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n, int n2, int n3) {
        if (synthContext.getRegion() == Region.INTERNAL_FRAME_TITLE_PANE) {
            return;
        }
        int n4 = synthContext.getComponentState();
        if ((n4 & 8) == 8) {
            Color color = graphics.getColor();
            graphics.setColor(synthContext.getStyle().getColor(synthContext, GTKColorType.WHITE));
            super.paintText(synthContext, graphics, string, ++n, ++n2, n3);
            graphics.setColor(color);
            super.paintText(synthContext, graphics, string, --n, --n2, n3);
        } else {
            String string2 = GTKLookAndFeel.getGtkThemeName();
            if (string2 != null && string2.startsWith("blueprint") && GTKGraphicsUtils.shouldShadowText(synthContext.getRegion(), n4)) {
                graphics.setColor(Color.BLACK);
                super.paintText(synthContext, graphics, string, n + 1, n2 + 1, n3);
                graphics.setColor(Color.WHITE);
            }
            super.paintText(synthContext, graphics, string, n, n2, n3);
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Rectangle rectangle, int n) {
        JComponent jComponent;
        Region region = synthContext.getRegion();
        if (!(region != Region.RADIO_BUTTON && region != Region.CHECK_BOX && region != Region.TABBED_PANE_TAB || (synthContext.getComponentState() & 0x100) == 0 || (jComponent = synthContext.getComponent()) instanceof AbstractButton && !((AbstractButton)jComponent).isFocusPainted())) {
            Color color = graphics.getColor();
            GTKPainter.INSTANCE.paintFocus(synthContext, graphics, region, synthContext.getComponentState(), "checkbutton", rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
            graphics.setColor(color);
        }
        super.paintText(synthContext, graphics, string, rectangle, n);
    }

    private static boolean shouldShadowText(Region region, int n) {
        int n2 = GTKLookAndFeel.synthStateToGTKState(region, n);
        return n2 == 2 && (region == Region.MENU || region == Region.MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM);
    }
}

