/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.EngineOutputRecord;
import com.sun.net.ssl.internal.ssl.HandshakeHash;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RSAClientKeyExchange;
import com.sun.net.ssl.internal.ssl.RandomCookie;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;

abstract class Handshaker {
    ProtocolVersion protocolVersion;
    ProtocolList enabledProtocols;
    private boolean isClient;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    HandshakeHash handshakeHash;
    HandshakeInStream input;
    HandshakeOutStream output;
    int state;
    SSLContextImpl sslContext;
    RandomCookie clnt_random;
    RandomCookie svr_random;
    SSLSessionImpl session;
    private MessageDigest md5Tmp;
    private MessageDigest shaTmp;
    CipherSuiteList enabledCipherSuites;
    CipherSuite cipherSuite;
    CipherSuite.KeyExchange keyExchange;
    boolean resumingSession;
    boolean enableNewSession;
    private SecretKey clntWriteKey;
    private SecretKey svrWriteKey;
    private IvParameterSpec clntWriteIV;
    private IvParameterSpec svrWriteIV;
    private SecretKey clntMacSecret;
    private SecretKey svrMacSecret;
    private boolean taskDelegated = false;
    private DelegatedTask delegatedTask = null;
    private Exception thrown = null;
    static final Debug debug = Debug.getInstance("ssl");

    Handshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.conn = sSLSocketImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2);
    }

    Handshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.engine = sSLEngineImpl;
        this.init(sSLContextImpl, protocolList, bl, bl2);
    }

    private void init(SSLContextImpl sSLContextImpl, ProtocolList protocolList, boolean bl, boolean bl2) {
        this.sslContext = sSLContextImpl;
        this.isClient = bl2;
        this.enableNewSession = true;
        this.setCipherSuite(CipherSuite.C_NULL);
        this.md5Tmp = JsseJce.getMD5();
        this.shaTmp = JsseJce.getSHA();
        this.handshakeHash = new HandshakeHash(bl);
        this.setEnabledProtocols(protocolList);
        if (this.conn != null) {
            this.conn.getAppInputStream().r.setHandshakeHash(this.handshakeHash);
        } else {
            this.engine.inputRecord.setHandshakeHash(this.handshakeHash);
        }
        this.state = -1;
    }

    void fatalSE(byte by, String string) throws IOException {
        this.fatalSE(by, string, null);
    }

    void fatalSE(byte by, Throwable throwable) throws IOException {
        this.fatalSE(by, null, throwable);
    }

    void fatalSE(byte by, String string, Throwable throwable) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(by, string, throwable);
        } else {
            this.engine.fatal(by, string, throwable);
        }
    }

    void warningSE(byte by) {
        if (this.conn != null) {
            this.conn.warning(by);
        } else {
            this.engine.warning(by);
        }
    }

    String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    boolean isLoopbackSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().isLoopbackAddress();
        }
        return false;
    }

    int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    String getHostnameVerificationSE() {
        if (this.conn != null) {
            return this.conn.getHostnameVerification();
        }
        return this.engine.getHostnameVerification();
    }

    AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    private void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.output.r.setVersion(protocolVersion);
    }

    void setEnabledProtocols(ProtocolList protocolList) {
        this.enabledProtocols = protocolList;
        this.protocolVersion = protocolList.max;
        ProtocolVersion protocolVersion = protocolList.helloVersion;
        this.input = new HandshakeInStream(this.handshakeHash);
        if (this.conn != null) {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.conn);
            this.conn.getAppInputStream().r.setHelloVersion(protocolVersion);
        } else {
            this.output = new HandshakeOutStream(this.protocolVersion, protocolVersion, this.handshakeHash, this.engine);
            this.engine.outputRecord.setHelloVersion(protocolVersion);
        }
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        this.keyExchange = cipherSuite.keyExchange;
    }

    boolean isEnabled(CipherSuite cipherSuite) {
        return this.enabledCipherSuites.contains(cipherSuite) && cipherSuite.isAvailable();
    }

    void setEnableSessionCreation(boolean bl) {
        this.enableNewSession = bl;
    }

    CipherBox newReadCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, false);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, false);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        }
        return cipherBox;
    }

    CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        CipherBox cipherBox;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        if (this.isClient) {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, true);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        } else {
            cipherBox = bulkCipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, true);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        }
        return cipherBox;
    }

    MAC newReadMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mAC;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mAC = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        } else {
            mAC = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        }
        return mAC;
    }

    MAC newWriteMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mAC;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mAC = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        } else {
            mAC = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        }
        return mAC;
    }

    boolean isDone() {
        return this.state == 20;
    }

    SSLSessionImpl getSession() {
        return this.session;
    }

    void process_record(InputRecord inputRecord, boolean bl) throws IOException {
        this.checkThrown();
        this.input.incomingRecord(inputRecord);
        if (this.conn != null || bl) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    void processLoop() throws IOException {
        while (this.input.available() > 0) {
            this.input.mark(4);
            byte by = (byte)this.input.getInt8();
            int n = this.input.getInt24();
            if (this.input.available() < n) {
                this.input.reset();
                return;
            }
            if (by == 0) {
                this.input.reset();
                this.processMessage(by, n);
                this.input.ignore(4 + n);
                continue;
            }
            this.input.mark(n);
            this.processMessage(by, n);
            this.input.digestNow();
        }
    }

    boolean started() {
        return this.state >= 0;
    }

    void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage handshakeMessage = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            handshakeMessage.print(System.out);
        }
        handshakeMessage.write(this.output);
        this.output.flush();
        this.state = handshakeMessage.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChangeCipherSpec(HandshakeMessage.Finished finished, boolean bl) throws IOException {
        this.output.flush();
        OutputRecord outputRecord = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        outputRecord.setVersion(this.protocolVersion);
        outputRecord.write(1);
        if (this.conn != null) {
            Object object = this.conn.writeLock;
            synchronized (object) {
                this.conn.writeRecord(outputRecord);
                this.conn.changeWriteCiphers();
                if (debug != null && Debug.isOn("handshake")) {
                    finished.print(System.out);
                }
                finished.write(this.output);
                this.output.flush();
            }
        }
        Object object = this.engine.wrapLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)outputRecord);
            this.engine.changeWriteCiphers();
            if (debug != null && Debug.isOn("handshake")) {
                finished.print(System.out);
            }
            finished.write(this.output);
            if (bl) {
                this.output.setFinishedMsg();
            }
            this.output.flush();
        }
    }

    void calculateKeys(SecretKey secretKey, ProtocolVersion protocolVersion) {
        SecretKey secretKey2 = this.calculateMasterSecret(secretKey, protocolVersion);
        this.session.setMasterSecret(secretKey2);
        this.calculateConnectionKeys(secretKey2);
    }

    private SecretKey calculateMasterSecret(SecretKey secretKey, ProtocolVersion protocolVersion) {
        boolean bl;
        Object object;
        Object object2;
        TlsMasterSecretParameterSpec tlsMasterSecretParameterSpec = new TlsMasterSecretParameterSpec(secretKey, (int)this.protocolVersion.major, (int)this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes);
        if (debug != null && Debug.isOn("keygen")) {
            object2 = new HexDumpEncoder();
            System.out.println("SESSION KEYGEN:");
            System.out.println("PreMaster Secret:");
            Handshaker.printHex(object2, secretKey.getEncoded());
        }
        try {
            object = JsseJce.getKeyGenerator("SunTlsMasterSecret");
            ((KeyGenerator)object).init(tlsMasterSecretParameterSpec);
            object2 = ((KeyGenerator)object).generateKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (!secretKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
                throw new ProviderException(generalSecurityException);
            }
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA master secret generation error:");
                generalSecurityException.printStackTrace(System.out);
                System.out.println("Generating new random premaster secret");
            }
            secretKey = RSAClientKeyExchange.generateDummySecret(this.protocolVersion);
            return this.calculateMasterSecret(secretKey, null);
        }
        if (protocolVersion == null || !(object2 instanceof TlsMasterSecret)) {
            return object2;
        }
        object = (TlsMasterSecret)object2;
        int n = object.getMajorVersion();
        int n2 = object.getMinorVersion();
        if (n < 0 || n2 < 0) {
            return object2;
        }
        ProtocolVersion protocolVersion2 = ProtocolVersion.valueOf(n, n2);
        boolean bl2 = bl = protocolVersion2 != this.protocolVersion && protocolVersion2.v != protocolVersion.v;
        if (!bl) {
            return object2;
        }
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("RSA PreMasterSecret version error: expected" + this.protocolVersion + " or " + protocolVersion + ", decrypted: " + protocolVersion2);
            System.out.println("Generating new random premaster secret");
        }
        secretKey = RSAClientKeyExchange.generateDummySecret(this.protocolVersion);
        return this.calculateMasterSecret(secretKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateConnectionKeys(SecretKey secretKey) {
        TlsKeyMaterialSpec tlsKeyMaterialSpec;
        Object object;
        int n = this.cipherSuite.macAlg.size;
        boolean bl = this.cipherSuite.exportable;
        CipherSuite.BulkCipher bulkCipher = this.cipherSuite.cipher;
        int n2 = bulkCipher.keySize;
        int n3 = bulkCipher.ivSize;
        int n4 = bl ? bulkCipher.expandedKeySize : 0;
        TlsKeyMaterialParameterSpec tlsKeyMaterialParameterSpec = new TlsKeyMaterialParameterSpec(secretKey, (int)this.protocolVersion.major, (int)this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, bulkCipher.algorithm, bulkCipher.keySize, n4, bulkCipher.ivSize, n);
        try {
            object = JsseJce.getKeyGenerator("SunTlsKeyMaterial");
            ((KeyGenerator)object).init(tlsKeyMaterialParameterSpec);
            tlsKeyMaterialSpec = (TlsKeyMaterialSpec)((KeyGenerator)object).generateKey();
            this.clntWriteKey = tlsKeyMaterialSpec.getClientCipherKey();
            this.svrWriteKey = tlsKeyMaterialSpec.getServerCipherKey();
            this.clntWriteIV = tlsKeyMaterialSpec.getClientIv();
            this.svrWriteIV = tlsKeyMaterialSpec.getServerIv();
            this.clntMacSecret = tlsKeyMaterialSpec.getClientMacKey();
            this.svrMacSecret = tlsKeyMaterialSpec.getServerMacKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
        if (debug != null && Debug.isOn("keygen")) {
            object = System.out;
            synchronized (object) {
                tlsKeyMaterialSpec = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clnt_random.random_bytes);
                System.out.println("Server Nonce:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svr_random.random_bytes);
                System.out.println("Master Secret:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, secretKey.getEncoded());
                System.out.println("Client MAC write Secret:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntMacSecret.getEncoded());
                System.out.println("Server MAC write Secret:");
                Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrMacSecret.getEncoded());
                if (this.clntWriteKey != null) {
                    System.out.println("Client write key:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntWriteKey.getEncoded());
                    System.out.println("Server write key:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrWriteKey.getEncoded());
                } else {
                    System.out.println("... no encryption keys used");
                }
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.clntWriteIV.getIV());
                    System.out.println("Server write IV:");
                    Handshaker.printHex((HexDumpEncoder)tlsKeyMaterialSpec, this.svrWriteIV.getIV());
                } else {
                    System.out.println("... no IV used for this cipher");
                }
                System.out.flush();
            }
        }
    }

    private static void printHex(HexDumpEncoder hexDumpEncoder, byte[] byArray) {
        if (byArray == null) {
            System.out.println("(key bytes not available)");
        } else {
            try {
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void throwSSLException(String string, Throwable throwable) throws SSLException {
        SSLException sSLException = new SSLException(string);
        sSLException.initCause(throwable);
        throw sSLException;
    }

    private void delegateTask(PrivilegedExceptionAction privilegedExceptionAction) {
        this.delegatedTask = new DelegatedTask(privilegedExceptionAction);
        this.taskDelegated = false;
        this.thrown = null;
    }

    DelegatedTask getTask() {
        if (!this.taskDelegated) {
            this.taskDelegated = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    void checkThrown() throws SSLException {
        if (this.thrown != null) {
            String string = this.thrown.getMessage();
            if (string == null) {
                string = "Delegated task threw Exception/Error";
            }
            Exception exception = this.thrown;
            this.thrown = null;
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)new RuntimeException(string).initCause(exception);
            }
            if (exception instanceof SSLHandshakeException) {
                throw (SSLHandshakeException)new SSLHandshakeException(string).initCause(exception);
            }
            if (exception instanceof SSLKeyException) {
                throw (SSLKeyException)new SSLKeyException(string).initCause(exception);
            }
            if (exception instanceof SSLPeerUnverifiedException) {
                throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(string).initCause(exception);
            }
            if (exception instanceof SSLProtocolException) {
                throw (SSLProtocolException)new SSLProtocolException(string).initCause(exception);
            }
            throw (SSLException)new SSLException(string).initCause(exception);
        }
    }

    class DelegatedTask
    implements Runnable {
        private PrivilegedExceptionAction pea;

        DelegatedTask(PrivilegedExceptionAction privilegedExceptionAction) {
            this.pea = privilegedExceptionAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Handshaker.this.thrown = privilegedActionException.getException();
                }
                catch (RuntimeException runtimeException) {
                    Handshaker.this.thrown = runtimeException;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.taskDelegated = false;
            }
        }
    }
}

