/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMStateSet;
import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.XSConstraints;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSWildcardDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.xni.QName;
import java.util.Hashtable;
import java.util.Vector;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private int fOneTransitionCounter = 0;
    private Object fUserData;
    private static long time = 0L;

    public XSDFACM(CMNode cMNode, int n) {
        this.fLeafCount = n;
        this.fUserData = cMNode.getUserData();
        this.buildDFA(cMNode);
    }

    public int getOneTransitionCounter() {
        return this.fOneTransitionCounter;
    }

    public Object getUserData() {
        return this.fUserData;
    }

    public boolean isFinalState(int n) {
        return n < 0 ? false : this.fFinalStateFlags[n];
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        int n;
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            if (n2 == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n3 = 0;
        Object object = null;
        for (n = 0; n < this.fElemMapSize; ++n) {
            n3 = this.fTransTable[n2][n];
            if (n3 == -1) continue;
            int n4 = this.fElemMapType[n];
            if (n4 == 1) {
                object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n]);
                if (object == null) continue;
                break;
            }
            if (n4 != 2 || !((XSWildcardDecl)this.fElemMap[n]).allowNamespace(qName.uri)) continue;
            object = this.fElemMap[n];
            break;
        }
        if (n == this.fElemMapSize) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        ++this.fOneTransitionCounter;
        nArray[0] = n3;
        return object;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i = 0; i < this.fElemMapSize; ++i) {
            int n = this.fElemMapType[i];
            if (n == 1) {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[i]);
                if (xSElementDecl == null) continue;
                return xSElementDecl;
            }
            if (n != 2 || !((XSWildcardDecl)this.fElemMap[i]).allowNamespace(qName.uri)) continue;
            return this.fElemMap[i];
        }
        return null;
    }

    public int[] startContentModel() {
        int[] nArray = new int[2];
        nArray[0] = 0;
        this.fOneTransitionCounter = 0;
        return nArray;
    }

    public boolean endContentModel(int[] nArray) {
        return this.fFinalStateFlags[nArray[0]];
    }

    private void buildDFA(CMNode cMNode) {
        int n;
        int n2;
        int n3;
        int n4 = this.fLeafCount;
        XSCMLeaf xSCMLeaf = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, cMNode, xSCMLeaf);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (n3 = 0; n3 < this.fLeafCount; ++n3) {
            this.fFollowList[n3] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        for (n3 = 0; n3 < this.fLeafCount; ++n3) {
            this.fElemMap[n3] = null;
            n2 = this.fLeafList[n3].getParticleId();
            for (n = 0; n < this.fElemMapSize && n2 != this.fElemMapId[n]; ++n) {
            }
            if (n != this.fElemMapSize) continue;
            this.fElemMap[this.fElemMapSize] = this.fLeafList[n3].getLeaf();
            this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n3];
            this.fElemMapId[this.fElemMapSize] = n2;
            ++this.fElemMapSize;
        }
        --this.fElemMapSize;
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        n = 0;
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            int n5 = this.fElemMapId[n2];
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (n5 != this.fLeafList[i].getParticleId()) continue;
                nArray[n++] = i;
            }
            nArray[n++] = -1;
        }
        n2 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n2];
        this.fFinalStateFlags = new boolean[n2];
        this.fTransTable = new int[n2][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n6 = 0;
        int n7 = 0;
        this.fTransTable[n7] = this.makeDefStateList();
        cMStateSetArray[n7] = cMStateSet;
        ++n7;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n6 < n7) {
            cMStateSet = cMStateSetArray[n6];
            int[] nArray2 = this.fTransTable[n6];
            this.fFinalStateFlags[n6] = cMStateSet.getBit(n4);
            ++n6;
            CMStateSet cMStateSet2 = null;
            int n8 = 0;
            for (int i = 0; i < this.fElemMapSize; ++i) {
                int n9;
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n10 = nArray[n8++];
                while (n10 != -1) {
                    if (cMStateSet.getBit(n10)) {
                        cMStateSet2.union(this.fFollowList[n10]);
                    }
                    n10 = nArray[n8++];
                }
                if (cMStateSet2.isEmpty()) continue;
                Integer n11 = (Integer)hashtable.get(cMStateSet2);
                int n12 = n9 = n11 == null ? n7 : n11;
                if (n9 == n7) {
                    cMStateSetArray[n7] = cMStateSet2;
                    this.fTransTable[n7] = this.makeDefStateList();
                    hashtable.put(cMStateSet2, new Integer(n7));
                    ++n7;
                    cMStateSet2 = null;
                }
                nArray2[i] = n9;
                if (n7 != n2) continue;
                int n13 = (int)((double)n2 * 1.5);
                CMStateSet[] cMStateSetArray2 = new CMStateSet[n13];
                boolean[] blArray = new boolean[n13];
                int[][] nArrayArray = new int[n13][];
                for (int j = 0; j < n2; ++j) {
                    cMStateSetArray2[j] = cMStateSetArray[j];
                    blArray[j] = this.fFinalStateFlags[j];
                    nArrayArray[j] = this.fTransTable[j];
                }
                n2 = n13;
                cMStateSetArray = cMStateSetArray2;
                this.fFinalStateFlags = blArray;
                this.fTransTable = nArrayArray;
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 101) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 102) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (!cMStateSet.getBit(i)) continue;
                this.fFollowList[i].union(cMStateSet2);
            }
        } else if (cMNode.type() == 4 || cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (!cMStateSet3.getBit(i)) continue;
                this.fFollowList[i].union(cMStateSet);
            }
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("   ");
        }
        n2 = cMNode.type();
        switch (n2) {
            case 101: 
            case 102: {
                if (n2 == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        for (int i = 0; i < this.fElemMapSize; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void postTreeBuildInit(CMNode cMNode) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        XSCMLeaf xSCMLeaf = null;
        int n = 0;
        if (cMNode.type() == 2) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n = xSCMLeaf.getPosition();
            this.fLeafList[n] = xSCMLeaf;
            this.fLeafListType[n] = 2;
        } else if (cMNode.type() == 101 || cMNode.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4 || cMNode.type() == 6 || cMNode.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild());
        } else if (cMNode.type() == 1) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n = xSCMLeaf.getPosition();
            this.fLeafList[n] = xSCMLeaf;
            this.fLeafListType[n] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n;
        int n2;
        byte[][] byArray = new byte[this.fElemMapSize][this.fElemMapSize];
        for (n2 = 0; n2 < this.fTransTable.length && this.fTransTable[n2] != null; ++n2) {
            for (n = 0; n < this.fElemMapSize; ++n) {
                for (int i = n + 1; i < this.fElemMapSize; ++i) {
                    if (this.fTransTable[n2][n] == -1 || this.fTransTable[n2][i] == -1 || byArray[n][i] != 0) continue;
                    byArray[n][i] = XSConstraints.overlapUPA(this.fElemMap[n], this.fElemMap[i], substitutionGroupHandler) ? 1 : -1;
                }
            }
        }
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            for (n = 0; n < this.fElemMapSize; ++n) {
                if (byArray[n2][n] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[n2].toString(), this.fElemMap[n].toString()});
            }
        }
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            if (this.fElemMapType[n2] != 2) continue;
            XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)this.fElemMap[n2];
            if (xSWildcardDecl.fType != 3 && xSWildcardDecl.fType != 2) continue;
            return true;
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        int n = nArray[0];
        if (n < 0) {
            n = nArray[1];
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.fElemMapSize; ++i) {
            if (this.fTransTable[n][i] == -1) continue;
            vector.addElement(this.fElemMap[i]);
        }
        return vector;
    }
}

