/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: externalshapebase.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2006/12/15 02:03:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_slideshow.hxx"

// must be first
#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>

#include "externalshapebase.hxx"
#include "tools.hxx"

using namespace ::com::sun::star;


namespace slideshow
{
    namespace internal
    {
        ExternalShapeBase::ExternalShapeBase( const uno::Reference< drawing::XShape >& 	xShape,
                                              double									nPrio,
                                              const SlideShowContext&                   rContext ) :
            mxComponentContext( rContext.mxComponentContext ),
            mxShape( xShape ),
            mnPriority( nPrio ), // TODO(F1): When ZOrder someday becomes usable: make this ( getAPIShapePrio( xShape ) ),
            maBounds( getAPIShapeBounds( xShape ) )
        {
            ENSURE_AND_THROW( mxShape.is(), "ExternalShapeBase::ExternalShapeBase(): Invalid XShape" );
        }

		// ---------------------------------------------------------------------

        uno::Reference< drawing::XShape > ExternalShapeBase::getXShape() const
        {
            return mxShape;
        }

		// ---------------------------------------------------------------------
		        
		void ExternalShapeBase::enterAnimationMode()
        {
        }

		// ---------------------------------------------------------------------
		
        void ExternalShapeBase::leaveAnimationMode()
        {
        }

		// ---------------------------------------------------------------------
		
        bool ExternalShapeBase::update() const
        {
			return render();
        }

		// ---------------------------------------------------------------------
		
        bool ExternalShapeBase::render() const
        {
            if( maBounds.getRange().equalZero() )
            {
                // zero-sized shapes are effectively invisible,
                // thus, we save us the rendering...
                return true;
            }

            return implRender( maBounds );
        }

		// ---------------------------------------------------------------------
		
        bool ExternalShapeBase::isUpdateNecessary() const
		{
			return true;
        }

		// ---------------------------------------------------------------------
		
        ::basegfx::B2DRectangle ExternalShapeBase::getPosSize() const
        {
        	return maBounds;
        }

		// ---------------------------------------------------------------------

        ::basegfx::B2DRectangle ExternalShapeBase::getDOMBounds() const
        {
            return maBounds;
        }

		// ---------------------------------------------------------------------
		
        ::basegfx::B2DRectangle ExternalShapeBase::getUpdateArea() const
        {
            return maBounds;
        }

		// ---------------------------------------------------------------------
				
        bool ExternalShapeBase::isVisible() const
		{
			return true;
		}

		// ---------------------------------------------------------------------
		
        double ExternalShapeBase::getPriority() const
        {
            return mnPriority;
        }

		// ---------------------------------------------------------------------
						
        bool ExternalShapeBase::isBackgroundDetached() const
        {
            // external shapes always have their own window/surface
			return true;
        }

		// ---------------------------------------------------------------------
        
        bool ExternalShapeBase::hasIntrinsicAnimation() const
        {
            return true;
        }
        
        bool ExternalShapeBase::hasHyperlinks() const
        {
            // not hyperlinks on media shapes
            return false;
        }
    
        ::std::vector<Shape::HyperLinkRegion> ExternalShapeBase::getHyperlinkRegions() const
        {
            return std::vector<HyperLinkRegion>();
        }
    
		// ---------------------------------------------------------------------
        
        bool ExternalShapeBase::initIntrinsicAnimation( const SlideShowContext& /*rContext*/,
                                                        const ShapeSharedPtr&	/*rShape*/ )
        {
            return true;
        }    

        bool ExternalShapeBase::startIntrinsicAnimation( const SlideShowContext& rContext,
                                                                 const ShapeSharedPtr&	 rShape )
        {
            return implStartIntrinsicAnimation(rContext,rShape);
        }
        
        bool ExternalShapeBase::endIntrinsicAnimation()
        {
            return implEndIntrinsicAnimation();
        }
    }
}
