/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schdll.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:02:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include <tools/shl.hxx>

#ifndef _STDCTRL_HXX
#include <svtools/stdctrl.hxx>
#endif

#ifndef _SVX_PSZCTRL_HXX
#include <svx/pszctrl.hxx>
#endif

#ifndef _SVX_MODCTRL_HXX
#include <svx/modctrl.hxx>
#endif

#ifndef _SVX_XLINEIT0_HXX
#include <svx/xlineit0.hxx>
#endif

#ifndef _SVX_XLNWTIT_HXX
#include <svx/xlnwtit.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX
#include <svx/xlnclit.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif

#ifndef _SVX_XFILLIT0_HXX
#include <svx/xfillit0.hxx>
#endif

#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif
// header for XFillTransparenceItem
#ifndef _SVX_XFLTRIT_HXX
#include <svx/xfltrit.hxx>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTDATACHANGEEVENT_HPP_
#include <com/sun/star/chart/ChartDataChangeEvent.hpp>
#endif

#ifndef _COM_SUN_STAR_EMBED_XEMBEDDEDOBJECT_HPP_
#include <com/sun/star/embed/XEmbeddedObject.hpp>
#endif
#ifndef _COM_SUN_STAR_EMBED_XCOMPONENTSUPPLIER_HPP_
#include <com/sun/star/embed/XComponentSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_EMBED_EMBEDSTATES_HPP_
#include <com/sun/star/embed/EmbedStates.hpp>
#endif

#include <sfx2/objsh.hxx>
#include <sfx2/docfilt.hxx>
#include <sfx2/docfile.hxx>
#include <sfx2/fcontnr.hxx>

#include "docshell.hxx"
#include "schmod.hxx"
#include "app.hrc"
#include "schresid.hxx"
#include "schdll.hxx"
#include "memchrt.hxx"
#include "viewshel.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "dgrdata.hxx"
#include "dlggraut.hxx"
#include "objfac.hxx"
#include "res_bmp.hrc"	// contains define for RID_MENU, RID_ACCEL

#include "globopt.hxx"

using namespace com::sun::star;

/*************************************************************************
|*
|* Initialisierung aus SfxApplicaton::Init()
|*
\************************************************************************/
static SchChartDocShell* ConvertToObjectShell( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& xObj )
{
    try
    {
        if ( xObj->getCurrentState() == embed::EmbedStates::LOADED )
            xObj->changeState( embed::EmbedStates::RUNNING );

        uno::Reference < embed::XComponentSupplier > xSup( xObj, uno::UNO_QUERY );
        if ( xSup.is() )
        {
            uno::Reference < lang::XUnoTunnel > xTunnel( xSup->getComponent(), uno::UNO_QUERY );
            if ( xTunnel.is() )
            {
                ::com::sun::star::uno::Sequence < sal_Int8 > aSeq( SvGlobalName( SFX_GLOBAL_CLASSID ).GetByteSequence() );
                sal_Int64 nHandle = xTunnel->getSomething( aSeq );
                if ( nHandle )
                {
                    SfxObjectShell* pDoc = (SfxObjectShell*) (sal_Int32*) nHandle;
                    SchChartDocShell* pChartDoc = PTR_CAST( SchChartDocShell, pDoc );
                    return pChartDoc;
                }
            }
        }
    }
    catch ( uno::Exception& )
    {
    }

    return NULL;
}

void SchDLL::Init()
{

	SchModule** ppShlPtr = (SchModule**) GetAppData(SHL_SCH);
	if ( *ppShlPtr )
		return;

	SfxObjectFactory& rFact = SchChartDocShell::Factory();
	(*ppShlPtr) = new SchModule( &rFact );

    rFact.SetDocumentServiceName(String::CreateFromAscii("com.sun.star.chart.ChartDocument"));

	SchViewShell::RegisterFactory(1);

	SfxModule* pMod = SCH_MOD();
	SchModule::RegisterInterface(pMod);
	SchChartDocShell::RegisterInterface(pMod);
	SchViewShell::RegisterInterface(pMod);

	SchDiagramDataWrapper::RegisterChildWindow(0, pMod);
	Svx3DChildWindow::RegisterChildWindow(0, pMod);
	SvxPosSizeStatusBarControl::RegisterControl(SID_ATTR_SIZE, pMod);
	SvxModifyControl::RegisterControl(SID_DOC_MODIFIED, pMod);

    pMod->PutItem( SfxUInt16Item( SID_ATTR_METRIC, ::sch::util::GetMeasureUnit() ));
}

/*************************************************************************
|*
|* Deinitialisierung
|*
\************************************************************************/

void SchDLL::Exit()
{
	// the SchModule must be destroyed
	SchModule** ppShlPtr = (SchModule**) GetAppData(SHL_SCH);
	delete (*ppShlPtr);
	(*ppShlPtr) = NULL;
}

extern_c void __LOADONCALLAPI SchSetTransparent( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj, BOOL bTransp )
{
	SchDLL::Init();
    SchChartDocShellRef aSchChartDocShellRef = ConvertToObjectShell( aIPObj );

	if (aSchChartDocShellRef.Is())
	{
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		const SfxItemSet &rAttr = rDoc.GetDiagramAreaAttr();

		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineStyleItem( XLINE_NONE ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineWidthItem( 0 ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineColorItem( String(), COL_BLACK ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XFillColorItem( String(), COL_WHITE ));

		if( bTransp )
			SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XFillTransparenceItem( 100 ) );
		else
			SAL_CONST_CAST( SfxItemSet &, rAttr).ClearItem( XATTR_FILLTRANSPARENCE );

        rDoc.PageColorChanged( rAttr );

        // #109154# propagate changes in chart item set to drawing object
        // #i41892# do NOT call BuildChart at this time (usually this call comes
        // very early, i.e. the chart isn't initialized yet).  It may result in
        // a recursive BuildChart call.  Disabling this BuildChart call seems
        // not to re-introduce #109154#
//         rDoc.BuildChart( FALSE );
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchUpdate( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj,
										 SchMemChart* pData, OutputDevice* pOut )
{
	SchDLL::Init();
    SchChartDocShellRef aSchChartDocShellRef = ConvertToObjectShell( aIPObj );

	if( aSchChartDocShellRef.Is() )
	{
#ifdef DBG_UTIL
		if( !pData )
			DBG_TRACE( "SchUpdate was called without MemChart" );
#endif
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		if( pData )
		{
			rDoc.SetChartDataBuffered( *pData, FALSE );		// don't update titles. This can't be done via SchUpdate
			rDoc.CheckForNewAxisNumFormat();
			rDoc.SetChanged();								// #72576#

			com::sun::star::chart::ChartDataChangeEvent aEvent;
			aEvent.Type = com::sun::star::chart::ChartDataChangeType_ALL;
			aEvent.StartColumn = 0;
			aEvent.EndColumn = 0;
			aEvent.StartRow = 0;
			aEvent.EndRow = 0;

			aSchChartDocShellRef->DataModified( aEvent );
		}
		else
		{
			rDoc.BuildChart( FALSE );
		}
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchUpdateAttr( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj,
											 SchMemChart* pData,
											 const SfxItemSet& rAttr,
											 OutputDevice* pOut )
{
	SchDLL::Init();
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");
	if(!pData)return;

    SchChartDocShellRef aSchChartDocShellRef = ConvertToObjectShell( aIPObj );

	if (aSchChartDocShellRef.Is())
	{

		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		rDoc.SetChartData(*new SchMemChart(*pData));
		rDoc.PutAttr(rAttr);

		if( pOut )
			aSchChartDocShellRef->UpdateChart(pOut);
		else
			rDoc.BuildChart(TRUE);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c ModalDialog* __LOADONCALLAPI SchCreateDiagramAutoPilotDlg
												(Window* pParent,
												 SchMemChart* pData,
												 const SfxItemSet& rInAttrs,
												 SfxItemSet& rOutAttrs,
												 BOOL bPrePage)
{
	SchDLL::Init();
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");

	if(!pData)return NULL;
	return new SchDiagramAutoPilotDlg( pParent, *new SchMemChart(*pData), rInAttrs,
									   rOutAttrs, bPrePage );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchChangeChartData(ModalDialog* pDlg,
												 SchMemChart* pData)
{
	SchDLL::Init();
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");

	((SchDiagramAutoPilotDlg*)pDlg)->ChangeChartData(*new SchMemChart(*pData));
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SfxTabDialog* __LOADONCALLAPI SchCreateOptionsDlg(Window* pParent,
														   const SfxItemSet& rInAttrs,
														   XOutdevItemPool* pItemPool)
{
	SchDLL::Init();
	return( NULL );
	//return new SchOptionsDlg(pParent, rInAttrs, pItemPool);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchGetChartData (const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj)
{
	SchDLL::Init();
    SchChartDocShellRef aSchChartDocShellRef = ConvertToObjectShell( aIPObj );

	if (aSchChartDocShellRef.Is())
	{
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();
		SchMemChart* pMemChart = rDoc.GetChartData ();

		if (pMemChart)
		{
			pMemChart->SetMainTitle(rDoc.MainTitle());
			pMemChart->SetSubTitle(rDoc.SubTitle());
			pMemChart->SetXAxisTitle(rDoc.XAxisTitle());
			pMemChart->SetYAxisTitle(rDoc.YAxisTitle());
			pMemChart->SetZAxisTitle(rDoc.ZAxisTitle());
		}

		return pMemChart;
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartNone ()
{
	SchDLL::Init();
	return new SchMemChart;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartXY (short nCols, short nRows)
{
	SchDLL::Init();
	return new SchMemChart (nCols, nRows);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartCopy (const SchMemChart &rMemChart)
{
	SchDLL::Init();
	return new SchMemChart (rMemChart);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c ChartModel* __LOADONCALLAPI SchGetModel (const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj)
{
	SchDLL::Init();
    SchChartDocShellRef aSchChartDocShellRef = ConvertToObjectShell( aIPObj );

	if (aSchChartDocShellRef.Is()) return &aSchChartDocShellRef->GetDoc();
	else return 0;
}

extern_c void __LOADONCALLAPI SchGetDefaultForColumnText(
				const SchMemChart& rMemChart, sal_Int32 nCol, String& aResult )
{
	SchDLL::Init();
	aResult = rMemChart.GetDefaultColumnText( nCol );
}

extern_c void __LOADONCALLAPI SchGetDefaultForRowText(
			const SchMemChart& rMemChart, sal_Int32 nRow, String& aResult )
{
	SchDLL::Init();
	aResult = rMemChart.GetDefaultRowText( nRow );
}

extern_c void __LOADONCALLAPI SchConvertChartRangeForWriter(
							SchMemChart& rMemChart, BOOL bOldToNew )
{
	SchDLL::Init();
	rMemChart.ConvertChartRangeForWriter( bOldToNew );
}

extern_c void __LOADONCALLAPI SchConvertChartRangeForCalc(
							SchMemChart& rMemChart, BOOL bOldToNew )
{
	SchDLL::Init();
	rMemChart.ConvertChartRangeForCalc( bOldToNew );
}

extern_c void __LOADONCALLAPI SchMemChartResetTranslation(
							SchMemChart& rMemChart, sal_Int32 *pTable,long nCnt )
{
	SchDLL::Init();
	rMemChart.ResetTranslation( pTable, nCnt );
}

extern_c void __LOADONCALLAPI SchMemChartUpdateTranslation(
							SchMemChart& rMemChart, sal_Int32 *pTable, long nCnt )
{
	SchDLL::Init();
	rMemChart.UpdateTranslation( pTable, nCnt );
}

extern_c void __LOADONCALLAPI SchMemChartInsertCols( SchMemChart& rMemChart,
												short nAtCol, short nCount)
{
	SchDLL::Init();
	rMemChart.InsertCols( nAtCol, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartRemoveCols( SchMemChart& rMemChart,
												short nAtCol, short nCount)
{
	SchDLL::Init();
	rMemChart.RemoveCols( nAtCol, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartInsertRows( SchMemChart& rMemChart,
												short nAtRow, short nCount)
{
	SchDLL::Init();
	rMemChart.InsertRows( nAtRow, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartRemoveRows( SchMemChart& rMemChart,
												short nAtRow, short nCount)
{
	SchDLL::Init();
	rMemChart.RemoveRows( nAtRow, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartSwapCols( SchMemChart& rMemChart,
								  				int nAtCol1, int nAtCol2)
{
	SchDLL::Init();
	rMemChart.SwapCols( nAtCol1, nAtCol2 );
}

extern_c void __LOADONCALLAPI SchMemChartSwapRows( SchMemChart& rMemChart,
								  				int nAtRow1,int nAtRow2)
{
	SchDLL::Init();
	rMemChart.SwapRows( nAtRow1, nAtRow2 );
}

extern_c SfxTabPage* __LOADONCALLAPI SchCreateOptionsTabPage( sal_uInt16 nId, Window* pParent, const SfxItemSet* pSet )
{
	SchDLL::Init();
	if ( !pSet )
		pSet = SCH_MOD()->CreateItemSet( nId );
	return SchModule::CreateOptionsTabPage( nId, pParent, *pSet );
}

