/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccDiagram.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:58:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccDiagram.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef SCH_CHART_AXIS_HXX
#include "chaxis.hxx"
#endif
#ifndef _SCH_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#ifndef _SCH_SCHVIEW_HXX
#include "schview.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif

#include "AccAxis.hxx"
#include "AccGrid.hxx"

using ::rtl::OUString;
using ::vos::OGuard;
using ::vos::OClearableGuard;
using ::osl::ResettableMutexGuard;

namespace accessibility
{

#if OSL_DEBUG_LEVEL > 1

OUString lcl_GetChartStyleName( const SvxChartStyle & eStyle )
{
    switch( eStyle )
    {
        case CHSTYLE_2D_LINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_LINE" ));
        case CHSTYLE_2D_STACKEDLINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STACKEDLINE" ));
        case CHSTYLE_2D_PERCENTLINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PERCENTLINE" ));
        case CHSTYLE_2D_COLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_COLUMN" ));
        case CHSTYLE_2D_STACKEDCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STACKEDCOLUMN" ));
        case CHSTYLE_2D_PERCENTCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PERCENTCOLUMN" ));
        case CHSTYLE_2D_BAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_BAR" ));
        case CHSTYLE_2D_STACKEDBAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STACKEDBAR" ));
        case CHSTYLE_2D_PERCENTBAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PERCENTBAR" ));
        case CHSTYLE_2D_AREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_AREA" ));
        case CHSTYLE_2D_STACKEDAREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STACKEDAREA" ));
        case CHSTYLE_2D_PERCENTAREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PERCENTAREA" ));
        case CHSTYLE_2D_PIE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PIE" ));
        case CHSTYLE_3D_STRIPE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_STRIPE" ));
        case CHSTYLE_3D_COLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_COLUMN" ));
        case CHSTYLE_3D_FLATCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_FLATCOLUMN" ));
        case CHSTYLE_3D_STACKEDFLATCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_STACKEDFLATCOLUMN" ));
        case CHSTYLE_3D_PERCENTFLATCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_PERCENTFLATCOLUMN" ));
        case CHSTYLE_3D_AREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_AREA" ));
        case CHSTYLE_3D_STACKEDAREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_STACKEDAREA" ));
        case CHSTYLE_3D_PERCENTAREA:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_PERCENTAREA" ));
        case CHSTYLE_3D_SURFACE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_SURFACE" ));
        case CHSTYLE_3D_PIE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_PIE" ));
        case CHSTYLE_2D_XY:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_XY" ));
        case CHSTYLE_3D_XYZ:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_XYZ" ));
        case CHSTYLE_2D_LINESYMBOLS:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_LINESYMBOLS" ));
        case CHSTYLE_2D_STACKEDLINESYM:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STACKEDLINESYM" ));
        case CHSTYLE_2D_PERCENTLINESYM:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PERCENTLINESYM" ));
        case CHSTYLE_2D_XYSYMBOLS:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_XYSYMBOLS" ));
        case CHSTYLE_3D_XYZSYMBOLS:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_XYZSYMBOLS" ));
        case CHSTYLE_2D_DONUT1:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_DONUT1" ));
        case CHSTYLE_2D_DONUT2:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_DONUT2" ));
        case CHSTYLE_3D_BAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_BAR" ));
        case CHSTYLE_3D_FLATBAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_FLATBAR" ));
        case CHSTYLE_3D_STACKEDFLATBAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_STACKEDFLATBAR" ));
        case CHSTYLE_3D_PERCENTFLATBAR:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_3D_PERCENTFLATBAR" ));
        case CHSTYLE_2D_PIE_SEGOF1:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PIE_SEGOF1" ));
        case CHSTYLE_2D_PIE_SEGOFALL:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_PIE_SEGOFALL" ));
        case CHSTYLE_2D_NET:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET" ));
        case CHSTYLE_2D_NET_SYMBOLS:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET_SYMBOLS" ));
        case CHSTYLE_2D_NET_STACK:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET_STACK" ));
        case CHSTYLE_2D_NET_SYMBOLS_STACK:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET_SYMBOLS_STACK" ));
        case CHSTYLE_2D_NET_PERCENT:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET_PERCENT" ));
        case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_NET_SYMBOLS_PERCENT" ));
        case CHSTYLE_2D_CUBIC_SPLINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_CUBIC_SPLINE" ));
        case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_CUBIC_SPLINE_SYMBOL" ));
        case CHSTYLE_2D_B_SPLINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_B_SPLINE" ));
        case CHSTYLE_2D_B_SPLINE_SYMBOL:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_B_SPLINE_SYMBOL" ));
        case CHSTYLE_2D_CUBIC_SPLINE_XY:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_CUBIC_SPLINE_XY" ));
        case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY" ));
        case CHSTYLE_2D_B_SPLINE_XY:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_B_SPLINE_XY" ));
        case CHSTYLE_2D_B_SPLINE_SYMBOL_XY:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_B_SPLINE_SYMBOL_XY" ));
        case CHSTYLE_2D_XY_LINE:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_XY_LINE" ));
        case CHSTYLE_2D_LINE_COLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_LINE_COLUMN" ));
        case CHSTYLE_2D_LINE_STACKEDCOLUMN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_LINE_STACKEDCOLUMN" ));
        case CHSTYLE_2D_STOCK_1:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STOCK_1" ));
        case CHSTYLE_2D_STOCK_2:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STOCK_2" ));
        case CHSTYLE_2D_STOCK_3:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STOCK_3" ));
        case CHSTYLE_2D_STOCK_4:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_2D_STOCK_4" ));
        case CHSTYLE_ADDIN:
            return OUString( RTL_CONSTASCII_USTRINGPARAM( "CHSTYLE_ADDIN" ));
        default:
            return OUString();
    }
}
#endif

static const size_t lcl_nNumberOfStates = 13;

Diagram::Diagram( AccessibleBase * pParent ) :
        AccessibleChartElement( AccessibleUniqueId( CHOBJID_DIAGRAM ),
                                pParent,
                                true /* has children */ ),

    m_nSeries( 0 )
{
    // init vector to false
    m_aAxisExistence.insert( m_aAxisExistence.end(), lcl_nNumberOfStates, false );
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetChartAttr() );
    // \-- solar
}

Diagram::~Diagram()
{}

OUString SAL_CALL Diagram::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "Diagram" ) );
}

OUString SAL_CALL Diagram::getAccessibleDescription()
    throw (::com::sun::star::uno::RuntimeException)
{
    CheckDisposeState();

    OUString aResult;
    SchWindow * pWin = GetWindow();
    if( pWin )
    {
        // /-- solar
        OGuard aSolarGuard( Application::GetSolarMutex() );
        SchViewShell * pViewShell = pWin->GetViewShell();
        if( pViewShell )
        {
            SchView * pView = pViewShell->GetView();
            if( pView )
            {
                aResult = pView->GetContextType();
            }
        }
        // \-- solar
    }

    if( aResult.getLength() == 0 )
    {
#if OSL_DEBUG_LEVEL > 1
        // /-- solar
        OGuard aSolarGuard( Application::GetSolarMutex() );
        aResult = lcl_GetChartStyleName( GetChartModel()->ChartStyle() );
        // \-- solar
#else
        aResult = getAccessibleName();
#endif
    }

    return aResult;
}

sal_uInt16 lcl_ObjIdToAxisId( sal_uInt16 nObjId )
{
    switch( nObjId )
    {
        case Axis::X_AXIS:
            return CHAXIS_AXIS_X;
        case Axis::Y_AXIS:
            return CHAXIS_AXIS_Y;
        case Axis::Z_AXIS:
            return CHAXIS_AXIS_Y;
        case Axis::SEC_X_AXIS:
            return CHAXIS_AXIS_A;
        case Axis::SEC_Y_AXIS:
            return CHAXIS_AXIS_B;
        default:
            return 0;
    }
}

// ____________ protected ____________
bool Diagram::UpdateChildren()
{
    ChartModel * pModel = GetChartModel();
    if( ! pModel )
        return false;

    bool bHasDomain = false;
    sal_uInt16 nSeries = false;

    {
        // /-- solar
        OGuard aSolarGuard( Application::GetSolarMutex() );
        bHasDomain = (true && pModel->IsXYChart());

        nSeries = 0;
        {
            if( pModel->IsPieChart() )
                nSeries = 1;
            else
            {
                nSeries = static_cast< sal_uInt16 >( pModel->GetRowCount() );
                if( bHasDomain )
                    nSeries--;
            }
        }
        // \-- solar
    }

    // /--
    ResettableMutexGuard aGuard( GetMutex());

    sal_uInt16 nMemberSeries = m_nSeries;
    BoolVector aLocalMembers( m_aAxisExistence );

    aGuard.clear();
    // \--

    // axes and grids
    // --------------
    static const sal_uInt16 aObjectIds[ lcl_nNumberOfStates ] =
        {
            Axis::X_AXIS,
            Axis::Y_AXIS,
            Axis::Z_AXIS,
            Axis::SEC_X_AXIS,
            Axis::SEC_Y_AXIS,

            Grid::X_MAJOR,
            Grid::Y_MAJOR,
            Grid::Z_MAJOR,
            Grid::X_MINOR,
            Grid::Y_MINOR,
            Grid::Z_MINOR,

            CHOBJID_DIAGRAM_WALL,
            CHOBJID_DIAGRAM_FLOOR
        };

    // creates a vector containing default constructed elements
    BoolVector aCurrentState( lcl_nNumberOfStates );

    BoolVector::size_type i;

    {
        // /-- solar
        OGuard aSolarGuard( Application::GetSolarMutex() );
        // axes
        OSL_ASSERT( lcl_nNumberOfStates >= 5 );
        for( i = 0; i < 5; ++i )
            aCurrentState[ i ] = ( pModel->CanAxis( lcl_ObjIdToAxisId( aObjectIds[ i ] )) &&
                                   pModel->HasAxis( aObjectIds[ i ] ));
        // grids
        OSL_ASSERT( lcl_nNumberOfStates >= 11 );
        for( ; i < 11; ++i )
            aCurrentState[ i ] = pModel->HasGrid( aObjectIds[ i ] );
        // \-- solar
    }
    // the wall is always available
    aCurrentState[ i ] = true;
    ++i;

    // the floor is only active for 3d charts, except the pie
    aCurrentState[ i ] = ( pModel->Is3DChart() && ! pModel->IsPieChart() );

    // update children (unguarded)

    sal_uInt16 nIndex = 0;
    sal_uInt16 nOffset = bHasDomain ? 1 : 0;

    // remove series
    for( nIndex = nSeries; nIndex < nMemberSeries; ++nIndex )
    {
        UpdateChild( AccessibleUniqueId( CHOBJID_DIAGRAM_ROWGROUP, nIndex + nOffset ),
                     true, false );
    }

    // add series
    for( nIndex = nMemberSeries; nIndex < nSeries; ++nIndex )
    {
        UpdateChild( AccessibleUniqueId( CHOBJID_DIAGRAM_ROWGROUP, nIndex + nOffset ),
                     false, true );
    }

    // other members (after the series, such that the wall does not cover the
    // series in getAccessibleAtPoint()
    for( i = 0; i < lcl_nNumberOfStates; i++ )
        aLocalMembers[ i ] = UpdateChild( aObjectIds[ i ], aLocalMembers[ i ], aCurrentState[ i ] );

    // /--
    aGuard.reset();

    m_nSeries = nSeries;
    m_aAxisExistence = aLocalMembers;

    return true;
    // \--
}

OUString SAL_CALL Diagram::getImplementationName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccDiagram" ));
}

}  // namespace accessibility
