/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: objadj.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:57:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include "objadj.hxx"
#include "glob.hxx"




/*************************************************************************
|*
|* Objekt-Ausrichting ermitteln
|*
\************************************************************************/

SchObjectAdjust* GetObjectAdjust(const SdrObject& rObj)
{
	for (USHORT i = 0; i < rObj.GetUserDataCount(); i++)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);
		if (pData && pData->GetId() == SCH_OBJECTADJUST_ID)
			return (SchObjectAdjust*)pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust() :
	SdrObjUserData(SchInventor, SCH_OBJECTADJUST_ID, 1),
	eAdjust(CHADJUST_TOP_LEFT),
	eOrient(CHTXTORIENT_STANDARD)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust(ChartAdjust eAdj,
								 SvxChartTextOrient eOr) :
	SdrObjUserData(SchInventor, SCH_OBJECTADJUST_ID, 1),
	eAdjust(eAdj),
	eOrient(eOr)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust(const SchObjectAdjust& rObjectAdjust) :
	SdrObjUserData(rObjectAdjust),
	eAdjust(rObjectAdjust.eAdjust),
	eOrient(rObjectAdjust.eOrient)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchObjectAdjust::Clone(SdrObject *pObj) const
{
	return new SchObjectAdjust(*this);
}

// eof
