/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartbar.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:49:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#include "chtmodel.hxx"
#include "chartbar.hxx"
#include "chaxis.hxx"

void ChartBarDescriptor::ChangeModel( ChartModel* pNewModel )
{
    // use new model ...
    mpModel = pNewModel;

    // ... and the new corresponding axis
    if( mpAxis &&
        mpModel )
    {
        mpAxis = mpModel->GetAxisByUID( mpAxis->GetUniqueId());
    }
}

void ChartBarDescriptor::SetGap(long nPercent)
{
	nGapPercent=nPercent;
	if(mpAxis && mpModel)
	{
		SfxItemSet aSet(mpModel->GetPool(),SCHATTR_BAR_GAPWIDTH,SCHATTR_BAR_GAPWIDTH);
		aSet.Put(SfxInt32Item(SCHATTR_BAR_GAPWIDTH,nPercent));
		mpAxis->GetItemSet()->Put(aSet);
	}
}

void ChartBarDescriptor::SetOverlap(long nPercent)
{
	nOverlapPercent=nPercent;
	if(mpAxis && mpModel)
	{
		SfxItemSet aSet(mpModel->GetPool(),SCHATTR_BAR_OVERLAP,SCHATTR_BAR_OVERLAP);
		aSet.Put(SfxInt32Item(SCHATTR_BAR_OVERLAP,nPercent));
		mpAxis->GetItemSet()->Put(aSet);
	}
}

long ChartBarDescriptor::GetOverlap() const
{
	if(mpAxis)
	{
		SfxItemSet* pSet=mpAxis->GetItemSet();
		const SfxPoolItem *pPoolItem = NULL;
		if (pSet->GetItemState(SCHATTR_BAR_OVERLAP, TRUE, &pPoolItem) == SFX_ITEM_SET)
		((ChartBarDescriptor*)this)->nOverlapPercent=((const SfxInt32Item*) pPoolItem)->GetValue();
	}
	return nOverlapPercent;
}

long ChartBarDescriptor::GetGap() const
{
	if(mpAxis)
	{
		SfxItemSet* pSet=mpAxis->GetItemSet();
		const SfxPoolItem *pPoolItem = NULL;
		if (pSet->GetItemState(SCHATTR_BAR_GAPWIDTH, TRUE, &pPoolItem) == SFX_ITEM_SET)
		((ChartBarDescriptor*)this)->nGapPercent=((const SfxInt32Item*) pPoolItem)->GetValue();
	}
	return nGapPercent;
}

void ChartBarDescriptor::Create(const Rectangle& aRect,long nColCnt,long nRowCnt)
{
	nPartWidth=0;
	nBarWidth=0;
	nGap=nOver=nBarWidth=nPartWidth=nLeft=nCurrent=0;

	nOverlapPercent=GetOverlap();
	nGapPercent=GetGap();

	if(!nColCnt||!nRowCnt)
	{
		DBG_TRACE("Chart :: Keine Daten!");
		return;
	}


	//gestapelt => alles uebereinander, das entspricht im Prinzip dem Fall mit nur
	//einer Datenreihe (interpretiere nRowCnt als Anzahl NEBENEINANDERSTEHENDER Balken)
	if(mpModel->IsStacked())
		nRowCnt = 1;

	//Dieser Platz steht uns zur Verfuegung:
	BOOL bVerticalX = mpModel->IsXVertikal();
	nPartWidth = (bVerticalX ? aRect.GetHeight() : aRect.GetWidth()) / nColCnt;

	//Es gilt (bei MS-Excel97, empirisch ermittelt) :
	//Barwidth = (Partwidth - Gapwidth) / (Rows - Overlap * (Rows -1) )
	//Gapwidth = Partwidth - GapPercent/100 * Barwidth
	// => Barwidth = Partwidth / (Rowfak + GapPercent/100)

	double fGap	    = (double)nGapPercent/100.0;
	double fOverlap = (double)nOverlapPercent/100.0;

	//sicher ist sicher.... sollte aber nie negativ eingegeben werden koennen
	if(fGap<0.0)
		fGap=0.0;

	//Datenreihenueberlappfaktor, Range = [1,(2*nRow-1)]
	double fRowFak  = (double)nRowCnt - fOverlap * (double)(nRowCnt - 1);

	//jetzt kann die Balkendicke ermittelt werden:
	nBarWidth = (long) ((double)nPartWidth / (fRowFak + fGap));
	nGap = (long) (fGap * (double)nBarWidth);

	//Position des jeweils folgenden Balkens einer Spalte
	nOver=(long)( (double)nBarWidth - fOverlap*(double)nBarWidth );

	//jetzt nochmal nachsehen, ob die Berechnungen vernuenftige Diagramme liefern:
	const long nMinBarWidth = 40;//hat mal irgendwer festgelegt, gab auch mal nen Max...
	if(nBarWidth < nMinBarWidth)
	{
		if(nRowCnt>1 && fOverlap < 0.0)
		{
			//dann erstmal den Ueberlapp vergroessern auf maximal kein Ueberlapp ;)
			double fMinlap = ( -((double)nPartWidth/(double)nMinBarWidth) + fGap + (double)nRowCnt )
				//--------------------------------------------------------------------------
									   / (double)(nRowCnt-1);
			if(fMinlap < 0.0) //sollte noch negativ (= Luecke) sein
			{
				fOverlap=fMinlap;
				fRowFak  = (double)nRowCnt - fOverlap * (double)(nRowCnt - 1);
				nBarWidth = (long) ((double)nPartWidth / (fRowFak + fGap));
				nGap = (long) (fGap * (double)nBarWidth);
				nOver=(long)( (double)nBarWidth - fOverlap*(double)nBarWidth );
			}
			else //hilft alles nix => erstmal ganz weg mit den Ueberlapp-Luecken
			{	 //bei negativem Ueberlapp
				nOver=0;
				nBarWidth = (long) ((double)nPartWidth / ((double)nRowCnt + fGap));
				nGap = (long) (fGap * (double)nBarWidth);
			}
		}
		if(nBarWidth < nMinBarWidth)//immer noch zu klein, dann regulaere Luecke verkleinern
		{
			double fMingap = (double)nPartWidth/(double)nMinBarWidth - fRowFak;
			if(fMingap > 0.0 ) //noch kleiner sollte es besser nicht werden ....
			{
				fGap=fMingap;
				fRowFak  = (double)nRowCnt - fOverlap * (double)(nRowCnt - 1);
				nBarWidth = (long) ((double)nPartWidth / (fRowFak + fGap));
				nGap = (long) (fGap * (double)nBarWidth);
				nOver=(long)( (double)nBarWidth - fOverlap*(double)nBarWidth );
			}
			else
			{	//mehr geht eh nicht, ausser vielleicht Ueberlapp -> 1.0
				nGap=0;
				nBarWidth=nPartWidth / nRowCnt;
			}
		}
		if( nBarWidth <= 0 )
			DBG_WARNING(  "ChartBarDescriptor: cannot create bars with zero width" );
	}

	nLeft = nCurrent = (bVerticalX ? aRect.Top() : aRect.Left()) + nGap/2;
}
