/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DataSeriesTreeHelper.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:23:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "DataSeriesTreeHelper.hxx"
#include "algohelper.hxx"
#include "InlineContainer.hxx"
#include "macros.hxx"

#ifndef _COM_SUN_STAR_CHART2_XSTACKABLESCALEGROUP_HPP_
#include <com/sun/star/chart2/XStackableScaleGroup.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#include <algorithm>

using namespace ::com::sun::star;
using namespace ::com::sun::star::chart2;
using namespace ::std;

using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::rtl::OUString;

namespace
{

// helping method for DataSeriesTreeHelper::getDataSeriesFromDiagram()
void lcl_AddSeriesRecursive(
    Reference< XDataSeriesTreeParent > xParent,
        vector< Reference< XDataSeries > > & rOutSeriesVec )
{
    if( xParent.is())
    {
        Sequence< Reference< XDataSeriesTreeNode > > aChildren( xParent->getChildren());
        for( sal_Int32 i = 0; i < aChildren.getLength(); ++i )
        {
            Reference< XDataSeries > aDataSeries( aChildren[ i ], uno::UNO_QUERY );
            if( aDataSeries.is())
            {
                rOutSeriesVec.push_back( aDataSeries );
            }
            else
            {
                Reference< XDataSeriesTreeParent > xNewParent( aChildren[ i ], uno::UNO_QUERY );
                if( xNewParent.is())
                    lcl_AddSeriesRecursive( xNewParent, rOutSeriesVec );
            }
        }
    }
}

bool lcl_getStackMode(
    const Reference< XDataSeriesTreeParent > & xParent,
    StackMode & rOutMode )
{
    Sequence< Reference< XDataSeriesTreeNode > > aChildren( xParent->getChildren());
    bool bFound = false;

    for( sal_Int32 i = 0; (! bFound) && (i < aChildren.getLength()); ++i )
    {
        Reference< XStackableScaleGroup > xStackGroup( aChildren[ i ], uno::UNO_QUERY );
        Reference< lang::XServiceInfo > xServInfo( aChildren[ i ], uno::UNO_QUERY );
        if( xStackGroup.is() &&
            xServInfo.is() &&
            xServInfo->supportsService(
                C2U( "com.sun.star.chart2.ContinuousStackableScaleGroup" )))
        {
            rOutMode = xStackGroup->getStackMode();
            bFound = true;
        }
        else
        {
            Reference< XDataSeriesTreeParent > xNewParent( aChildren[ i ], uno::UNO_QUERY );
            if( xNewParent.is())
                bFound = lcl_getStackMode( xNewParent, rOutMode );
        }
    }

    return bFound;
}

void lcl_getChartTypes(
    const Reference< XDataSeriesTreeParent > & xParent,
    vector< Reference< XChartTypeGroup > > & rOutTypes )
{
    if( ! xParent.is())
        return;

    Sequence< Reference< XDataSeriesTreeNode > > aChildren( xParent->getChildren());
    for( sal_Int32 i = 0; i < aChildren.getLength(); ++i )
    {
        Reference< XChartTypeGroup > xCTGroup( aChildren[ i ], uno::UNO_QUERY );
        if( xCTGroup.is())
        {
            rOutTypes.push_back( xCTGroup );
        }
        else
        {
            Reference< XDataSeriesTreeParent > xNewParent( aChildren[ i ], uno::UNO_QUERY );
            if( xNewParent.is())
                lcl_getChartTypes( xNewParent, rOutTypes );
        }
    }
}

bool lcl_setStackModeAtTree(
    const Reference< XDataSeriesTreeParent > & rTree, StackMode eMode )
{
    if( ! rTree.is())
        return false;

    bool bResult = false;

    // seek value stacking group
    Sequence< Reference< XDataSeriesTreeNode > > aChildren( rTree->getChildren());
    for( sal_Int32 i = 0;
         ( ! bResult ) && ( i < aChildren.getLength() );
         ++i )
    {
        Reference< XStackableScaleGroup > xStackGroup( aChildren[ i ], uno::UNO_QUERY );
        if( xStackGroup.is())
        {
            Reference< lang::XServiceInfo > xServInfo( aChildren[ i ], uno::UNO_QUERY );
            if( xServInfo.is() &&
                xServInfo->supportsService(
                    C2U( "com.sun.star.chart2.ContinuousStackableScaleGroup" )))
            {
                xStackGroup->setStackMode( eMode );
                bResult = true;
                break;
            }
        }

        // recurse
        Reference< XDataSeriesTreeParent > xNewParent( aChildren[ i ], uno::UNO_QUERY );
        if( xNewParent.is() &&
            lcl_setStackModeAtTree( xNewParent, eMode ))
            bResult = true;
    }

    return bResult;
}

} // anonymous namespace

// ============================================================

namespace chart
{
namespace helper
{

// static
Sequence< Reference< XDataSeries > >
    DataSeriesTreeHelper::getDataSeriesFromDiagram(
        const Reference< XDiagram > & xDia )
{
    vector< Reference< XDataSeries > > aSeriesVec;

    if( xDia.is())
    {
        Reference< XDataSeriesTreeParent > aParent( xDia->getTree());

        if( aParent.is())
            lcl_AddSeriesRecursive( aParent, aSeriesVec );
    }

    return ::chart::helper::VectorToSequence( aSeriesVec );
}

vector< Reference< XChartTypeGroup > > DataSeriesTreeHelper::getChartTypes(
    const Reference< XDataSeriesTreeParent > & xTree )
{
    vector< Reference< XChartTypeGroup > > aResult;
    lcl_getChartTypes( xTree, aResult );

    return aResult;
}

// static
sal_Int32 DataSeriesTreeHelper::getNumberOfSeriesForChartTypeByIndex(
    const Reference< XDataSeriesTreeParent > & xTree,
    sal_Int32 _nGroupNumber )
{
    sal_Int32 nResult = 0;
    if( ! xTree.is())
        return nResult;

    sal_Int32 nGroup = 0;
    Sequence< Reference< XDataSeriesTreeNode > > aChildren( xTree->getChildren());
    for( sal_Int32 i = 0; i < aChildren.getLength(); ++i )
    {
        Reference< XChartTypeGroup > xCTGroup( aChildren[ i ], uno::UNO_QUERY );
        if( xCTGroup.is())
        {
            if( nGroup == _nGroupNumber )
            {
                vector< Reference< XDataSeries > > aSeriesVec;
                lcl_AddSeriesRecursive(
                    uno::Reference< XDataSeriesTreeParent >( xCTGroup, uno::UNO_QUERY ),
                    aSeriesVec );
                nResult = aSeriesVec.size();
                break;
            }

            ++nGroup;
        }
    }

    return nResult;
}

// static
StackMode DataSeriesTreeHelper::getStackMode(
    const Reference< XDataSeriesTreeParent > & xParent )
{
    StackMode eResult = StackMode_NONE;
    if( xParent.is() &&
        lcl_getStackMode( xParent, eResult ))
        return eResult;

    return StackMode_NONE;
}

// static
bool DataSeriesTreeHelper::setStackMode(
    const Reference< XDataSeriesTreeParent > & xParent,
    StackMode eMode )
{
    return lcl_setStackModeAtTree( xParent, eMode );
}

// static

uno::Reference< XChartType >
    DataSeriesTreeHelper::getChartTypeByIndex(
        const uno::Reference< XDataSeriesTreeParent > & xTree,
        sal_Int32 _nGroupNumber /* = 1 */ )
{
    uno::Reference< XChartType > xResult;

    if( ! xTree.is())
        return xResult;

    sal_Int32 nGroup = 0;
    Sequence< Reference< XDataSeriesTreeNode > > aChildren( xTree->getChildren());
    for( sal_Int32 i = 0; i < aChildren.getLength(); ++i )
    {
        Reference< XChartTypeGroup > xCTGroup( aChildren[ i ], uno::UNO_QUERY );
        if( xCTGroup.is())
        {
            if( nGroup == _nGroupNumber )
            {
                xResult.set( xCTGroup->getChartType());
                break;
            }

            ++nGroup;
        }
    }

    return xResult;
}

} //  namespace helper
} //  namespace chart
