/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef SituaHIncl
#define SituaHIncl

// GP: clean

#include "base.h"
#include "error.h"

//enum ErrCode;

/*
Mode constants for the situation object.
*/

enum SIT_MODE
{
    SIT_MODE_NONE
};

enum MsgType
{
    MT_ERROR,
        MT_WARN,
        MT_LOG
};

enum MsgDestination
{
    MD_NONE,
        MD_FILE,
        MD_CHERROR
};

/*
The following class keeps track of the current situation: which vertex
is currently being parsed/processed etc. This is used solely for error reporting.
*/

class XSLElement;
class Vertex;
#include "datastr.h"

class SitData 
{
public:
    Vertex *currV;
    Str currFile;
    int currLine;
};

class Processor;

class SituationObj
{
public:
    SituationObj(Processor* proc);
    ~SituationObj();
    void setCurrV(Vertex *);
    void setCurrFile(Str &);
    void setCurrLine(int);
    //
    void error(MsgCode, const Str &, const Str &);
    void warning(MsgCode, const Str &, const Str &);
    void logmsg(MsgCode, const Str &, const Str &);
    //
    void clear();
    void clearError();
    Bool isError();     
    int getError() const;
    //
    eFlag msgOutputFile(char *_errwfn, char *_logfn);
    eFlag eraseLog(char *newLogFile);
    Str timeStr();
    eFlag openDefaultFiles();
    eFlag closeFiles();
    void pushCurrV(Vertex *);
    void pushCurrent();
    void popCurrent();
private:
    Processor* proc;
    Vertex *currV;
    Str currFile;
    int currLine;
    MsgCode pending;
    void message(MsgType, MsgCode, const Str &, const Str &);
    FILE *logfile, *errwfile;
    PList<SitData*> history;
};

#endif // SituaHIncl
