#!/usr/bin/python

# boost graph library compilation regression test

# Usage: regrtest [*|compiler] [*|library/program]
#
# Default: regrtest * *
#
# Compilers:  bcc   = Borland 5.5.1
#             cw    = Metrowerks CodeWarrior
#             gcc   = GNU GCC
#             gcc-stlport  = GNU GCC with STLport library
#             como  = Comeau C++
#             vc    = Microsoft Visual C++
#             vcstlport  = Microsoft Visual C++ with STLport library
#             suncc = Sun's C++ compiler
#             kcc = KAI C++ 3.4g
#
# Examples: regrtest
#           regrtest
#           regrtest gcc
#           regrtest * smart_ptr/smart_ptr_test.cpp
#           regrtest gcc smart_ptr/smart_ptr_test.cpp
#
# Note: use the following command line syntax if output is to be redirected:
#           python regrtest.py [*|compiler] [*|library/program]  >log 2>&1

# Revision history:
#  09 Dec 00 Modified the main boost regrtest.py to create this file. -Jeremy


# The Metrowerks and Microsoft compilers require various environment variables be set.
#   See mwcc -help
#   See http://msdn.microsoft.com/library/devprods/vs6/visualc/vccore/_core_building_on_the_command_line.3a_.overview.htm
# Others:
#   See bcb4.hlp.  Don't bother with bcb4tools.hlp; it has a bad link to the command line options

import sys
import os
import time

#------------------------------------------------------------------------------#

def invoke( desc, command ):

  print " ", desc
  f.write( "<td>" )
  print "  ", command     #script debugging aid
  sys.stdout.flush()
  rs=os.system( command )
  print " return status: ", rs
  if rs==0:
    f.write( "yes" )
  else:
    f.write( "no" )
  f.write( "</td>\n" )

#------------------------------------------------------------------------------#

def compile( program ):

  fullpath= path + "/libs/" + program

  print
  print "*****", program, "*****"

  f.write( "<tr>\n" )
  f.write( "<td><a href=\"" + program + "\">" + program + "</a></td>\n" )

# ----------  Linux2 ---------- #

  if sys.platform == "linux2": 
    if compiler_arg == "*" or compiler_arg == "gcc":
      invoke( "GCC 2.95.2", 'g++ -ftemplate-depth-30 -c -I' + path + ' ' + fullpath )
    if compiler_arg == "*" or compiler_arg == "gcc-stlport":
      invoke( "GCC 2.95.2 STLport 4.0", 'g++ -V 2.95.2-stlport -c -ftemplate-depth-30 -I' + path + ' ' + fullpath )
#    if compiler_arg == "*" or compiler_arg == "gcc-exp":
#      invoke( "GCC pre-2.97 experimental", '/opt/exp/gcc/bin/g++ -ftemplate-depth-30 -I' + path + ' ' + fullpath )
    if compiler_arg == "*" or compiler_arg == "como":
      invoke( "Comeau C++ 4.2.44 beta3", 'como -c -I' + path + ' ' + fullpath)
#    if compiler_arg == "*" or compiler_arg == "occ":
#      invoke( "OpenC++ 2.5.9", 'occ -c --regular-c++ -I' + path + ' ' + fullpath)

# ----------- Solaris (Sun OS 5)/Sparc ------ #

  elif sys.platform == "sunos5":
    if compiler_arg == "*" or compiler_arg =="suncc":
        invoke("Sun WorkShop 6 2000/04/07 C++ 5.1", 'CC -c -I' + path + ' ' + fullpath )
    if compiler_arg == "*" or compiler_arg == "gcc":
      invoke( "GCC 2.95.2", 'g++ -Wall -pedantic -ftemplate-depth-30 -Wno-long-long -c -I' + path + ' ' + fullpath )
    if compiler_arg == "*" or compiler_arg == "kcc":
      invoke( "KCC 3.4g", 'KCC --strict_warnings -lm -I' + path + ' ' + fullpath )


# ----------- BeOS5/Intel ------ #
#
# currently this compiler fails so many tests that it may not be worth while
# reporting the results: most of these are as a result of broken C++ standard
# libraries and a non-standard <climits>, problems that the forthcoming
# gcc3 should fix (STLPort does not build on this platform).
#
  elif sys.platform == "beos":
    if compiler_arg=="*" or compiler_arg=="gcc":
      invoke( "GNU GCC", "c++ -ftemplate-depth-30 -Wall -I" + path + "  " + fullpath )
    if compiler_arg=="*" or compiler_arg=="gcc-sgi":
      invoke( "GNU GCC", "c++ -ftemplate-depth-30 -Wall -I/boot/home/config/stlport/stl330 -I" + path + "  " + fullpath )

# ----------  Windows ---------- #

  else:
#    if compiler_arg=="*" or compiler_arg=="bcc54":
#      bcc54_path=os.environ["BOOST_BCC54_PATH"]
#      invoke( "Borland C++ 5.4 up2", "\"" + bcc54_path + "/bcc32\" -I" + path + " -j10 -q " + fullpath )
    if compiler_arg=="*" or compiler_arg=="bcc":
      bcc55_path=os.environ["BOOST_BCC55_PATH"]
      invoke( "Borland C++ 5.5.1", "\"" + bcc55_path + "/bcc32\" -I" + path + " -j10 -q " + fullpath )

    # GCC 2.95.2 is looping on some tests, so only invoke if asked for by name
    #if compiler_arg=="*" or compiler_arg=="gcc":
    if compiler_arg=="gcc":
      # TODO: fix the absolute STLport paths
      invoke( "GNU GCC", "c++ -ftemplate-depth-30 -I" + path + " -IC:/stl/STLport-4.0b8/stlport  " + fullpath + "  c:/stl/STLport-4.0b8/lib/libstlport_gcc.a" )

    if compiler_arg=="*" or compiler_arg=="cw":
      invoke( "Metrowerks CodeWarrior", "mwcc -maxerrors 10 -cwd source -I- -I" + path + " " + fullpath )

#John Maddock says use /Zm400 switch; it increases compiler memory
# /MDd causes compiler errors in VC98\INCLUDE\xlocnum -Jeremy Siek
    if compiler_arg=="*" or compiler_arg=="vc":
      invoke( "VC++ with MS library", 'cl /c /nologo /Zm400 /W3 /GR /GX /Zi /Od /GZ /I "' + path + '" /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_CONSOLE" ' + fullpath )
    if compiler_arg=="*" or compiler_arg=="vcstlport":
      stl=os.environ["BOOST_STLPORT_PATH"]
      invoke( "VC++ with STLport library", 'cl /c /nologo /Zm400 /W3 /GR /GX /Zi /Od /GZ /I "' + stl + '" /I "' + path + '" /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_CONSOLE" ' + fullpath )


  f.write( "</tr>\n" )

#------------------------------------------------------------------------------#

def library():

  print
  print "***** Boost Library *****"

  f.write( "<tr>\n" )
  f.write( "<td>Boost Graph Library build</td>\n" )

  #if compiler_arg=="*" or compiler_arg=="bcc32":
  #if compiler_arg=="*" or compiler_arg=="gcc":
  #if compiler_arg=="*" or compiler_arg=="cw":

  #if compiler_arg=="*" or compiler_arg=="vc":
  #  command='cl /nologo /MDd /W3 /GR /GX /Zi /Od /GZ /I "' + path + '" /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB /c"'
  #     command=command + " " + path + "/libs/" + ...
  #  invoke( "VC++ with MS library", command )
              
#    invoke( "MS Lib with MS library", 'lib /nologo /out:"boost_vc.lib" boost_timer_vc.obj boost_prg_timer_vc.obj boost_prg_display_vc.obj' )

  #if compiler_arg=="*" or compiler_arg=="vcstlport":

  f.write( "</tr>\n" )

#----------------------------------  main  ------------------------------------#

# set up environment variables

path=os.environ["BOOST_PATH"]

compiler_arg="*"
if len(sys.argv)>1:
  compiler_arg=sys.argv[1]

program_arg="*"
if len(sys.argv)>2:
  program_arg=sys.argv[2]

if sys.platform == "linux2":
  platform = "Linux/x86"
elif sys.platform == "sunos5":
  platform = "SunOS5/sparc"
elif sys.platform == "beos":
  platform = "BeOS5/x86"
elif sys.platform == "win32":
  platform = "Windows"
  if os.name == "nt":
    platform = platform + " NT / Windows 2000"
else:
  print "**** Error: unknown platform ****"
  sys.exit(1)

f=open( "cs-" + sys.platform + ".html", "w" )

f.write( "<html>\n<head>\n<title>\nCompiler Status: " + platform + "\n</title>\n</head>" )
f.write( "<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n" )
f.write( "<h1><img border=\"0\" src=\"../../../c++boost.gif\" width=\"277\" height=\"86\"></h1>\n" )
f.write( "<h1>Compiler Status: " + platform + "</h1>\n" )
f.write( "<p><b>Run Date:</b> " + time.strftime("%d %b %Y %H:%M GMT", time.gmtime(time.time())) + "</p>\n" )
f.write( "<p>\n" )
f.write( "<table border=\"1\" cellspacing=\"0\" cellpadding=\"5\">\n"  )
f.write( "<tr>\n" )
f.write( "<td>Program</td>\n" )

if sys.platform == "linux2": 
  if compiler_arg == "*" or compiler_arg == "gcc":
    f.write( "<td>GNU<br>GCC<br>2.95.2</td>\n" )
  if compiler_arg == "*" or compiler_arg == "gcc-stlport":
    f.write( "<td>GNU<br>GCC<br>2.95.2<br>STLport<br>4.0</td>\n" )
#  if compiler_arg == "*" or compiler_arg == "gcc-exp":
#    f.write( "<td>GNU<br>GCC<br>pre-2.97 experimental</td>\n" )
  if compiler_arg == "*" or compiler_arg == "como":
    f.write( "<td>Comeau C++<br>4.2.44 beta3<br>STLport<br>4.0</td>\n" )
#  if compiler_arg == "*" or compiler_arg == "occ":
#    f.write( "<td>OpenC++<br>2.5.9</td>\n" )
elif sys.platform == "sunos5":
  if compiler_arg == "*" or compiler_arg == "suncc":
    f.write( "<td>Sun C++<br>Sun WorkShop 6, C++ 5.1</td>\n" )
  if compiler_arg == "*" or compiler_arg == "gcc":
    f.write( "<td>GNU<br>GCC<br>2.95.2</td>\n" )
  if compiler_arg == "*" or compiler_arg == "kcc":
    f.write( "<td>KAI<br>KCC<br>3.4g</td>\n" )
elif sys.platform == "beos":
  if compiler_arg == "*" or compiler_arg == "gcc":
    f.write( "<td>GNUPro<br>GCC&nbsp;2.9</td>\n" )
  if compiler_arg == "*" or compiler_arg == "gcc-sgi":
    f.write( "<td>GNUPro<br>GCC&nbsp;2.9<br>+<br>SGI&nbsp;STL&nbsp;3.3</td>\n" )
else:
#  if compiler_arg=="*" or compiler_arg=="bcc54":
#    f.write( "<td>Borland<br>BCC<br>5.4 up2</td>\n" )
  if compiler_arg=="*" or compiler_arg=="bcc":
    f.write( "<td>Borland<br>BCC<br>5.5.1</td>\n" )

  # GCC 2.95.2 is looping on some tests, so only invoke if asked for by name
  #if compiler_arg=="*" or compiler_arg=="gcc":
  if compiler_arg=="gcc":
   f.write( "<td>GNU<br>GCC<br>2.95.2<br>STLport<br>4.0 beta 8</td>\n" )
  if compiler_arg=="*" or compiler_arg=="cw":
    f.write( "<td>Metrowerks<br>CodeWarrior<br>6.0</td>\n" )
  if compiler_arg=="*" or compiler_arg=="vc":
    f.write( "<td>Microsoft<br>VC++<br>6.0 SP4</td>\n" )
  if compiler_arg=="*" or compiler_arg=="vcstlport":
    f.write( "<td>Microsoft<br>VC++<br>6.0 SP4<br>STLport<br>4.0</td>\n" )

f.write( "</tr>\n" )

if  program_arg=="*":
#  compile( "graph/example/LEDA_concept_check.cpp" )
  compile( "graph/example/adjacency_list.cpp" )
  compile( "graph/example/bellman_ford.cpp" )
  compile( "graph/example/bfs.cpp" )
  compile( "graph/example/bfs_basics.cpp" )
  compile( "graph/example/bucket_sorter.cpp" )
  compile( "graph/example/city_visitor.cpp" )
  compile( "graph/example/components_on_edgelist.cpp" )
  compile( "graph/example/concept_checks.cpp" )
  compile( "graph/example/connected_components.cpp" )
  compile( "graph/example/container_gen.cpp" )
  compile( "graph/example/cuthill_mckee_ordering.cpp" )
  compile( "graph/example/dave.cpp" )
  compile( "graph/example/dfs.cpp" )
  compile( "graph/example/dfs_basics.cpp" )
  compile( "graph/example/dfs_parenthesis.cpp" )
  compile( "graph/example/dijkstra.cpp" )
  compile( "graph/example/dynamic_components.cpp" )
  compile( "graph/example/edge_basics.cpp" )
  compile( "graph/example/edge_iterator_constructor.cpp" )
  compile( "graph/example/edge_property.cpp" )
  compile( "graph/example/exterior_properties.cpp" )
  compile( "graph/example/exterior_property_map.cpp" )
  compile( "graph/example/family_tree.cpp" )
  compile( "graph/example/fibonacci_heap.cpp" )
  compile( "graph/example/file_dependencies.cpp" )
  compile( "graph/example/gerdemann.cpp" )
  compile( "graph/example/graph.cpp" )
  compile( "graph/example/in_edges.cpp" )
  compile( "graph/example/interior_property_map.cpp" )
  compile( "graph/example/johnson.cpp" )
  compile( "graph/example/kevin_bacon.cpp" )
  compile( "graph/example/knights_tour.cpp" )
  compile( "graph/example/kruskal.cpp" )
  compile( "graph/example/max_flow.cpp" )
#  compile( "graph/example/miles_span.cpp" )
  compile( "graph/example/ordered_out_edges.cpp" )
  compile( "graph/example/prim.cpp" )
  compile( "graph/example/quick_tour.cpp" )
  compile( "graph/example/remove_edge_if_bidir.cpp" )
  compile( "graph/example/remove_edge_if_dir.cpp" )
  compile( "graph/example/remove_edge_if_undir.cpp" )
  compile( "graph/example/reverse_graph.cpp" )
  compile( "graph/example/topo_sort.cpp" )
  compile( "graph/example/undirected.cpp" )
  compile( "graph/example/vector_as_graph.cpp" )
  compile( "graph/example/vertex_basics.cpp" )
  compile( "graph/example/visitor.cpp" )
else:
  compile( program_arg )

f.write( "</table>\n" );
if sys.platform == "linux2":
  f.write( "<p>\nNote: A hand-crafted &lt;limits&gt; Standard header has been applied to all configurations.\n" )
f.write( "</body>\n</html>\n" )

# end




