/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalCategoryPlot
extends CategoryPlot
implements VerticalValuePlot {
    public VerticalCategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    public VerticalCategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, double d2, double d3, double d4) {
        super(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer, insets, paint, image, f, stroke, paint2, f2, d, d2, d3, d4);
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.rangeAxis;
    }

    public double getCategoryCoordinate(int n, Rectangle2D rectangle2D) {
        double d = rectangle2D.getX() + rectangle2D.getWidth() * this.introGapPercent;
        int n2 = this.getCategoryDataset().getCategoryCount();
        if (n2 > 1) {
            double d2 = rectangle2D.getWidth() * (1.0 - this.introGapPercent - this.trailGapPercent - this.categoryGapsPercent);
            double d3 = rectangle2D.getWidth() * this.categoryGapsPercent;
            d = d + ((double)n + 0.5) * (d2 / (double)n2) + (double)n * (d3 / (double)(n2 - 1));
        } else {
            d += ((double)n + 0.5) * rectangle2D.getWidth() * (1.0 - this.introGapPercent - this.trailGapPercent);
        }
        return d;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof CategoryAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public boolean isCompatibleDomainAxis(CategoryAxis categoryAxis) {
        if (categoryAxis == null) {
            return true;
        }
        return this.isCompatibleHorizontalAxis(categoryAxis);
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return this.isCompatibleVerticalAxis(valueAxis);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (rectangle2D.getWidth() >= 10.0 && rectangle2D.getHeight() >= 10.0) {
            Object object;
            Rectangle2D rectangle2D2 = rectangle2D;
            if (this.renderer != null) {
                rectangle2D2 = this.renderer.getAxisArea(rectangle2D);
            }
            double d = 0.0;
            if (this.domainAxis != null) {
                HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
                d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D2);
            }
            double d2 = 0.0;
            if (this.rangeAxis != null) {
                object = (VerticalAxis)((Object)this.rangeAxis);
                d2 = object.reserveAxisArea(graphics2D, this, rectangle2D2, d).getWidth();
            }
            object = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX() + d2, rectangle2D2.getY(), rectangle2D2.getWidth() - d2, rectangle2D2.getHeight() - d);
            if (chartRenderingInfo != null) {
                chartRenderingInfo.setDataArea((Rectangle2D)object);
            }
            Object object2 = object;
            if (this.renderer != null) {
                object2 = this.renderer.getDataClipRegion((Rectangle2D)object);
                this.renderer.drawPlotBackground(graphics2D, this, double_, (Shape)object2);
            }
            this.getDomainAxis().draw(graphics2D, rectangle2D2, double_);
            this.getRangeAxis().draw(graphics2D, rectangle2D2, double_);
            if (this.rangeMarkers != null && this.renderer != null) {
                Iterator iterator = this.rangeMarkers.iterator();
                while (iterator.hasNext()) {
                    Marker marker = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, double_, (Shape)object2);
                }
            }
            this.render(graphics2D, double_, chartRenderingInfo, (Shape)object2);
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, Shape shape) {
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            ValueAxis valueAxis;
            Shape shape2 = graphics2D.getClip();
            graphics2D.clip(shape);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            int n = categoryDataset.getSeriesCount();
            this.renderer.initialise(graphics2D, rectangle2D, this, this.getRangeAxis(), categoryDataset, chartRenderingInfo);
            int n2 = 0;
            ValueAxis valueAxis2 = null;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                valueAxis = iterator.next();
                int n3 = 0;
                while (n3 < n) {
                    this.renderer.drawCategoryItem(graphics2D, rectangle2D, this, this.getRangeAxis(), categoryDataset, n3, valueAxis, n2, valueAxis2);
                    ++n3;
                }
                ++n2;
                valueAxis2 = valueAxis;
            }
            valueAxis = this.getRangeAxis();
            if (valueAxis.isCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, valueAxis.getCrosshairValue(), valueAxis.getCrosshairStroke(), valueAxis.getCrosshairPaint());
            }
            graphics2D.setClip(shape2);
            graphics2D.setComposite(composite);
        }
    }

    public String getPlotType() {
        return "Vertical Category Plot";
    }

    public Range getVerticalDataRange() {
        Range range = null;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            range = this.renderer != null && this.renderer.isStacked() ? DatasetUtilities.getStackedRangeExtent(categoryDataset) : DatasetUtilities.getRangeExtent(categoryDataset);
        }
        return range;
    }

    public Number getMinimumVerticalDataValue() {
        Number number = null;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            number = this.renderer.isStacked() ? (Number)DatasetUtilities.getMinimumStackedRangeValue(categoryDataset) : (Number)DatasetUtilities.getMinimumRangeValue(categoryDataset);
        }
        return number;
    }

    public Number getMaximumVerticalDataValue() {
        Number number = null;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            number = this.renderer.isStacked() ? (Number)DatasetUtilities.getMaximumStackedRangeValue(categoryDataset) : (Number)DatasetUtilities.getMaximumRangeValue(categoryDataset);
        }
        return number;
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis = this.getRangeAxis();
        double d = valueAxis.translateJava2DtoValue(n2, chartRenderingInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        valueAxis.setCrosshairValue(d);
    }

    private void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }
}

