/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class StackedVerticalBarRenderer
extends VerticalBarRenderer {
    private boolean linkingLines = false;
    private double[] pointsRegister = null;

    public StackedVerticalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public StackedVerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        super(categoryToolTipGenerator);
    }

    public boolean hasLinkingLines() {
        return this.linkingLines;
    }

    public void setLinkingLines(boolean bl) {
        this.linkingLines = bl;
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Paint paint = categoryPlot.getSeriesPaint(n);
        Paint paint2 = categoryPlot.getSeriesOutlinePaint(n);
        if (this.hasLinkingLines() && this.pointsRegister == null) {
            this.pointsRegister = new double[categoryDataset.getCategoryCount() * categoryDataset.getSeriesCount() * 2];
        }
        double d = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent() + (double)n2 * this.categorySpan / (double)categoryDataset.getCategoryCount();
        if (categoryDataset.getCategoryCount() > 1) {
            d += (double)n2 * this.categoryGapSpan / (double)(categoryDataset.getCategoryCount() - 1);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number = categoryDataset.getValue(n3, object);
            if (number != null) {
                double d4 = number.doubleValue();
                if (d4 > 0.0) {
                    d2 += d4;
                } else {
                    d3 += d4;
                }
            }
            ++n3;
        }
        boolean bl = false;
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            EntityCollection entityCollection;
            Object object3;
            double d5;
            double d6;
            double d7;
            double d8 = number.doubleValue();
            if (d8 > 0.0) {
                d7 = valueAxis.translateValueToJava2D(d2, rectangle2D);
                d6 = valueAxis.translateValueToJava2D(d2 + d8, rectangle2D);
                d5 = Math.min(d7, d6);
                bl = true;
            } else {
                d7 = valueAxis.translateValueToJava2D(d3, rectangle2D);
                d6 = valueAxis.translateValueToJava2D(d3 + d8, rectangle2D);
                d5 = Math.min(d7, d6);
            }
            double d9 = this.itemWidth;
            double d10 = Math.abs(d6 - d7);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d5, d9, d10);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (d9 > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_);
            }
            if (this.hasLinkingLines()) {
                if (n2 == 0) {
                    this.pointsRegister[2 * n] = d + d9;
                    this.pointsRegister[2 * n + 1] = bl ? d5 : d5 + d10;
                } else {
                    double d11;
                    int n4 = n2 * categoryDataset.getSeriesCount() * 2 + 2 * n;
                    this.pointsRegister[n4] = d + d9;
                    if (bl) {
                        d11 = this.pointsRegister[n4 - 2 * categoryDataset.getSeriesCount()];
                        if (d11 > 0.0) {
                            object3 = new Line2D.Double(d, d5, d11, this.pointsRegister[n4 - 2 * categoryDataset.getSeriesCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object3);
                        }
                        this.pointsRegister[n4 + 1] = d5;
                    } else {
                        d11 = this.pointsRegister[n4 - 2 * categoryDataset.getSeriesCount()];
                        if (d11 > 0.0) {
                            object3 = new Line2D.Double(d, d5 + d10, d11, this.pointsRegister[n4 - 2 * categoryDataset.getSeriesCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object3);
                        }
                        this.pointsRegister[n4 + 1] = d5 + d10;
                    }
                }
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = "";
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(categoryDataset, n, object);
                }
                object3 = new CategoryItemEntity(double_, string, string2, n, object, n2);
                entityCollection.addEntity((ChartEntity)object3);
            }
        }
    }

    public boolean isStacked() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return 1;
    }

    public boolean hasItemGaps() {
        return false;
    }
}

