/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.api.RawAccessor;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentUnmarshaller;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.internal.ws.model.CheckedException;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.Mode;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.wsdl.parser.Binding;
import com.sun.xml.internal.ws.wsdl.parser.BindingOperation;
import com.sun.xml.internal.ws.wsdl.parser.Part;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeModel {
    private boolean enableMtom = false;
    private ThreadLocal<BridgeContext> bridgeContext = new ThreadLocal();
    protected JAXBRIContext jaxbContext;
    private String wsdlLocation;
    private QName serviceName;
    private QName portName;
    private QName portTypeName;
    private Map<Method, JavaMethod> methodToJM = new HashMap<Method, JavaMethod>();
    private Map<QName, JavaMethod> nameToJM = new HashMap<QName, JavaMethod>();
    private List<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
    private final Map<TypeReference, Bridge> bridgeMap = new HashMap<TypeReference, Bridge>();
    private final Map<QName, Object> payloadMap = new HashMap<QName, Object>();
    protected final QName emptyBodyName = new QName("");
    private String targetNamespace = "";
    private final Map<Integer, RawAccessor> rawAccessorMap = new HashMap<Integer, RawAccessor>();
    private List<String> knownNamespaceURIs = null;

    public void postProcess() {
        if (this.jaxbContext != null) {
            return;
        }
        this.populateMaps();
        this.populateAsyncExceptions();
        this.createJAXBContext();
        this.createDecoderInfo();
    }

    protected void populateMaps() {
        for (JavaMethod javaMethod : this.getJavaMethods()) {
            this.put(javaMethod.getMethod(), javaMethod);
            for (Parameter parameter : javaMethod.getRequestParameters()) {
                this.put(parameter.getName(), javaMethod);
            }
        }
    }

    protected void populateAsyncExceptions() {
        for (JavaMethod javaMethod : this.getJavaMethods()) {
            int n = javaMethod.getMEP();
            if (n != 4 && n != 3) continue;
            String string = javaMethod.getOperationName();
            Method method = javaMethod.getMethod();
            Class<?>[] classArray = method.getParameterTypes();
            if (n == 4) {
                classArray = new Class[classArray.length - 1];
                System.arraycopy(method.getParameterTypes(), 0, classArray, 0, method.getParameterTypes().length - 1);
            }
            try {
                Method method2 = method.getDeclaringClass().getMethod(string, classArray);
                JavaMethod javaMethod2 = this.getJavaMethod(method2);
                for (CheckedException checkedException : javaMethod2.getCheckedExceptions()) {
                    javaMethod.addException(checkedException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
    }

    public BridgeContext getBridgeContext() {
        if (this.jaxbContext == null) {
            return null;
        }
        BridgeContext bridgeContext = this.bridgeContext.get();
        if (bridgeContext == null) {
            bridgeContext = this.jaxbContext.createBridgeContext();
            bridgeContext.setAttachmentMarshaller(new JAXWSAttachmentMarshaller(this.enableMtom));
            bridgeContext.setAttachmentUnmarshaller(new JAXWSAttachmentUnmarshaller());
            this.bridgeContext.set(bridgeContext);
        }
        return bridgeContext;
    }

    public JAXBRIContext getJAXBContext() {
        return this.jaxbContext;
    }

    public List<String> getKnownNamespaceURIs() {
        return this.knownNamespaceURIs;
    }

    public Bridge getBridge(TypeReference typeReference) {
        return this.bridgeMap.get(typeReference);
    }

    public Object getDecoderInfo(QName qName) {
        Object object = this.payloadMap.get(qName);
        if (object instanceof RpcLitPayload) {
            return RpcLitPayload.copy((RpcLitPayload)object);
        }
        if (object instanceof JAXBBridgeInfo) {
            return JAXBBridgeInfo.copy((JAXBBridgeInfo)object);
        }
        return null;
    }

    public void addDecoderInfo(QName qName, Object object) {
        this.payloadMap.put(qName, object);
    }

    private JAXBRIContext createJAXBContext() {
        final List<TypeReference> list = this.getAllTypeReferences();
        final Class[] classArray = new Class[list.size()];
        final String string = this.targetNamespace;
        int n = 0;
        for (TypeReference object : list) {
            classArray[n++] = (Class)object.type;
        }
        try {
            this.jaxbContext = (JAXBRIContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return JAXBRIContext.newInstance(classArray, list, string, false);
                }
            });
            this.createBridgeMap(list);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new WebServiceException(privilegedActionException.getMessage(), privilegedActionException.getException());
        }
        this.knownNamespaceURIs = new ArrayList<String>();
        for (String string2 : this.jaxbContext.getKnownNamespaceURIs()) {
            if (string2.length() <= 0 || string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/XML/1998/namespace")) continue;
            this.knownNamespaceURIs.add(string2);
        }
        return this.jaxbContext;
    }

    public List<TypeReference> getAllTypeReferences() {
        ArrayList<TypeReference> arrayList = new ArrayList<TypeReference>();
        Collection<JavaMethod> collection = this.methodToJM.values();
        for (JavaMethod javaMethod : collection) {
            this.fillTypes(javaMethod, arrayList);
            this.fillFaultDetailTypes(javaMethod, arrayList);
        }
        return arrayList;
    }

    private void fillFaultDetailTypes(JavaMethod javaMethod, List<TypeReference> list) {
        for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
            list.add(checkedException.getDetailType());
        }
    }

    protected void fillTypes(JavaMethod javaMethod, List<TypeReference> list) {
        this.addTypes(javaMethod.getRequestParameters(), list);
        this.addTypes(javaMethod.getResponseParameters(), list);
    }

    private void addTypes(List<Parameter> list, List<TypeReference> list2) {
        for (Parameter parameter : list) {
            list2.add(parameter.getTypeReference());
        }
    }

    private void createBridgeMap(List<TypeReference> list) {
        for (TypeReference typeReference : list) {
            Bridge bridge = this.jaxbContext.createBridge(typeReference);
            this.bridgeMap.put(typeReference, bridge);
        }
    }

    public Method getDispatchMethod(QName qName) {
        JavaMethod javaMethod;
        if (qName == null) {
            qName = this.emptyBodyName;
        }
        if ((javaMethod = this.getJavaMethod(qName)) != null) {
            return javaMethod.getMethod();
        }
        return null;
    }

    public boolean isKnownFault(QName qName, Method method) {
        JavaMethod javaMethod = this.getJavaMethod(method);
        for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
            if (!checkedException.getDetailType().tagName.equals(qName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckedException(Method method, Class clazz) {
        JavaMethod javaMethod = this.getJavaMethod(method);
        for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
            if (!checkedException.getExcpetionClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public JavaMethod getJavaMethod(Method method) {
        return this.methodToJM.get(method);
    }

    public JavaMethod getJavaMethod(QName qName) {
        return this.nameToJM.get(qName);
    }

    public QName getQNameForJM(JavaMethod javaMethod) {
        Set<QName> set = this.nameToJM.keySet();
        for (QName qName : set) {
            JavaMethod javaMethod2 = this.nameToJM.get(qName);
            if (!javaMethod2.getOperationName().equals(javaMethod.getOperationName())) continue;
            return qName;
        }
        return null;
    }

    public Collection<JavaMethod> getJavaMethods() {
        return Collections.unmodifiableList(this.javaMethods);
    }

    public void addJavaMethod(JavaMethod javaMethod) {
        if (javaMethod != null) {
            this.javaMethods.add(javaMethod);
        }
    }

    public void applyParameterBinding(Binding binding) {
        if (binding == null) {
            return;
        }
        binding.finalizeBinding();
        for (JavaMethod javaMethod : this.javaMethods) {
            Object object;
            if (javaMethod.isAsync()) continue;
            boolean bl = ((SOAPBinding)javaMethod.getBinding()).isRpcLit();
            List<Parameter> list = javaMethod.getRequestParameters();
            List<Parameter> list2 = null;
            for (Parameter parameter : list) {
                ParameterBinding parameterBinding;
                if (parameter.isWrapperStyle()) {
                    if (!bl) continue;
                    object = (WrapperParameter)parameter;
                    BindingOperation bindingOperation = (BindingOperation)binding.get(javaMethod.getOperationName());
                    if (bindingOperation != null && bindingOperation.getRequestNamespace() != null) {
                        this.patchRpclitNamespace(bindingOperation.getRequestNamespace(), (WrapperParameter)object);
                    }
                    list2 = this.applyRpcLitParamBinding(javaMethod, (WrapperParameter)object, binding, Mode.IN);
                    continue;
                }
                object = parameter.getPartName();
                if (object == null || (parameterBinding = binding.getBinding(javaMethod.getOperationName(), (String)object, Mode.IN)) == null) continue;
                parameter.setInBinding(parameterBinding);
            }
            Object object4 = null;
            List<Parameter> object32 = javaMethod.getResponseParameters();
            for (Parameter parameter : object32) {
                Object object2;
                Object object3;
                if (parameter.isWrapperStyle()) {
                    if (!bl) continue;
                    object3 = (WrapperParameter)parameter;
                    object2 = (BindingOperation)binding.get(javaMethod.getOperationName());
                    if (object2 != null && ((BindingOperation)object2).getResponseNamespace() != null) {
                        this.patchRpclitNamespace(((BindingOperation)object2).getResponseNamespace(), (WrapperParameter)object3);
                    }
                    object4 = this.applyRpcLitParamBinding(javaMethod, (WrapperParameter)object3, binding, Mode.OUT);
                    continue;
                }
                object3 = parameter.getPartName();
                if (object3 == null || (object2 = binding.getBinding(javaMethod.getOperationName(), (String)object3, Mode.OUT)) == null) continue;
                parameter.setOutBinding((ParameterBinding)object2);
            }
            if (list2 != null) {
                for (Parameter parameter : list2) {
                    javaMethod.addRequestParameter(parameter);
                }
            }
            if (object4 == null) continue;
            object = object4.iterator();
            while (object.hasNext()) {
                Parameter parameter = (Parameter)object.next();
                javaMethod.addResponseParameter(parameter);
            }
        }
    }

    private void patchRpclitNamespace(String string, WrapperParameter wrapperParameter) {
        TypeReference typeReference = wrapperParameter.getTypeReference();
        TypeReference typeReference2 = new TypeReference(new QName(string, typeReference.tagName.getLocalPart()), typeReference.type, typeReference.annotations);
        wrapperParameter.setTypeReference(typeReference2);
    }

    private List<Parameter> applyRpcLitParamBinding(JavaMethod javaMethod, WrapperParameter wrapperParameter, Binding binding, Mode mode) {
        Object object;
        String string = javaMethod.getOperationName();
        RpcLitPayload rpcLitPayload = new RpcLitPayload(wrapperParameter.getName());
        BindingOperation bindingOperation = (BindingOperation)binding.get(string);
        HashMap<Integer, Parameter> hashMap = new HashMap<Integer, Parameter>();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
        for (Parameter parameter : wrapperParameter.getWrapperChildren()) {
            ParameterBinding parameterBinding;
            object = parameter.getPartName();
            if (object == null || (parameterBinding = binding.getBinding(string, (String)object, mode)) == null) continue;
            if (mode == Mode.IN) {
                parameter.setInBinding(parameterBinding);
            } else if (mode == Mode.OUT) {
                parameter.setOutBinding(parameterBinding);
            }
            if (parameterBinding.isUnbound()) {
                arrayList.add(parameter);
                continue;
            }
            if (parameterBinding.isAttachment()) {
                arrayList2.add(parameter);
                continue;
            }
            if (!parameterBinding.isBody()) continue;
            if (bindingOperation != null) {
                Part part = bindingOperation.getPart(parameter.getPartName(), mode);
                if (part != null) {
                    hashMap.put(part.getIndex(), parameter);
                    continue;
                }
                hashMap.put(hashMap.size(), parameter);
                continue;
            }
            hashMap.put(hashMap.size(), parameter);
        }
        wrapperParameter.clear();
        for (int i = 0; i < hashMap.size(); ++i) {
            Parameter parameter;
            parameter = (Parameter)hashMap.get(i);
            wrapperParameter.addWrapperChild(parameter);
            if ((mode != Mode.IN || !parameter.getInBinding().isBody()) && (mode != Mode.OUT || !parameter.getOutBinding().isBody())) continue;
            object = new JAXBBridgeInfo(this.getBridge(parameter.getTypeReference()), null);
            rpcLitPayload.addParameter((JAXBBridgeInfo)object);
        }
        for (Parameter parameter : arrayList2) {
            object = new JAXBBridgeInfo(this.getBridge(parameter.getTypeReference()), null);
            this.payloadMap.put(parameter.getName(), object);
        }
        for (Parameter parameter : arrayList) {
            wrapperParameter.addWrapperChild(parameter);
        }
        this.payloadMap.put(wrapperParameter.getName(), rpcLitPayload);
        return arrayList2;
    }

    protected void put(QName qName, JavaMethod javaMethod) {
        this.nameToJM.put(qName, javaMethod);
    }

    protected void put(Method method, JavaMethod javaMethod) {
        this.methodToJM.put(method, javaMethod);
    }

    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    public void setWSDLLocation(String string) {
        this.wsdlLocation = string;
    }

    public QName getServiceQName() {
        return this.serviceName;
    }

    public QName getPortName() {
        return this.portName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setServiceQName(QName qName) {
        this.serviceName = qName;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void enableMtom(boolean bl) {
        this.enableMtom = bl;
    }

    public Map<Integer, RawAccessor> getRawAccessorMap() {
        return this.rawAccessorMap;
    }

    protected abstract void createDecoderInfo();
}

