/*************************************************************************
 *
 *  $RCSfile: databases.hxx,v $
 *
 *  $Revision: 1.22.48.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/10/28 11:51:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DATABASES_HXX_
#define _DATABASES_HXX_

#ifndef INCLUDED_STL_SET
#include <set>
#define INCLUDED_STL_SET
#endif
#ifndef INCLUDED_STL_VECTOR
#include <vector>
#define INCLUDED_STL_VECTOR
#endif
#ifndef INCLUDED_STL_HASH_MAP
#include <hash_map>
#define INCLUDED_STL_HASH_MAP
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_XCOLLATOR_HPP_
#include <com/sun/star/i18n/XCollator.hpp>
#endif

// Forward declaration


namespace chelp {
  
  class Db;
  
  class Databases;
  class URLParameter;
	
  class StaticModuleInformation
  {
  private:
		
	rtl::OUString m_aStartId;
	rtl::OUString m_aProgramSwitch;
	rtl::OUString m_aTitle;
	rtl::OUString m_aHeading;
	rtl::OUString m_aFulltext;
	int m_nOrder;
        
		
  public:

	StaticModuleInformation( rtl::OUString aTitle,
							 rtl::OUString aStartId,
							 rtl::OUString aProgramSwitch,
							 rtl::OUString aHeading,
							 rtl::OUString aFulltext,
							 rtl::OUString aOrder )
	  : m_aStartId( aStartId ),
		m_aProgramSwitch( aProgramSwitch ),
		m_aTitle( aTitle ),
		m_aHeading( aHeading ),
		m_aFulltext( aFulltext ),
		m_nOrder( aOrder.toInt32() )
	{
	}
        
	~StaticModuleInformation() { }

	rtl::OUString get_title()     { return m_aTitle; }
	rtl::OUString get_id()        { return m_aStartId; }
	rtl::OUString get_program()   { return m_aProgramSwitch; }
	rtl::OUString get_heading()   { return m_aHeading; }
	rtl::OUString get_fulltext()  { return m_aFulltext; }
	int get_order() { return m_nOrder; }
  };  // end class StaticModuleInformation
	
	

  class KeywordInfo
  {
  public:
		
	class KeywordElement
	{
	  friend struct KeywordElementComparator;
	  friend class KeywordInfo;
			
	public:
			
	  KeywordElement( Databases* pDatabases,
					  Db* pDb,
					  rtl::OUString& key,
					  rtl::OUString& ids );
			
	private:			
            
	  rtl::OUString key;
	  com::sun::star::uno::Sequence< rtl::OUString > listId;
	  com::sun::star::uno::Sequence< rtl::OUString > listAnchor;
	  com::sun::star::uno::Sequence< rtl::OUString > listTitle;

	  void init( Databases *pDatabases,Db* pDb,const rtl::OUString& ids );
	};

		
	KeywordInfo( const std::vector< KeywordElement >& aVector );
        
	~KeywordInfo() { };
		
	com::sun::star::uno::Sequence< rtl::OUString >&
	getKeywordList() { return listKey; }
		
	com::sun::star::uno::Sequence< com::sun::star::uno::Sequence< rtl::OUString > >&
	getIdList() { return listId; }
		
	com::sun::star::uno::Sequence< com::sun::star::uno::Sequence< rtl::OUString > >&
	getAnchorList() { return listAnchor; }
		
	com::sun::star::uno::Sequence< com::sun::star::uno::Sequence< rtl::OUString > >&
	getTitleList() { return listTitle; }
		
  private:
		
	com::sun::star::uno::Sequence< rtl::OUString > listKey;
	com::sun::star::uno::Sequence< com::sun::star::uno::Sequence< rtl::OUString > > listId,listAnchor,listTitle;
  };  // end class KeywordInfo


	
  class Databases
  {
  public:

	struct eq
	{
	  bool operator()( const rtl::OUString& rKey1, const rtl::OUString& rKey2 ) const
	  {
		return rKey1.compareTo( rKey2 ) == 0;
	  }
	};
		
	struct ha
	{
	  size_t operator()( const rtl::OUString& rName ) const
	  {
		return rName.hashCode();
	  }
	};
		
		
	/**
	 *  Input is the installdirectory in system dependent notation
	 */

	Databases( const rtl::OUString& instPath,
			   const rtl::OUString& productName,
			   const rtl::OUString& productVersion,
			   const rtl::OUString& vendorName,
			   const rtl::OUString& vendorVersion,
			   const rtl::OUString& vendorShort,
			   const rtl::OUString& styleSheet,
			   com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > xSMgr );
		
	~Databases();

	rtl::OUString getInstallPathAsSystemPath();
		
	rtl::OUString getInstallPathAsURL();

	rtl::OUString getInstallPathAsURLWithOutEncoding();
		
	// access method to help files

	rtl::OUString getURLMode();
		
	std::vector< rtl::OUString > getModuleList( const rtl::OUString& Language );
		
	StaticModuleInformation* getStaticInformationForModule( const rtl::OUString& Module,
															const rtl::OUString& Language );
		
	KeywordInfo* getKeyword( const rtl::OUString& Module,
							 const rtl::OUString& Language );
		
	Db* getBerkeley( const rtl::OUString& Module,
					 const rtl::OUString& Language,
					 bool helpText = false );
		

	/**
	 *  The following method returns the Collator for the given language-country combination
	 */
		
	com::sun::star::uno::Reference< com::sun::star::i18n::XCollator >
	getCollator( const rtl::OUString& Language,
				 const rtl::OUString& System );   // System not used by current implementation
	//                                            // of XCollator
		
	/**
	 *  Returns a copy of the popupfile
	 */
		
	void popupDocument( URLParameter* urlPar,char **buffer,int *byteCount );


	/**
	 *  Returns a copy of the errordocument for the given language-locale combination
	 */

	void errorDocument( const rtl::OUString& Language,
						char** buffer,
						int* byteCount );
		
		
	/**
	 *  Returns the cascading stlye sheet used to format the HTML-output.
	 *  First try is language directory, second try is main installation directory.
	 */
		
	void cascadingStylesheet( const rtl::OUString& Language,
							  char** buffer,
							  int* byteCount );
		

	/**
	 *  Changes the the stylesheet for further reads.
	 */
		
	void changeCSS(const rtl::OUString& newStyleSheet);


	/**
	 *  Returns the active help text for the given module, language and id.
	 */
		
	void setActiveText( const rtl::OUString& Module,
						const rtl::OUString& Language,
						const rtl::OUString& Id,
						char** buffer,
						int* byteCount );
		
	/**
	 *  Has the purpose of forcing the the jarfile to stay open
	 */
		
	com::sun::star::uno::Reference< com::sun::star::container::XHierarchicalNameAccess >
	jarFile( const rtl::OUString& jar,
			 const rtl::OUString& Language );
		
		
	/**
	 *  Maps a given language-locale combination to language.
	 */
		
	rtl::OUString lang( const rtl::OUString& Language );

		
	/**
	 *  Maps a given language-locale combination to locale.
	 *  The returned string maybe empty
	 */
		
	rtl::OUString country( const rtl::OUString& Language );
		
		
	/**
	 *  Maps a given System to the variant part of a locale.
	 */
		
	rtl::OUString variant( const rtl::OUString& System );
		

	void replaceName( rtl::OUString& oustring ) const;

	rtl::OUString getProductName() const { return m_vReplacement[0]; }
	rtl::OUString getProductVersion() const { return m_vReplacement[1]; }
	rtl::OUString getVendorName() const { return m_vReplacement[2]; }
	rtl::OUString getVendorVersion() const { return m_vReplacement[3]; }
	rtl::OUString getVendorShort() const { return m_vReplacement[4]; }
		
  private:
		
	osl::Mutex                                                                   m_aMutex;
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;

	int    m_nErrorDocLength;
	char*  m_pErrorDoc;

	int    m_nCustomCSSDocLength;
	char*  m_pCustomCSSDoc;
	rtl::OUString m_aCSS;

#define PRODUCTNAME    0
#define PRODUCTVERSION 1
#define VENDORNAME     2
#define VENDORVERSION  3
#define VENDORSHORT    4
	int                    m_vAdd[5];
	rtl::OUString          m_vReplacement[5];
	rtl::OUString          prodName,prodVersion,vendName,vendVersion,vendShort;
		
	rtl::OUString          m_aInstallDirectory;                // Installation directory
	rtl::OUString          m_aInstallDirectoryWithoutEncoding; // a work around for a Sablot bug.
	rtl::OUString          m_aInstallDirectoryAsSystemPath;    // Installation directory
		
	typedef std::hash_map< rtl::OUString,Db*,ha,eq >   DatabasesTable;
	DatabasesTable m_aDatabases;         // Language and module dependent databases
		
	typedef  std::hash_map< rtl::OUString,rtl::OUString,ha,eq > LangSetTable; 
	LangSetTable m_aLangSet;   // Mapping to of lang-country to lang
		
	typedef std::hash_map< rtl::OUString,StaticModuleInformation*,ha,eq > ModInfoTable;
	ModInfoTable m_aModInfo;   // Module information
		
	typedef std::hash_map< rtl::OUString,KeywordInfo*,ha,eq > KeywordInfoTable;
	KeywordInfoTable m_aKeywordInfo;   // Module information

	typedef
	std::hash_map<
	rtl::OUString,
		 ::com::sun::star::uno::Reference< com::sun::star::container::XHierarchicalNameAccess >,
	  ha,
	  eq >         ZipFileTable;
	ZipFileTable m_aZipFileTable;   // No closing of an once opened jarfile

	typedef
	std::hash_map<
	rtl::OUString,
		 ::com::sun::star::uno::Reference< com::sun::star::i18n::XCollator >,
	  ha,
	  eq >      CollatorTable;
	CollatorTable    m_aCollatorTable;
		
		
	// methods 
		
	void setInstallPath( const rtl::OUString& aInstallDirectory );
		
  }; // end class Databases
	
}      // end namespace chelp


#endif
