/*************************************************************************
 *
 *  $RCSfile: fibersrv.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <vos/fibersrv.hxx>
#include <vos/diagnose.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif

VOS_IMPLEMENT_CLASSINFO(VOS_CLASSNAME(OFiberingServer, vos), 
						VOS_NAMESPACE(OFiberingServer, vos), 
						VOS_NAMESPACE(OThread, vos), 0);


OFiberingServer::OFiberingServer() 
{
	create();
}

OFiberingServer::~OFiberingServer() 
{
  // notify run to finish
  terminate();

  // in case run() blocks on getHead(), unblock with an empty ORef
  m_RunningQueue.addTail(ORef<IExecutable>());

  // wait till run() is done
  join();

  // freeze state of server (no more adds or removes)
  m_Lock.acquire();

  // empty running-queue
  while(!m_RunningQueue.isEmpty())
  {
	  m_RunningQueue.removeHead();
  }

  // empty completed-queue
  while(!m_CompletedQueue.isEmpty())
  {
	  m_CompletedQueue.removeHead();
  }

}


void OFiberingServer::add(const ORef<IExecutable>& ref) 
{
	VOS_TRACE("OFiberingServer::add()\n");

	NAMESPACE_VOS(OGuard) Guard(&m_Lock);

	m_RunningQueue.addTail(ref);

	VOS_TRACE("OFiberingServer::addTail done() %d\n", ref->referenced());
}

void OFiberingServer::remove(const ORef<IExecutable>& ref) 
{		
	NAMESPACE_VOS(OGuard) Guard(&m_Lock);
	m_RunningQueue.remove(ref);

}


void OFiberingServer::complete() 
{
	// wait (blocking) for next completed executable
	// if an empty (invalid) executable is returned, 
	// no more executables reside in the server.

	while(getNextCompleted().isValid());
	
}

ORef<IExecutable> OFiberingServer::getNextCompleted() 
{
	m_Lock.acquire();

	// return empty reference if no more executables in server
	if(m_RunningQueue.isEmpty() && m_CompletedQueue.isEmpty()) {
		m_Lock.release();
		return ORef<IExecutable>();
	}

	m_Lock.release();

	// block on queue 
	return m_CompletedQueue.getHead();
	

}

void OFiberingServer::run()
{
	
	while(schedule())
	{
		// get next executable from queue
		ORef<IExecutable> Executable= m_RunningQueue.getHead();

		// BHO HACK race condition with getNextCompleted!!!
		// furthermore blocking during execute
		NAMESPACE_VOS(OGuard) Guard(&m_Lock);

		// if m_RunningQueue unblocked with empty element
		// we are finished
		if(Executable.isEmpty()) {
		    break;
		}
		

		// let it work
		if(Executable->execute())
		{
			// it wants to be called again: place it in the queue again
		    
			m_RunningQueue.addTail(Executable);
		} 
		else 
		{
			// otherwise place it in the completed-queue
			m_CompletedQueue.addTail(Executable);
		}
	}

	VOS_TRACE("OFiberingServer::run() is terminating.\n");
}

