// OpenOfficeHookTrayDlg.cpp : implementation file
//

/*
OOOVirgHook : Hook the keyboard to fix the numerica separator key.
Copyright (C) 2002 - Rmi Peyronnet <remi.peyronnet@via.ecp.fr>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "stdafx.h"
#include "OpenOfficeHookTray.h"
#include "OpenOfficeHookTrayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COpenOfficeHookTrayDlg dialog

COpenOfficeHookTrayDlg::COpenOfficeHookTrayDlg(CWnd* pParent /*=NULL*/)
	: CTrayDialog(COpenOfficeHookTrayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COpenOfficeHookTrayDlg)
	m_ActClass = FALSE;
	m_ActExe = FALSE;
	m_ActTitle = FALSE;
	m_ActAll = FALSE;
	m_strClassName = _T("");
	m_strExeName = _T("");
	m_strTitre = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_OOO_VIRG);

	CString str;

	str.LoadString(IDS_TITLE);
	TraySetIcon(IDR_OOO_VIRG);
	TraySetToolTip(str);
	TraySetMenu(IDR_MENU1);

	hookRegistered = false;

	RegisterHook();
}

COpenOfficeHookTrayDlg::~COpenOfficeHookTrayDlg()
{
	UnregisterHook();
}

void COpenOfficeHookTrayDlg::DoDataExchange(CDataExchange* pDX)
{
	CTrayDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COpenOfficeHookTrayDlg)
	DDX_Control(pDX, IDC_TEXT_ABOUT, m_TextAboutControl);
	DDX_Control(pDX, IDC_STATIC_TITLE, m_TitleControl);
	DDX_Check(pDX, IDC_ACT_CLASS, m_ActClass);
	DDX_Check(pDX, IDC_ACT_EXE, m_ActExe);
	DDX_Check(pDX, IDC_ACT_TITLE, m_ActTitle);
	DDX_Check(pDX, IDC_ALLWINDOWS, m_ActAll);
	DDX_Text(pDX, IDC_EDIT_CLASSNAME, m_strClassName);
	DDX_Text(pDX, IDC_EDIT_EXENAME, m_strExeName);
	DDX_Text(pDX, IDC_EDIT_TITRE, m_strTitre);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COpenOfficeHookTrayDlg, CTrayDialog)
	//{{AFX_MSG_MAP(COpenOfficeHookTrayDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_SHOW, OnCmdTrayShow)
	ON_BN_CLICKED(IDC_ACTIVATE, OnActivate)
	ON_BN_CLICKED(IDC_DESACTIVATE, OnDesactivate)
	ON_BN_CLICKED(IDC_SAVE_SETTINGS, OnSaveSettings)
	ON_COMMAND(ID_ACTIVATE, OnActivate)
	ON_COMMAND(ID_DESACTIVATE, OnDesactivate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenOfficeHookTrayDlg message handlers

BOOL COpenOfficeHookTrayDlg::OnInitDialog()
{
	CFont * font;
	CTrayDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Code to start in Tray mode
	ShowWindow(SW_MINIMIZE);
	PostMessage(WM_SYSCOMMAND, SC_MINIMIZE); 
	//TrayShow();

	// Title
	font = new CFont();
	font->CreateFont(
		   20,                        // nHeight
		   0,                         // nWidth
		   0,                         // nEscapement
		   0,                         // nOrientation
		   FW_NORMAL,                 // nWeight
		   TRUE,                      // bItalic
		   FALSE,                     // bUnderline
		   0,                         // cStrikeOut
		   ANSI_CHARSET,              // nCharSet
		   OUT_DEFAULT_PRECIS,        // nOutPrecision
		   CLIP_DEFAULT_PRECIS,       // nClipPrecision
		   DEFAULT_QUALITY,           // nQuality
		   DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
		   "Times New Roman");        // lpszFacename
	m_TitleControl.SetFont(font);
	m_TitleControl.SetWindowText("Virgule sous OpenOffice.org.");

	m_TextAboutControl.SetWindowText(
		"Ce programme a pour but de remplacer dans le tableur de OpenOffice.org " \
		"le sparateur dcimal par une virgule : ceci est utile pour les versions " \
		"franaises de OpenOffice.org, pour pouvoir entrer facilement des nombres " \
		"dcimaux avec le pav numrique.\r\n" \
		"Ce programme doit rester actif et tre lanc  chaque dmarrage. Vous pouvez " \
		"configurer son comportement avec les options ci-dessous." \
		"\r\n\r\n(C) 2003 - Rmi Peyronnet - Freeware - http://www.via.ecp.fr/~remi");

	readSettings();
	UpdateData(FALSE);

	return FALSE;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COpenOfficeHookTrayDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CTrayDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COpenOfficeHookTrayDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void COpenOfficeHookTrayDlg::OnCmdTrayShow() 
{
	// TODO: Add your command handler code here
	TrayHide();
	//PostMessage(WM_SYSCOMMAND, SC_MINIMIZE); 
	//ShowWindow(SW_RESTORE);
	ShowWindow(SW_SHOWNORMAL);
}


void COpenOfficeHookTrayDlg::OnTrayLButtonDblClk(CPoint pt)
{
	OnCmdTrayShow();
}


void COpenOfficeHookTrayDlg::RegisterHook()
{
	// This is the method with a separate DLL 
	if (hookRegistered) return;

	hinstDLL = LoadLibrary((LPCTSTR) "OOVirgHook.dll"); 
	//hinstDLL = LoadLibrary((LPCTSTR) "../OOVirgHook/Debug/OOVirgHook.dll"); 
	if (!hinstDLL)
	{
		MessageBox("DLL OOVirgHook.dll not found !","DLL not found", MB_ICONSTOP + MB_OK);
		return;
	}
	hkprcSysMsg = (HOOKPROC)GetProcAddress(hinstDLL,"_KeyboardProc@12"); 
	hhookSysMsg = SetWindowsHookEx(WH_KEYBOARD,  hkprcSysMsg, hinstDLL, 0); 

	// This is the method with the KeyboardProc inside (but valid only for the current thread...)
	/*
	hkprcSysMsg = (HOOKPROC)&KeyboardProc;
	hhookSysMsg = SetWindowsHookEx(WH_KEYBOARD,  hkprcSysMsg,(HINSTANCE) NULL, GetCurrentThreadId()); 
	*/

	hookRegistered = true;
}

void COpenOfficeHookTrayDlg::UnregisterHook()
{
	if (!hookRegistered) return;
	UnhookWindowsHookEx(hhookSysMsg);
	FreeLibrary(hinstDLL);
	hookRegistered = 0;
}

char iniFile[] = "hook.ini";

void COpenOfficeHookTrayDlg::readSettings()
{
	char tempStr[256];

	m_ActAll = GetPrivateProfileInt("Config", "allWindows", 0, iniFile);
	
	m_ActTitle = GetPrivateProfileInt("Config", "useTitle", 1, iniFile);
	m_ActClass = GetPrivateProfileInt("Config", "useClassName", 0, iniFile);
	m_ActExe = GetPrivateProfileInt("Config", "useExeName", 0, iniFile);

	GetPrivateProfileString("Config","strClassNameTrigger", "OpenOffice", tempStr, 255, iniFile);
	m_strClassName = tempStr;
	GetPrivateProfileString("Config","strExeNameTrigger", "soffice.exe", tempStr, 255, iniFile);
	m_strExeName = tempStr;
	GetPrivateProfileString("Config","strTitleTrigger", "OpenOffice", tempStr, 255, iniFile);
	m_strTitre = tempStr;

}

void COpenOfficeHookTrayDlg::saveSettings()
{
	WritePrivateProfileString("Config", "strClassNameTrigger", m_strClassName, iniFile);
	WritePrivateProfileString("Config", "strExeNameTrigger", m_strExeName, iniFile);
	WritePrivateProfileString("Config", "strTitleTrigger", m_strTitre, iniFile);
	WritePrivateProfileString("Config", "allWindows", (m_ActAll)?"1":"0", iniFile);
	WritePrivateProfileString("Config", "useTitle", (m_ActTitle)?"1":"0", iniFile);
	WritePrivateProfileString("Config", "useClassName", (m_ActClass)?"1":"0", iniFile);
	WritePrivateProfileString("Config", "useExeName", (m_ActExe)?"1":"0", iniFile);
}

void COpenOfficeHookTrayDlg::OnActivate() 
{
	RegisterHook();
}

void COpenOfficeHookTrayDlg::OnDesactivate() 
{
	UnregisterHook();
}

void COpenOfficeHookTrayDlg::OnSaveSettings() 
{
	UpdateData(TRUE);
	saveSettings();
	UnregisterHook();
	RegisterHook();
	MessageBox("Les changements seront effectifs au prochain dmarrage de l'application ou de Windows.","Avertissement", MB_OK + MB_ICONINFORMATION);
}
