/*************************************************************************
 *
 *  $RCSfile: macexchg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>

#include <mac_start.h>
#include <Types.h>
#include <Memory.h>
#include <mac_end.h>

#include <exchange.hxx>
#include <sysexchg.hxx>
#include <getsys.hxx>

#ifndef _NEW_HXX
#include <tools/new.hxx>
#endif

#include <salinst.hxx>
#include <salctype.hxx>
#include <saldata.hxx>

#include <macexchg.hxx>

//==================================================================================================
// FormatItem
//==================================================================================================

FormatItem::FormatItem(const String &rName, UINT32 nFormatID) :
	mnFormatID(nFormatID),
	maFormatName(rName)
{
}

//==================================================================================================
// XMacExchange
//==================================================================================================

// Eigentlich sollte diese Klasse die Formate rewgistrieren und am System anmelden
// (letzteres duerfte auf dem Mac etwas schwierig werden), aber da die Format-ID
// angeblich dynamisch vergeben werden, und z.Z. vor einem Paste nicht registriert
// werden, macht das wenig sinn, selbst dann nicht, wenn die Format-Informationen
// persistent gespeichert wrden.
// Wie kann z.B. der Writer ein Format mit der ID 42 anfordern, wenn diese ID zur
// Laufzeit des Office vergeben wird, und "Star Writer 4.0 Dokument" noch nicht 
// registriert wurde???
// Offensichtlich scheint es da doch eine feste Verdrahtung der Typen zu geben!
// Lassen wir uns ueberraschen...

//**************************************************************************************************
//    XMacExchange::theExchange
//**************************************************************************************************

// Die Instance des Interfaces

XMacExchange XMacExchange::theExchange;

//**************************************************************************************************
//    XMacExchange::CTOR
//**************************************************************************************************

XMacExchange::XMacExchange() :
	FormatList(),
	XSystemExchange()
{
}

//**************************************************************************************************
//    XMacExchange::DTOR
//**************************************************************************************************

XMacExchange::~XMacExchange()
{
    FormatItem* pItem = First();
    while( pItem )
    {
        delete pItem;
        pItem = Next();
    }
}

//**************************************************************************************************
//    XMacExchange::registerFormatName
//**************************************************************************************************

void XMacExchange::registerFormatName(const String &rFormatName, UINT32 nFormatID)
{
	FormatItem *pItem = new FormatItem(rFormatName, nFormatID);
	Insert(pItem, LIST_APPEND);
}

//**************************************************************************************************
//    XMacExchange::findItem
//**************************************************************************************************

const FormatItem *XMacExchange::findItem(const String &rFormatName, UINT32 nFormatID)
{
	BOOL	bFindName = (BOOL)(rFormatName != "");
	BOOL	bFindFormatID = (BOOL)(nFormatID != FORMAT_NONE);

	if (!bFindName && !bFindFormatID)
		return NULL;
		
    FormatItem* pItem = First();
	FormatItem* pFound = NULL;
	
    while( pItem && !pFound)
    {
		BOOL	bFoundName = (BOOL)(!bFindName || rFormatName == pItem->maFormatName);
		BOOL	bFoundFormatID = (BOOL)(!bFindFormatID || nFormatID == pItem->mnFormatID);

		if (bFoundName && bFoundFormatID)
			pFound = pItem;
			
        pItem = Next();
    }
	
	return pFound;
}

//**************************************************************************************************
//    GetSystemExchange   (SYSEXCHG.HXX in VCL/INC)
//**************************************************************************************************

XSystemExchange* GetSystemExchange()
{
	// Die Instanz des Exchange-Interfaces liefern
	return &XMacExchange::theExchange;
}


// Die folgenden Funktionen sind Tools, die sowohl vom Drag & Drop als auch vom
// Clipboard benoetigt werden.

//**************************************************************************************************
//    HasFormat
//**************************************************************************************************

// Prft an einen XDTrans-Interface, ob ein bestimmtes Format vorhanden ist

BOOL HasFormat(XDTrans *pInterface, UINT32 nFormat)
{
	BOOL	bHasFormat = FALSE;
	UINT32	nTypeList, *pTypeList = pInterface->getTypeList(nTypeList);
	
	if (pTypeList)
	{
		for (UINT32 n = 0; n < nTypeList && !bHasFormat; n++)
			bHasFormat = (BOOL)(pTypeList[n] == nFormat);
		delete pTypeList;
	}
		
	return bHasFormat;
}


//**************************************************************************************************
//    GetPathFromDirID
//**************************************************************************************************

// Liefert aus einer dirID einen completten Pfad

#ifndef _MAX_PATH
#define _MAX_PATH			512
#endif

OSErr GetPathFromDirID( long DirID, short VRefNum, char *pPath )
{
	CInfoPBRec	paramBlock;
	Str255		dirName; 	// Pascal string
	int			len;
	OSErr		err;
	
	*pPath = '\0';
	len = 0;
	
	paramBlock.dirInfo.ioNamePtr = dirName;
	paramBlock.dirInfo.ioDrParID = DirID;
	
	do { 
		paramBlock.dirInfo.ioVRefNum = VRefNum;
		paramBlock.dirInfo.ioFDirIndex = -1;
		paramBlock.dirInfo.ioDrDirID = paramBlock.dirInfo.ioDrParID;
		
		err = PBGetCatInfoSync( &paramBlock );
		
		if (err == noErr)
		{
			if ( len + 1 + dirName[0] + 1 > _MAX_PATH )
				err = -1;
			else
			{
				memmove( pPath + dirName[0] + 1, pPath, len + 1 );
				memcpy( pPath, &dirName[1], dirName[0] );
				pPath[ dirName[0] ] = ':';
				len += dirName[0] + 1;
			}		
		}
	} while ( ( err == noErr ) && ( paramBlock.dirInfo.ioDrDirID != fsRtDirID ) );
	
	return err;
}


//**************************************************************************************************
//    MakeHFSFlavor
//**************************************************************************************************

// Erzeugt aus einem Pfadnamen einen HFS-Typ fr den Finder

HFSFlavor *MakeHFSFlavor(const char *pszPathName)
{
	HFSFlavor	*pHFSData = new HFSFlavor;
	Str255		spPathName;

	if (pHFSData)
	{
		pHFSData->fileType = 0;
		pHFSData->fileCreator = 0;
		pHFSData->fdFlags = 0;
		spPathName[0] = strlen(pszPathName);
		memcpy(&spPathName[1], pszPathName, spPathName[0]);
		
		
		FSMakeFSSpec(0, 0, spPathName, &pHFSData->fileSpec);
	}
	
	return pHFSData;
}

//**************************************************************************************************
//    ConvertResType2Format
//**************************************************************************************************

// Konvertiert (fall moeglich) eine Mac-Resource in ein Office-format

BYTE *ConvertResType2Format(ResType theResType, UINT32 nFormat, const BYTE *pData, UINT32 nSize, UINT32 &rSize)
{
	BYTE	*pNewData = NULL;
	
	rSize = 0;
	
	// Text in NULL-terminierten C-String umwandeln
	
	if (theResType == MAC_FORMAT_TEXT && nFormat == FORMAT_STRING)
	{
		pNewData = new BYTE[nSize + 1];
		if (pNewData)
		{
			memcpy(pNewData, pData, nSize);
			pNewData[nSize] = 0;
			rSize = nSize + 1;
		}
	}
	
	// HTML wird native uebernommen
	
	else if (theResType == MAC_FORMAT_HTML && nFormat == FORMAT_HTML)
	{
		pNewData = new BYTE[nSize];
		if (pNewData)
		{
			rSize = nSize;
			memcpy(pNewData, pData, rSize);
		}
	}
	
	// RTF wird native uebernommen
	
	else if (theResType == MAC_FORMAT_RTF && nFormat == FORMAT_RTF)
	{
		pNewData = new BYTE[nSize];
		if (pNewData)
		{
			rSize = nSize;
			memcpy(pNewData, pData, rSize);
		}
	}
	
	// PICT in GDIMetafile oder Bitmap umwandeln
	
	else if (theResType == MAC_FORMAT_PICT)
	{
		ULONG			cvtFormat;
		
		switch (nFormat)
		{
			case FORMAT_BITMAP:
				cvtFormat = CVT_BMP;
				break;
			case FORMAT_GDIMETAFILE:
				cvtFormat = CVT_SVM;
				break;
			default:
				return NULL;
		}
		
		SALGRFCVTPROC	pFnc = (SALGRFCVTPROC) GetSalData()->mpFirstInstance->maInstData.mpFilterCallback;
		
		if (pFnc == NULL)
			return NULL;

		void*	pFilterInst = GetSalData()->mpFirstInstance->maInstData.mpFilterInst;

		if (pFilterInst == NULL)
			return NULL;

		// Das PICT mu vor der Konvertierung noch einen 512 Byte grossen Header bekommen,
		// was da drin steht ist aber egal.
		
		UINT32	nPictBufSize = nSize + 512;
		BYTE*	pPictBuf = new BYTE[nPictBufSize];
		BYTE*	pOutBuf = NULL;
		
		if (pPictBuf == NULL)
			return NULL; 
			
		memcpy(&pPictBuf[512], pData, nSize);
		
		ULONG nOutSize = pFnc(pFilterInst, CVT_PCT, pPictBuf, nPictBufSize, cvtFormat, (void**)&pOutBuf);
		
		delete pPictBuf;
		
		if (pOutBuf)
		{
			pNewData = new BYTE[nOutSize];
			
			if (pNewData)
			{
				rSize = nOutSize;
				memcpy(pNewData, pOutBuf, rSize);
			}
			
			SvMemFree( pOutBuf );
		}
	}
	
	// HFS in C-String umwandeln
	
	else if (theResType == MAC_FORMAT_FILE && nFormat == FORMAT_FILE)
	{
		const HFSFlavor	*pHFSData = (const HFSFlavor *)pData;
		char			szDirName[_MAX_PATH];
		int				len;
		
		GetPathFromDirID( pHFSData->fileSpec.parID, pHFSData->fileSpec.vRefNum, szDirName );

		len = strlen(szDirName);		
		pNewData = new BYTE[len + pHFSData->fileSpec.name[0] + 1];
		if (pNewData)
		{
			strcpy((char *)pNewData, szDirName);
			memcpy(&pNewData[len], &pHFSData->fileSpec.name[1], pHFSData->fileSpec.name[0]);
			rSize = len + pHFSData->fileSpec.name[0];
			pNewData[rSize++] = 0;
		}
	}
	
	return pNewData;
}


//**************************************************************************************************
//    ConvertFormat2ResType
//**************************************************************************************************

// Konvertiert (fall moeglich) ein Office-format in eine Mac-Resource

BYTE *ConvertFormat2ResType(UINT32 nFormat, ResType theResType, const BYTE *pData, UINT32 nSize, UINT32 &rSize)
{
	BYTE	*pNewData = NULL;
	
	rSize = 0;
	
	// C-String nach Text
	
	if (theResType == MAC_FORMAT_TEXT && nFormat == FORMAT_STRING)
	{
		String	aString((const char *)pData);
		
		aString.ConvertLineEnd();
		pNewData = new BYTE[aString.Len()];
		if (pNewData)
		{
			rSize = aString.Len();
			memcpy(pNewData, (const char *)aString, rSize);
		}
	}
	
	// HTML wird native uebernommen
	
	else if (theResType == MAC_FORMAT_HTML && nFormat == FORMAT_HTML)
	{
		pNewData = new BYTE[nSize];
		if (pNewData)
		{
			rSize = nSize;
			memcpy(pNewData, pData, rSize);
		}
	}
	
	// RTF wird native uebernommen
	
	else if (theResType == MAC_FORMAT_RTF && nFormat == FORMAT_RTF)
	{
		pNewData = new BYTE[nSize];
		if (pNewData)
		{
			rSize = nSize;
			memcpy(pNewData, pData, rSize);
		}
	}
	
	// Bitmap oder GDIMetafile nach PICT
	
	else if (theResType == MAC_FORMAT_PICT)
	{
		ULONG			cvtFormat;
		
		switch (nFormat)
		{
			case FORMAT_BITMAP:
				cvtFormat = CVT_BMP;
				break;
			case FORMAT_GDIMETAFILE:
				cvtFormat = CVT_SVM;
				break;
			default:
				return NULL;
		}
		
		SALGRFCVTPROC	pFnc = (SALGRFCVTPROC) GetSalData()->mpFirstInstance->maInstData.mpFilterCallback;
		
		if (pFnc == NULL)
			return NULL;

		void*	pFilterInst = GetSalData()->mpFirstInstance->maInstData.mpFilterInst;

		if (pFilterInst == NULL)
			return NULL;

		BYTE*	pOutBuf = NULL;
		
		ULONG nOutSize = pFnc(pFilterInst, cvtFormat, (BYTE *)pData, nSize, CVT_PCT, (void**)&pOutBuf);
		
		if (pOutBuf)
		{
			// Den 512 Byte Header des PICT brauchen wir nicht
			
			pNewData = new BYTE[nOutSize-512];
			
			if (pNewData)
			{
				rSize = nOutSize - 512;
				memcpy(pNewData, &pOutBuf[512], rSize);
			}
			
			SvMemFree( pOutBuf );
		}
		
	}
	
	// C-String nach HFS
	
	else if (theResType == MAC_FORMAT_FILE && nFormat == FORMAT_FILE)
	{
		pNewData = (BYTE *)MakeHFSFlavor((const char *)pData);
		if (pNewData)
			rSize = sizeof(HFSFlavor);
	}
	return pNewData;
}


