/*************************************************************************
 *
 *  $RCSfile: salsound.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_SALSOUND_CXX

// ------------
// - Includes -
// ------------

#ifndef _SVMAC_H
#include <svmac.h>
#endif
#ifndef _SV_SALSOUND_HXX
#include <salsound.hxx>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif

#include <salstype.hxx>

#define SOUND_BUFFERSIZE 30720

FilePlayCompletionUPP 	SalSound::pFilePlayCompletion;

pascal void ImplSoundCallback(SndChannelPtr pChannel)
{
	SalSound	*pSound = (SalSound *)pChannel->userInfo;
	
	if (pSound && pSound->mpNotifyProc)
	{
		SoundNotification	eNotification = SOUND_NOTIFY_SUCCESS;
		ULONG				nError = SOUNDERR_SUCCESS;
		
		pSound->mpNotifyProc(pSound->mpNotifyInst, eNotification, nError);
	}
}

// ------------
// - SalSound -
// ------------

SalSound::SalSound() :
	mnFileRefNum(-1),
	mnResourceID(-1)
{
}

// ------------------------------------------------------------------------

SalSound::~SalSound()
{
	if (mnFileRefNum)
		FSClose(mnFileRefNum);
		
	SndDisposeChannel(&maSoundChannel,TRUE);
}

// ------------------------------------------------------------------------

BOOL SalSound::Create()
{
	memset(&maSoundChannel,0,sizeof(SndChannel));
	
	SndChannelPtr pChannel = &maSoundChannel;
	
	maSoundChannel.qLength = stdQLength;
	maSoundChannel.userInfo = (long)this;
	
 	return (BOOL)(noErr == SndNewChannel(&pChannel,sampledSynth,0,NULL));
}

// ------------------------------------------------------------------------

void SalSound::Release()
{
	DisposeRoutineDescriptor(pFilePlayCompletion);
}

// ------------------------------------------------------------------------

BOOL SalSound::IsValid()
{
	pFilePlayCompletion = NewFilePlayCompletionProc(ImplSoundCallback);
	return TRUE;
}

// ------------------------------------------------------------------------

BOOL SalSound::Init( SalFrame* pFrame, const String& rSoundName, ULONG& rSoundLen )
{
	FSSpec	aFSSpec;
	OSErr	error;
	Str255	spName;

// An empty soundname indicates that the file handle should be released

	if (rSoundName.Len() == 0)
	{
		if (mnFileRefNum)
			FSClose(mnFileRefNum);
		mnFileRefNum = 0;
	}
	
// Create a MAC File System Specifier from the given PathName
//	error = FSMakeFSSpec(0, 0, rSoundName.GetPascalStr(), &aFSSpec);

	spName[0] = rSoundName.Len();
	strcpy((char *)&spName[1], (const char *)rSoundName);
	error = FSMakeFSSpec(0, 0, spName, &aFSSpec);

	
	if (error == noErr)
	{
		short nOldResFile = CurResFile();
		
		// Try to open the resource fork
		mnFileRefNum = FSpOpenResFile(&aFSSpec,fsRdPerm);
		if (mnFileRefNum >= 0)
		{
		// Prevent resource manager from reading reesource into memory
			SetResLoad(FALSE);	
		// Get a handle to the sound resource if any
			Handle 	hSound = GetIndResource('snd ',1);
			Str255 	aDummyName;
			ResType aDummyType;
			
			GetResInfo(hSound,&mnResourceID,&aDummyType, aDummyName);
			
			ReleaseResource(hSound);
		// Enable loading of resources into memory
			SetResLoad(TRUE);	
		}
		else	// use the data fork (AIFF-File)
		{
			error = FSpOpenDF(&aFSSpec, fsRdWrPerm, &mnFileRefNum);
			mnResourceID = -1;
		}
	}

	rSoundLen = SOUND_PLAYALL;
	return (BOOL)(noErr == error);
}

// ------------------------------------------------------------------------

BOOL SalSound::Init( SalFrame* pFrame, const BYTE* pSound, ULONG nDataLen, ULONG& rSoundLen )
{
// Currently not supported because we don't know anything about the format of the sound in the buffer
	return FALSE;
}

// ------------------------------------------------------------------------

void SalSound::Play( ULONG nStartTime, ULONG nPlayLen, BOOL bLoop )
{
	OSErr	error = noErr;

	if (error == noErr)
	{
		AudioSelection	aSelection;
		
		if (nPlayLen == SOUND_PLAYALL)
		{
			aSelection.unitType = unitTypeNoSelection;
			aSelection.selStart = (nStartTime << 16) / 1000L;
			aSelection.selEnd = 0x7FFFFFFFL;
		}
		else
		{
			ULONG	nEndTime = nStartTime + nPlayLen;
			aSelection.unitType = unitTypeSeconds;
			aSelection.selStart = (nStartTime << 16) / 1000L;
			aSelection.selEnd = (nEndTime << 16) / 1000L;
		}
		
		if (mnResourceID >= 0)
		{
			short nOldResFile = CurResFile();
		
			UseResFile(mnFileRefNum);
			error = SndStartFilePlay(&maSoundChannel, 0, mnResourceID, SOUND_BUFFERSIZE, NULL, &aSelection, pFilePlayCompletion, TRUE);
			
			UseResFile(nOldResFile);
		}
		else
			error = SndStartFilePlay(&maSoundChannel, mnFileRefNum, 0, SOUND_BUFFERSIZE, NULL, &aSelection, pFilePlayCompletion, TRUE);
	}
}

// ------------------------------------------------------------------------

void SalSound::Stop()
{
	SndStopFilePlay(&maSoundChannel, TRUE);
}

// ------------------------------------------------------------------------

void SalSound::Pause()
{
	SndPauseFilePlay(&maSoundChannel);
}


void SalSound::SetNotifyProc( void* pInst, SALSOUNDPROC pProc )
{
	mpNotifyProc = pProc;
	mpNotifyInst = pInst;
}

