/*************************************************************************
 *
 *  $RCSfile: main.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* kSysEnvironsVersion is passed to SysEnvirons to tell it which version of the
   SysEnvRec we understand. */
#define	kSysEnvironsVersion		1

/* The following are indicies into STR# resources. (AlertUser) */
#define	eWrongMachine			1
#define	eNopApp					2
#define	eWrongSystem			3
#define	eNoASLM					4
#define	eNoPPC					5
#define	eStarDivFolder			6	// Something like "Star Division"

#define	rMenuBar	128				/* application's menu bar */
#define	rAboutAlert	128				/* about alert */
#define	rUserAlert	129				/* user error alert */
#define	rQuit		130				/* Quit dialog */
#define	rDocWindow	128				/* application's window */
#define	rVScroll	128				/* vertical scrollbar control */
#define	rHScroll	129				/* horizontal scrollbar control */
#define	kErrStrings	128				/* error string list */

// -----------------------------------------------------------------------

extern BOOL		bMacMemInit;

// -----------------------------------------------------------------------

extern void	AlertUser(short error);
extern void	AlertUser(ConstStr255Param pString);

extern void InitSystem();

extern int MenuDispatch(short menuNumber,short itemNumber);

// -----------------------------------------------------------------------

class SalFrame;

extern int main ( int argc, char * argv[] );

extern BOOL SV_EventLoop();

extern long ImplHandleMouseMsg( EventRecord *pEvent, WindowPtr pMacWin );
extern long ImplHandleMouseMsg( EventRecord *pEvent, SalFrame* pFrame );
extern long ImplHandleKeyMsg( EventRecord *pEvent, SalFrame* pFrame );
extern void ImplHandlePaintMsg( WindowPtr pMacWin );
extern void ImplHandlePaintMsg( SalFrame* pFrame );
extern void ImplHandleSizeMsg( WindowPtr pMacWin );
extern long ImplHandleSizeMsg( SalFrame* pFrame, INT16 nWidth, INT16 nHeight );
extern long ImplHandleFocusMsg( SalFrame* pFrame, BOOL bGetFocus );
extern long ImplHandleCloseMsg( SalFrame* pFrame );
extern long ImplHandleShutDownMsg( void );
extern long ImplHandleSettingsChangeMsg( USHORT nSalSettingsEvent );
extern void ImplHandleUserEvent( SalFrame* pFrame, void* pEventData );
extern void Impl_DoZoom( EventRecord *pEvent, WindowPtr pMacWin, int part );
extern SalFrame * ImplGetFrameFromMacWin( WindowPtr pMacWin );

extern String ImplGetMacResString( short nWhich );

// -----------------------------------------------------------------------

extern void DoMemoryException ( void );

// -----------------------------------------------------------------------

void Mac_StartPresentationMode( const SalFrame* pFrame, USHORT nFlags );
void Mac_EndPresentationMode( void );
BOOL Mac_IsPresentationMode();

// -----------------------------------------------------------------------

