/*************************************************************************
 *
 *  $RCSfile: svunzip.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: willem.vandorp $ $Date: 2000/09/29 14:33:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <unzip.h>
#include <svunzip.h>

#ifdef ZTC
	void SV_Init_extract();
	void SV_Init_file_io();
	void SV_Init_unzip();
#endif

extern UnzipCallBack          *pCallBack;
extern UnzipEnumFilesCallBack *pEnumFilesCallBack;
extern void                   *pEnumFilesExtraData;
extern ULONG 				   crc32val;


/*************************************************************************/

ULONG getCRC32( const char* pZipFilePath )
{
	if( SVUnzip(pZipFilePath, "*", "t", NULL) == 0 )
		return crc32val;
	return 0;
}

/*************************************************************************
|*
|*    SVUnzip
|*
|*    Beschreibung
|*    Ersterstellung    CL 23.11.93
|*    Letzte Aenderung  CL 23.11.93
|*
*************************************************************************/
int SVUnzip( const char* pZipFilePath, const char* pDestPath,
			 const char* pFlags, UnzipCallBack *pCallBackFunc )
{
	int ret;
	char sDestPath[256];
	strcpy (sDestPath, pDestPath);

	/* reinit of globals from zipinfo.c */
	SV_Init_extract();
	SV_Init_file_io();
	SV_Init_unzip();

	/* register a callback function */
	pCallBack = pCallBackFunc;

	/* Finden wir das ZIP-File ueberhaupt ? */
    strcpy( zipfn, pZipFilePath );
    if( stat( zipfn, &statbuf ) || (statbuf.st_mode & S_IFMT) == S_IFDIR)
        strcat( zipfn, ".zip" );
    if( stat( zipfn, &statbuf) )
        return 1001;  /* Datei nicht gefunden */
    else
        ziplen = statbuf.st_size;

	fnames[0] = sDestPath;

	/* Flags auswerten */
	if( pFlags )
	{
		if( strchr( pFlags, 'c' ) )
			cflag = TRUE;
		if( strchr( pFlags, 'd' ) )
			jflag = TRUE;
		if( strchr( pFlags, 'f' ) )
			fflag = uflag = TRUE;
		if( strchr( pFlags, 'j' ) )
			jflag = TRUE;
		if( strchr( pFlags, 'n' ) )
			overwrite_none = TRUE;
		if( strchr( pFlags, 'o' ) )
		{
			overwrite_all++;
			force_flag++;
		}
		if( strchr( pFlags, 'q' ) )
		{
			quietflg++;
			if( strchr( pFlags, 'q' ) != strrchr( pFlags, 'q' ) )
				quietflg++;
		}
   		if( strchr( pFlags, 't' ) )
			tflag = TRUE;
		if( strchr( pFlags, 'u' ) )
			uflag = TRUE;
		if( strchr( pFlags, 'v' ) ) /* list verbose */
			vflag = TRUE;
		if( strchr( pFlags, 'y' ) ) /* append to files */
			yflag = TRUE;
	}

	matched = (!(pDestPath && *pDestPath));

    inbuf = (byte*)(malloc(INBUFSIZ+4));
    outbuf= (byte*)(malloc(OUTBUFSIZ+1));

    outout = outbuf;

    if( !inbuf || !outbuf )
		return 1002;

    hold = &inbuf[INBUFSIZ];

    ret = process_zipfile();
	return (ret || matched) ? ret : 1111;
}

int SVUnzipEnumFiles
(
    const char              *pZipFilePath,
    const char              *pPattern,
    UnzipEnumFilesCallBack  *pCallBack,
    void                    *pExtraData
)
{
    pEnumFilesCallBack  = pCallBack;
    pEnumFilesExtraData = pExtraData;
    return SVUnzip(pZipFilePath, pPattern , "v", NULL);
}
