/*************************************************************************
 *
 *  $RCSfile: rapofflinestoragestream.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGESTREAM_HXX
#include "rapofflinestoragestream.hxx"
#endif

#ifndef _COM_SUN_STAR_IO_BUFFERSIZEEXCEEDEDEXCEPTION_HPP_
#include "com/sun/star/io/BufferSizeExceededException.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_NOTCONNECTEDEXCEPTION_HPP_
#include "com/sun/star/io/NotConnectedException.hpp"
#endif

using namespace com::sun;
using ucprmt::offline::StorageStream;
using ucprmt::offline::StorageStreamModificationListener;

StorageStream::StorageStream(
    store::OStoreStream const & rStream,
    rtl::Reference< StorageStreamModificationListener > const & rListener):
    m_aStream(rStream),
    m_xListener(rListener),
    m_nPosition(0),
    m_bClosed(false)
{}

star::uno::Reference< star::io::XInputStream > SAL_CALL
StorageStream::getInputStream()
    throw (star::uno::RuntimeException)
{
    return this;
}

star::uno::Reference< star::io::XOutputStream > SAL_CALL
StorageStream::getOutputStream()
    throw (star::uno::RuntimeException)
{
    return this;
}

sal_Int32 SAL_CALL
StorageStream::readBytes(star::uno::Sequence< sal_Int8 > & rData,
                         sal_Int32 nBytesToRead)
    throw (star::io::IOException, star::uno::RuntimeException)
{
    if (nBytesToRead < 0)
        throw star::io::IOException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "nBytesToRead < 0")),
                  *this);
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    rData.realloc(nBytesToRead);
    sal_Int32 i = 0;
    while (i < nBytesToRead)
    {
        sal_uInt32 nDone;
        storeError eError = m_aStream.readAt(m_nPosition,
                                             rData.getArray() + i,
                                             nBytesToRead - i,
                                             nDone);
        if (eError != store_E_None)
            throw star::io::IOException(
                      rtl::OUString(
                          RTL_CONSTASCII_USTRINGPARAM(
                              "error in store::OStoreStream::writeAt()")),
                      *this);
        OSL_ASSERT(nDone <= static_cast< sal_uInt32 >(nBytesToRead - i));
        m_nPosition += nDone;
        i += nDone;
        if (nDone == 0)
            break;
    }
    rData.realloc(i);
    return i;
}

sal_Int32 SAL_CALL
StorageStream::readSomeBytes(star::uno::Sequence< sal_Int8 > & rData,
                             sal_Int32 nMaxBytesToRead)
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    rData.realloc(nMaxBytesToRead);
    sal_Int32 i = 0;
    if (nMaxBytesToRead > 0)
        do
        {
            sal_uInt32 nDone;
            storeError eError = m_aStream.readAt(m_nPosition,
                                                 rData.getArray(),
                                                 nMaxBytesToRead,
                                                 nDone);
            if (eError != store_E_None)
                throw star::io::IOException(
                          rtl::OUString(
                              RTL_CONSTASCII_USTRINGPARAM(
                                  "error in store::OStoreStream::writeAt()")),
                          *this);
            OSL_ASSERT(nDone <= static_cast< sal_uInt32 >(nMaxBytesToRead));
            m_nPosition += nDone;
            i += nDone;
            if (nDone == 0)
                break;
        }
        while (i == 0);
    rData.realloc(i);
    return i;
}

void SAL_CALL StorageStream::skipBytes(sal_Int32 nBytesToSkip)
    throw (star::io::IOException, star::uno::RuntimeException)
{
    if (nBytesToSkip < 0)
        throw star::io::IOException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "nBytesToSkip < 0")),
                  *this);
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    if (static_cast< sal_uInt32 >(nBytesToSkip) > 0xFFFFFFFF - m_nPosition)
        throw star::io::BufferSizeExceededException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "larger than 2**32")),
                  *this);
    m_nPosition += nBytesToSkip;
}

sal_Int32 SAL_CALL StorageStream::available()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    sal_uInt32 nSize;
    storeError eError = m_aStream.getSize(nSize);
    if (eError != store_E_None)
        throw star::io::IOException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "error in "
                                        "store::OStoreStream::getSize()")),
                  *this);
    return m_nPosition <= nSize ? nSize - m_nPosition : 0;
}

void SAL_CALL StorageStream::closeInput()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bClosed)
    {
        m_aStream.close();
        m_bClosed = true;
    }
}

void SAL_CALL
StorageStream::writeBytes(star::uno::Sequence< sal_Int8 > const & rData)
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    sal_Int32 nLength = rData.getLength();
    if (static_cast< sal_uInt32 >(nLength) > 0xFFFFFFFF - m_nPosition)
        throw star::io::BufferSizeExceededException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "larger than 2**32")),
                  *this);
    bool bNotify = m_xListener.is() != false;
    for (sal_Int32 i = 0; i < nLength;)
    {
        sal_uInt32 nDone;
        storeError eError = m_aStream.writeAt(m_nPosition,
                                              rData.getConstArray() + i,
                                              nLength - i,
                                              nDone);
        if (eError != store_E_None)
            throw star::io::IOException(
                      rtl::OUString(
                          RTL_CONSTASCII_USTRINGPARAM(
                              "error in store::OStoreStream::writeAt()")),
                      *this);
        OSL_ASSERT(nDone <= static_cast< sal_uInt32 >(nLength - i));
        m_nPosition += nDone;
        i += nDone;
        if (bNotify) //TODO! ok to notify only once (and early)?
        {
            m_xListener->notifyStorageStreamModification();
            bNotify = false;
        }
    }
}

void SAL_CALL StorageStream::flush()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    m_aStream.flush();
}

void SAL_CALL StorageStream::closeOutput()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bClosed)
    {
        m_aStream.close();
        m_bClosed = true;
    }
}

void SAL_CALL StorageStream::seek(sal_Int64 nLocation)
    throw (star::lang::IllegalArgumentException,
           star::io::IOException,
           star::uno::RuntimeException)
{
    if (nLocation < 0)
        throw star::lang::IllegalArgumentException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "nLocation < 0")),
                  *this,
                  0);
    else if (nLocation > 0xFFFFFFFF)
        throw star::io::BufferSizeExceededException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "larger than 2**32")),
                  *this);
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    m_nPosition = static_cast< sal_uInt32 >(nLocation);
}

sal_Int64 SAL_CALL StorageStream::getPosition()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    return m_nPosition;
}

sal_Int64 SAL_CALL StorageStream::getLength()
    throw (star::io::IOException, star::uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        throw star::io::NotConnectedException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "already closed")),
                                              *this);
    sal_uInt32 nSize;
    storeError eError = m_aStream.getSize(nSize);
    if (eError != store_E_None)
        throw star::io::IOException(
                  rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                    "error in "
                                        "store::OStoreStream::getSize()")),
                  *this);
    return nSize;
}
